/*
 * Decompiled with CFR 0.152.
 */
package org.adamLTs.adamltsEffectionate.data;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import org.adamLTs.adamltsEffectionate.effect.ModEffects;

public class PlayerEffectData
extends class_18 {
    private final Map<UUID, PlayerData> playerData = new HashMap<UUID, PlayerData>();
    private static final int MAX_LEVEL = 3;
    private static final int MIN_LEVEL_BEFORE_BAN = -3;

    public static PlayerEffectData getServerState(class_1937 world) {
        class_26 persistentStateManager = world.method_8503().method_3847(class_1937.field_25179).method_17983();
        return (PlayerEffectData)persistentStateManager.method_17924(new class_18.class_8645(PlayerEffectData::new, PlayerEffectData::fromNbt, null), "adamlts_effectionate_data");
    }

    public PlayerData getPlayerData(class_3222 player) {
        return this.playerData.computeIfAbsent(player.method_5667(), k -> new PlayerData());
    }

    public void onPlayerKill(class_3222 killer) {
        PlayerData data = this.getPlayerData(killer);
        if (data.level < 3) {
            ++data.level;
        }
        this.method_80();
    }

    public boolean onPlayerDeath(class_3222 player) {
        PlayerData data = this.getPlayerData(player);
        --data.level;
        boolean shouldBan = data.level <= -3;
        this.method_80();
        return shouldBan;
    }

    public static PlayerEffectData fromNbt(class_2487 nbt, class_7225.class_7874 registryLookup) {
        PlayerEffectData data = new PlayerEffectData();
        class_2487 playersNbt = nbt.method_10562("players");
        for (String key : playersNbt.method_10541()) {
            UUID playerUuid = UUID.fromString(key);
            class_2487 playerNbt = playersNbt.method_10562(key);
            String effectTypeName = playerNbt.method_10558("effectType");
            int level = playerNbt.method_10550("level");
            EffectType effectType = EffectType.valueOf(effectTypeName);
            data.playerData.put(playerUuid, new PlayerData(effectType, level));
        }
        return data;
    }

    public class_2487 method_75(class_2487 nbt, class_7225.class_7874 registryLookup) {
        class_2487 playersNbt = new class_2487();
        for (Map.Entry<UUID, PlayerData> entry : this.playerData.entrySet()) {
            class_2487 playerNbt = new class_2487();
            playerNbt.method_10582("effectType", entry.getValue().effectType.name());
            playerNbt.method_10569("level", entry.getValue().level);
            playersNbt.method_10566(entry.getKey().toString(), (class_2520)playerNbt);
        }
        nbt.method_10566("players", (class_2520)playersNbt);
        return nbt;
    }

    public static class PlayerData {
        public EffectType effectType;
        public int level;

        public PlayerData(EffectType effectType, int level) {
            this.effectType = effectType;
            this.level = level;
        }

        public PlayerData() {
            this.effectType = EffectType.getRandomEffect();
            this.level = 1;
        }
    }

    public static enum EffectType {
        STRENGTH((class_6880<class_1291>)class_1294.field_5910, (class_6880<class_1291>)class_1294.field_5911),
        SPEED((class_6880<class_1291>)class_1294.field_5904, (class_6880<class_1291>)class_1294.field_5909),
        RESISTANCE((class_6880<class_1291>)class_1294.field_5907, (class_6880<class_1291>)class_6880.method_40223((Object)ModEffects.VULNERABILITY)),
        HASTE((class_6880<class_1291>)class_1294.field_5917, (class_6880<class_1291>)class_1294.field_5901);

        private final class_6880<class_1291> positiveEffect;
        private final class_6880<class_1291> negativeEffect;

        private EffectType(class_6880<class_1291> positive, class_6880<class_1291> negative) {
            this.positiveEffect = positive;
            this.negativeEffect = negative;
        }

        public class_6880<class_1291> getPositiveEffect() {
            return this.positiveEffect;
        }

        public class_6880<class_1291> getNegativeEffect() {
            return this.negativeEffect;
        }

        public static EffectType getRandomEffect() {
            EffectType[] values = EffectType.values();
            return values[new Random().nextInt(values.length)];
        }
    }
}

