/*
 * Decompiled with CFR 0.152.
 */
package org.adamLTs.adamltsEffectionate.effect;

import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import org.adamLTs.adamltsEffectionate.data.PlayerEffectData;

public class EffectManager {
    private static final int EFFECT_DURATION = -1;
    private static final int MAX_AMPLIFIER = 2;
    private static final int MAX_LEVEL = 3;
    private static final int MIN_LEVEL = -3;

    public static void applyPlayerEffects(class_3222 player, PlayerEffectData serverState) {
        int amplifier;
        class_6880<class_1291> effectToApply;
        boolean isPositive;
        PlayerEffectData.PlayerData data = serverState.getPlayerData(player);
        EffectManager.clearModEffects(player, data.effectType);
        boolean bl = isPositive = data.level > 0;
        if (isPositive) {
            effectToApply = data.effectType.getPositiveEffect();
            amplifier = Math.min(Math.abs(data.level) - 1, 2);
        } else {
            effectToApply = data.effectType.getNegativeEffect();
            amplifier = Math.min(Math.abs(data.level) - 1, 2);
        }
        class_1293 existingEffect = player.method_6112(effectToApply);
        if (existingEffect != null && existingEffect.method_5578() == amplifier) {
            return;
        }
        class_1293 effectInstance = new class_1293(effectToApply, -1, amplifier, false, false, true);
        player.method_6092(effectInstance);
        EffectManager.sendEffectFeedback(player, data, isPositive, amplifier + 1);
    }

    private static void clearModEffects(class_3222 player, PlayerEffectData.EffectType effectType) {
        player.method_6016(effectType.getPositiveEffect());
        player.method_6016(effectType.getNegativeEffect());
        for (PlayerEffectData.EffectType type : PlayerEffectData.EffectType.values()) {
            if (type == effectType) continue;
            player.method_6016(type.getPositiveEffect());
            player.method_6016(type.getNegativeEffect());
        }
    }

    private static void sendEffectFeedback(class_3222 player, PlayerEffectData.PlayerData data, boolean isPositive, int displayLevel) {
        String effectName = EffectManager.getEffectDisplayName(data.effectType);
        class_124 color = isPositive ? class_124.field_1060 : class_124.field_1061;
        String prefix = isPositive ? "+" : "-";
        class_5250 message = class_2561.method_43470((String)String.format("\u00a7%s%s %s %s%d", color.method_532() != null ? Character.valueOf(color.toString().charAt(1)) : "f", prefix, effectName, "Level ", displayLevel));
        player.method_7353((class_2561)message, true);
    }

    private static String getEffectDisplayName(PlayerEffectData.EffectType effectType) {
        return switch (effectType) {
            default -> throw new MatchException(null, null);
            case PlayerEffectData.EffectType.STRENGTH -> "Strength/Weakness";
            case PlayerEffectData.EffectType.SPEED -> "Speed/Slowness";
            case PlayerEffectData.EffectType.RESISTANCE -> "Resistance/Vulnerability";
            case PlayerEffectData.EffectType.HASTE -> "Haste/Mining Fatigue";
        };
    }

    public static void onPlayerLevelChange(class_3222 player, PlayerEffectData serverState, int oldLevel, int newLevel) {
        PlayerEffectData.PlayerData data = serverState.getPlayerData(player);
        if (oldLevel > 0 && newLevel <= 0 || oldLevel <= 0 && newLevel > 0) {
            String changeType = newLevel > 0 ? "positive" : "negative";
            player.method_7353((class_2561)class_2561.method_43470((String)String.format("\u00a76Your %s has switched to %s effects!", EffectManager.getEffectDisplayName(data.effectType), changeType)), false);
        }
        EffectManager.applyPlayerEffects(player, serverState);
    }
}

