/*
 * Decompiled with CFR 0.152.
 */
package org.adamLTs.adamltsEffectionate.system;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.adamLTs.adamltsEffectionate.AdamltsEffectionate;
import org.adamLTs.adamltsEffectionate.config.ConfigManager;
import org.adamLTs.adamltsEffectionate.data.PlayerEffectData;
import org.adamLTs.adamltsEffectionate.effect.EffectManager;

public class AdminTransparencySystem {
    private static final Map<UUID, Long> testModeAdmins = new HashMap<UUID, Long>();
    private static final Map<UUID, class_1934> lastKnownGameModes = new HashMap<UUID, class_1934>();

    public static void initialize() {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            for (class_3222 player : server.method_3760().method_14571()) {
                if (!player.method_5687(2)) continue;
                AdminTransparencySystem.monitorAdminGameMode(player);
            }
        });
        AdamltsEffectionate.LOGGER.info("Admin transparency system initialized");
    }

    private static void monitorAdminGameMode(class_3222 admin) {
        UUID adminId = admin.method_5667();
        class_1934 currentMode = admin.field_13974.method_14257();
        class_1934 lastMode = lastKnownGameModes.get(adminId);
        lastKnownGameModes.put(adminId, currentMode);
        if (currentMode == class_1934.field_9220 && lastMode != class_1934.field_9220 && !AdminTransparencySystem.isInTestMode(adminId)) {
            AdminTransparencySystem.handleUnauthorizedCreative(admin);
        }
        if (currentMode != class_1934.field_9220 && AdminTransparencySystem.isInTestMode(adminId)) {
            AdminTransparencySystem.endTestMode(admin, false);
        }
    }

    private static void handleUnauthorizedCreative(class_3222 admin) {
        admin.method_7336(class_1934.field_9215);
        admin.method_7353((class_2561)class_2561.method_43470((String)"\u00a7c\u00a7l[TRANSPARENCY SYSTEM]\n\u00a7e\u26a0 Creative mode blocked!\n\u00a77Use '/effectionate test' for transparent creative mode.\n\u00a77This prevents secret admin advantages."), false);
        class_5250 broadcastMessage = class_2561.method_43470((String)String.format("\u00a76\u00a7l[ADMIN] \u00a7e%s \u00a77attempted to use creative mode secretly (blocked)", admin.method_5477().getString()));
        admin.method_5682().method_3760().method_43514((class_2561)broadcastMessage, false);
        AdamltsEffectionate.LOGGER.warn("Admin {} attempted unauthorized creative mode", (Object)admin.method_5477().getString());
    }

    public static boolean startTestMode(class_3222 admin) {
        UUID adminId = admin.method_5667();
        if (AdminTransparencySystem.isInTestMode(adminId)) {
            admin.method_7353((class_2561)class_2561.method_43470((String)"\u00a7e\u26a0 You're already in test mode!"), true);
            return false;
        }
        testModeAdmins.put(adminId, System.currentTimeMillis());
        admin.method_7336(class_1934.field_9220);
        admin.method_6012();
        class_5250 testMessage = class_2561.method_43470((String)String.format("\u00a76\u00a7l[TEST MODE] \u00a7e%s \u00a77is now in test mode (Creative)", admin.method_5477().getString()));
        admin.method_5682().method_3760().method_43514((class_2561)testMessage, false);
        admin.method_7353((class_2561)class_2561.method_43470((String)"\u00a7a\u2713 Test mode activated!\n\u00a77\u2022 Creative mode enabled\n\u00a77\u2022 Effects cleared\n\u00a77\u2022 Server notified\n\u00a7bUse '/effectionate test' again to exit"), false);
        List<String> commands = ConfigManager.getTestCommands();
        if (!commands.isEmpty()) {
            MinecraftServer server = admin.method_5682();
            class_2170 manager = server.method_3734();
            class_2168 source = admin.method_5671().method_9206(4);
            for (String cmd : commands) {
                try {
                    try {
                        manager.getClass().getMethod("executeWithPrefix", class_2168.class, String.class).invoke((Object)manager, source, cmd);
                    }
                    catch (NoSuchMethodException e) {
                        manager.getClass().getMethod("execute", class_2168.class, String.class).invoke((Object)manager, source, cmd);
                    }
                }
                catch (Throwable t) {
                    AdamltsEffectionate.LOGGER.error("Failed to run test command '{}': {}", (Object)cmd, (Object)t.toString());
                }
            }
        }
        AdamltsEffectionate.LOGGER.info("Admin {} entered test mode", (Object)admin.method_5477().getString());
        return true;
    }

    public static boolean endTestMode(class_3222 admin, boolean manual) {
        UUID adminId = admin.method_5667();
        if (!AdminTransparencySystem.isInTestMode(adminId)) {
            if (manual) {
                admin.method_7353((class_2561)class_2561.method_43470((String)"\u00a7e\u26a0 You're not in test mode!"), true);
            }
            return false;
        }
        testModeAdmins.remove(adminId);
        admin.method_7336(class_1934.field_9215);
        AdminTransparencySystem.restoreAdminEffects(admin);
        class_5250 endMessage = class_2561.method_43470((String)String.format("\u00a76\u00a7l[TEST MODE] \u00a7e%s \u00a77has exited test mode", admin.method_5477().getString()));
        admin.method_5682().method_3760().method_43514((class_2561)endMessage, false);
        if (manual) {
            admin.method_7353((class_2561)class_2561.method_43470((String)"\u00a7a\u2713 Test mode deactivated!\n\u00a77\u2022 Survival mode restored\n\u00a77\u2022 Effects restored\n\u00a77\u2022 Server notified"), false);
        }
        AdamltsEffectionate.LOGGER.info("Admin {} exited test mode", (Object)admin.method_5477().getString());
        return true;
    }

    private static void restoreAdminEffects(class_3222 admin) {
        PlayerEffectData serverState = PlayerEffectData.getServerState((class_1937)admin.method_51469());
        EffectManager.applyPlayerEffects(admin, serverState);
    }

    public static boolean isInTestMode(UUID adminId) {
        return testModeAdmins.containsKey(adminId);
    }

    public static boolean isInTestMode(class_3222 admin) {
        return AdminTransparencySystem.isInTestMode(admin.method_5667());
    }

    public static void onPlayerDisconnect(UUID playerId) {
        testModeAdmins.remove(playerId);
        lastKnownGameModes.remove(playerId);
    }
}

