/*
 * Decompiled with CFR 0.152.
 */
package org.adamLTs.adamltsEffectionate.event;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.adamLTs.adamltsEffectionate.AdamltsEffectionate;
import org.adamLTs.adamltsEffectionate.data.PlayerEffectData;
import org.adamLTs.adamltsEffectionate.effect.EffectManager;
import org.adamLTs.adamltsEffectionate.system.BanReviveSystem;

public class ModEvents {
    public static void registerEvents() {
        ServerLivingEntityEvents.AFTER_DEATH.register((entity, damageSource) -> {
            if (entity instanceof class_3222) {
                class_3222 deadPlayer = (class_3222)entity;
                ModEvents.handlePlayerDeath(deadPlayer, damageSource);
            }
        });
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> {
            ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
            scheduler.schedule(() -> {
                newPlayer.method_5682().execute(() -> ModEvents.handlePlayerRespawn(newPlayer));
                scheduler.shutdown();
            }, 1L, TimeUnit.SECONDS);
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.method_32311();
            ModEvents.handlePlayerJoin(player);
        });
        AdamltsEffectionate.LOGGER.info("Registered mod events for adamlts-effectionate");
    }

    private static void handlePlayerDeath(class_3222 deadPlayer, class_1282 damageSource) {
        class_3222 killerPlayer;
        PlayerEffectData serverState = PlayerEffectData.getServerState((class_1937)deadPlayer.method_51469());
        PlayerEffectData.PlayerData deadPlayerData = serverState.getPlayerData(deadPlayer);
        int oldLevel = deadPlayerData.level;
        boolean shouldBan = serverState.onPlayerDeath(deadPlayer);
        class_1309 attacker = damageSource.method_5529() instanceof class_1309 ? (class_1309)damageSource.method_5529() : null;
        class_3222 killer = null;
        if (attacker instanceof class_3222 && (killerPlayer = (class_3222)attacker) != deadPlayer) {
            killer = killerPlayer;
            PlayerEffectData.PlayerData killerData = serverState.getPlayerData(killer);
            int killerOldLevel = killerData.level;
            serverState.onPlayerKill(killer);
            if (killerData.level > killerOldLevel) {
                EffectManager.onPlayerLevelChange(killer, serverState, killerOldLevel, killerData.level);
                killer.method_7353((class_2561)class_2561.method_43470((String)String.format("\u00a7a+1 %s level! (Now level %d)", ModEvents.getEffectDisplayName(killerData.effectType), killerData.level)), false);
            } else {
                killer.method_7353((class_2561)class_2561.method_43470((String)"\u00a7e\u26a0 You're at maximum level (3)! No more level ups."), true);
            }
        }
        if (shouldBan) {
            BanReviveSystem.banPlayer(deadPlayer, killer);
            return;
        }
        deadPlayer.method_7353((class_2561)class_2561.method_43470((String)String.format("\u00a7c-1 %s level! (Now level %d)", ModEvents.getEffectDisplayName(deadPlayerData.effectType), deadPlayerData.level)), false);
    }

    private static void handlePlayerRespawn(class_3222 player) {
        PlayerEffectData serverState = PlayerEffectData.getServerState((class_1937)player.method_51469());
        EffectManager.applyPlayerEffects(player, serverState);
        PlayerEffectData.PlayerData playerData = serverState.getPlayerData(player);
        player.method_7353((class_2561)class_2561.method_43470((String)String.format("\u00a76Effects restored: %s (Level %d)", ModEvents.getEffectDisplayName(playerData.effectType), playerData.level)), true);
    }

    private static void handlePlayerJoin(class_3222 player) {
        PlayerEffectData serverState = PlayerEffectData.getServerState((class_1937)player.method_51469());
        PlayerEffectData.PlayerData playerData = serverState.getPlayerData(player);
        if (playerData.level <= -3) {
            playerData.level = 1;
            playerData.effectType = PlayerEffectData.EffectType.getRandomEffect();
            serverState.method_80();
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7a\u2713 You have been revived! Starting fresh with level 1 effects."), false);
        }
        EffectManager.applyPlayerEffects(player, serverState);
        if (playerData.level == 1 && Math.random() < 0.1) {
            player.method_7353((class_2561)class_2561.method_43470((String)String.format("\u00a76Welcome! You've been assigned %s effects. Kill players to level up, but be careful - dying levels you down!\n\u00a7c\u26a0 If you reach -3, you'll be banned until someone revives you!", ModEvents.getEffectDisplayName(playerData.effectType))), false);
        }
    }

    private static String getEffectDisplayName(PlayerEffectData.EffectType effectType) {
        return switch (effectType) {
            default -> throw new MatchException(null, null);
            case PlayerEffectData.EffectType.STRENGTH -> "Strength/Weakness";
            case PlayerEffectData.EffectType.SPEED -> "Speed/Slowness";
            case PlayerEffectData.EffectType.RESISTANCE -> "Resistance/Vulnerability";
            case PlayerEffectData.EffectType.HASTE -> "Haste/Mining Fatigue";
        };
    }
}

