/*
 * Decompiled with CFR 0.152.
 */
package org.adamLTs.adamltsEffectionate.item;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import org.adamLTs.adamltsEffectionate.command.EffectCommands;
import org.adamLTs.adamltsEffectionate.data.PlayerEffectData;
import org.adamLTs.adamltsEffectionate.effect.EffectManager;
import org.adamLTs.adamltsEffectionate.item.ModItems;

public class PotionHandler {
    public static void registerPotionHandlers() {
        UseItemCallback.EVENT.register(PotionHandler::onUseItem);
    }

    private static class_1271<class_1799> onUseItem(class_1657 player, class_1937 world, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (!(player instanceof class_3222)) {
            return class_1271.method_22430((Object)stack);
        }
        class_3222 serverPlayer = (class_3222)player;
        if (stack.method_7909() == ModItems.LEVEL_UP_POTION) {
            return PotionHandler.useLevelUpPotion(serverPlayer, stack, world);
        }
        if (stack.method_7909() == ModItems.REROLL_POTION) {
            return PotionHandler.useRerollPotion(serverPlayer, stack, world);
        }
        return class_1271.method_22430((Object)stack);
    }

    private static class_1271<class_1799> useLevelUpPotion(class_3222 player, class_1799 stack, class_1937 world) {
        if (world.field_9236) {
            return class_1271.method_22430((Object)stack);
        }
        PlayerEffectData serverState = PlayerEffectData.getServerState(world);
        PlayerEffectData.PlayerData data = serverState.getPlayerData(player);
        int oldLevel = data.level;
        if (data.level >= 3) {
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7e\u26a0 You're already at maximum level (3)! Cannot level up further."), true);
            return class_1271.method_22431((Object)stack);
        }
        ++data.level;
        serverState.method_80();
        EffectManager.onPlayerLevelChange(player, serverState, oldLevel, data.level);
        player.method_37908().method_8396(null, player.method_24515(), class_3417.field_14709, class_3419.field_15248, 1.0f, 1.2f);
        player.method_7353((class_2561)class_2561.method_43470((String)String.format("\u00a7a\u2726 Level Up Potion consumed! %s is now level %d", PotionHandler.getEffectDisplayName(data.effectType), data.level)), false);
        if (!player.method_31549().field_7477) {
            stack.method_7934(1);
        }
        return class_1271.method_22427((Object)stack);
    }

    private static class_1271<class_1799> useRerollPotion(class_3222 player, class_1799 stack, class_1937 world) {
        PlayerEffectData.EffectType newEffect;
        if (world.field_9236) {
            return class_1271.method_22430((Object)stack);
        }
        PlayerEffectData serverState = PlayerEffectData.getServerState(world);
        PlayerEffectData.PlayerData data = serverState.getPlayerData(player);
        PlayerEffectData.EffectType oldEffect = data.effectType;
        int oldLevel = data.level;
        while ((newEffect = PlayerEffectData.EffectType.getRandomEffect()) == oldEffect && PlayerEffectData.EffectType.values().length > 1) {
        }
        PlayerEffectData.EffectType finalNewEffect = newEffect;
        PlayerEffectData.EffectType finalOldEffect = oldEffect;
        player.method_6012();
        player.method_37908().method_8396(null, player.method_24515(), class_3417.field_20613, class_3419.field_15248, 1.0f, 1.0f);
        player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7c\u26a1 All effects cleared! Rerolling in 1 second..."), true);
        if (EffectCommands.trackRerollUsage) {
            PotionHandler.broadcastRerollUsage(player, finalOldEffect, finalNewEffect);
        }
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        scheduler.schedule(() -> {
            player.method_5682().execute(() -> {
                data.effectType = finalNewEffect;
                serverState.method_80();
                EffectManager.onPlayerLevelChange(player, serverState, oldLevel, data.level);
                player.method_37908().method_8396(null, player.method_24515(), class_3417.field_15119, class_3419.field_15248, 1.0f, 0.8f);
                player.method_7353((class_2561)class_2561.method_43470((String)String.format("\u00a7d\u2728 Reroll complete! Changed from %s to %s (Level %d)", PotionHandler.getEffectDisplayName(finalOldEffect), PotionHandler.getEffectDisplayName(finalNewEffect), data.level)), false);
            });
            scheduler.shutdown();
        }, 1L, TimeUnit.SECONDS);
        if (!player.method_31549().field_7477) {
            stack.method_7934(1);
        }
        return class_1271.method_22427((Object)stack);
    }

    private static void broadcastRerollUsage(class_3222 player, PlayerEffectData.EffectType oldEffect, PlayerEffectData.EffectType newEffect) {
        double x = (double)Math.round(player.method_23317() * 10.0) / 10.0;
        double y = (double)Math.round(player.method_23318() * 10.0) / 10.0;
        double z = (double)Math.round(player.method_23321() * 10.0) / 10.0;
        String dimension = player.method_37908().method_27983().method_29177().toString();
        PlayerEffectData serverState = PlayerEffectData.getServerState((class_1937)player.method_51469());
        PlayerEffectData.PlayerData data = serverState.getPlayerData(player);
        class_5250 adminMessage = class_2561.method_43470((String)String.format("\u00a76[\u00a7cADMIN\u00a76] \u00a7e%s \u00a77used \u00a7dReroll Potion \u00a77at [\u00a7b%.1f, %.1f, %.1f\u00a77] in \u00a7a%s\n\u00a77Changed from \u00a7c%s \u00a77to \u00a79%s \u00a77(Level %d preserved)", player.method_5477().getString(), x, y, z, dimension, PotionHandler.getEffectDisplayName(oldEffect), PotionHandler.getEffectDisplayName(newEffect), data.level));
        for (class_3222 adminPlayer : player.method_5682().method_3760().method_14571()) {
            if (!adminPlayer.method_5687(2)) continue;
            adminPlayer.method_7353((class_2561)adminMessage, false);
        }
        player.method_5682().method_43496((class_2561)class_2561.method_43470((String)String.format("[REROLL] %s used Reroll Potion at [%.1f, %.1f, %.1f] in %s (changed %s -> %s, level %d preserved)", player.method_5477().getString(), x, y, z, dimension, PotionHandler.getEffectDisplayName(oldEffect), PotionHandler.getEffectDisplayName(newEffect), data.level)));
    }

    private static String getEffectDisplayName(PlayerEffectData.EffectType effectType) {
        return switch (effectType) {
            default -> throw new MatchException(null, null);
            case PlayerEffectData.EffectType.STRENGTH -> "Strength/Weakness";
            case PlayerEffectData.EffectType.SPEED -> "Speed/Slowness";
            case PlayerEffectData.EffectType.RESISTANCE -> "Resistance/Vulnerability";
            case PlayerEffectData.EffectType.HASTE -> "Haste/Mining Fatigue";
        };
    }
}

