/*
 * Decompiled with CFR 0.152.
 */
package org.adamLTs.adamltsEffectionate.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1297;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.adamLTs.adamltsEffectionate.AdamltsEffectionate;
import org.adamLTs.adamltsEffectionate.data.PlayerEffectData;
import org.adamLTs.adamltsEffectionate.effect.EffectManager;
import org.adamLTs.adamltsEffectionate.system.AdminTransparencySystem;
import org.adamLTs.adamltsEffectionate.system.BanReviveSystem;

public class EffectCommands {
    public static boolean trackRerollUsage = true;

    public static void registerCommands() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> EffectCommands.registerEffectCommands((CommandDispatcher<class_2168>)dispatcher));
    }

    private static void registerEffectCommands(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"effectionate").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"setlevel").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer((int)-100, (int)100)).executes(EffectCommands::setPlayerLevel))))).then(class_2170.method_9247((String)"addlevel").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)-100, (int)100)).executes(EffectCommands::addPlayerLevel))))).then(class_2170.method_9247((String)"info").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).executes(EffectCommands::showPlayerInfo)))).then(class_2170.method_9247((String)"reset").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).executes(EffectCommands::resetPlayer)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tracking").then(class_2170.method_9247((String)"on").executes(EffectCommands::enableRerollTracking))).then(class_2170.method_9247((String)"off").executes(EffectCommands::disableRerollTracking))).executes(EffectCommands::showRerollTrackingStatus))).then(class_2170.method_9247((String)"revive").then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.string()).executes(EffectCommands::revivePlayer)))).then(class_2170.method_9247((String)"banned").executes(EffectCommands::listBannedPlayers))).then(class_2170.method_9247((String)"adminreset").executes(EffectCommands::adminReset))).then(class_2170.method_9247((String)"test").executes(EffectCommands::testMode))).then(class_2170.method_9247((String)"withdraw").executes(EffectCommands::withdrawLevel)));
    }

    private static int setPlayerLevel(CommandContext<class_2168> context) {
        try {
            Collection targets = class_2186.method_9312(context, (String)"targets");
            int level = IntegerArgumentType.getInteger(context, (String)"level");
            class_2168 source = (class_2168)context.getSource();
            for (class_3222 player : targets) {
                PlayerEffectData serverState = PlayerEffectData.getServerState((class_1937)player.method_51469());
                PlayerEffectData.PlayerData data = serverState.getPlayerData(player);
                int oldLevel = data.level;
                data.level = level;
                serverState.method_80();
                EffectManager.onPlayerLevelChange(player, serverState, oldLevel, level);
                source.method_9226(() -> class_2561.method_43470((String)String.format("Set %s's %s level to %d", player.method_5477().getString(), EffectCommands.getEffectDisplayName(data.effectType), level)), true);
            }
            return targets.size();
        }
        catch (Exception e) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Error setting player level: " + e.getMessage())));
            return 0;
        }
    }

    private static int addPlayerLevel(CommandContext<class_2168> context) {
        try {
            Collection targets = class_2186.method_9312(context, (String)"targets");
            int amount = IntegerArgumentType.getInteger(context, (String)"amount");
            class_2168 source = (class_2168)context.getSource();
            for (class_3222 player : targets) {
                PlayerEffectData serverState = PlayerEffectData.getServerState((class_1937)player.method_51469());
                PlayerEffectData.PlayerData data = serverState.getPlayerData(player);
                int oldLevel = data.level;
                data.level += amount;
                serverState.method_80();
                EffectManager.onPlayerLevelChange(player, serverState, oldLevel, data.level);
                source.method_9226(() -> class_2561.method_43470((String)String.format("Changed %s's %s level by %+d (now %d)", player.method_5477().getString(), EffectCommands.getEffectDisplayName(data.effectType), amount, data.level)), true);
            }
            return targets.size();
        }
        catch (Exception e) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Error changing player level: " + e.getMessage())));
            return 0;
        }
    }

    private static int showPlayerInfo(CommandContext<class_2168> context) {
        try {
            Collection targets = class_2186.method_9312(context, (String)"targets");
            class_2168 source = (class_2168)context.getSource();
            for (class_3222 player : targets) {
                PlayerEffectData serverState = PlayerEffectData.getServerState((class_1937)player.method_51469());
                PlayerEffectData.PlayerData data = serverState.getPlayerData(player);
                String status = data.level > 0 ? "Positive" : (data.level < 0 ? "Negative" : "Neutral");
                source.method_9226(() -> class_2561.method_43470((String)String.format("%s: %s (Level %d, %s)", player.method_5477().getString(), EffectCommands.getEffectDisplayName(data.effectType), data.level, status)), false);
            }
            return targets.size();
        }
        catch (Exception e) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Error getting player info: " + e.getMessage())));
            return 0;
        }
    }

    private static int resetPlayer(CommandContext<class_2168> context) {
        try {
            Collection targets = class_2186.method_9312(context, (String)"targets");
            class_2168 source = (class_2168)context.getSource();
            for (class_3222 player : targets) {
                PlayerEffectData serverState = PlayerEffectData.getServerState((class_1937)player.method_51469());
                PlayerEffectData.PlayerData data = serverState.getPlayerData(player);
                int oldLevel = data.level;
                data.effectType = PlayerEffectData.EffectType.getRandomEffect();
                data.level = 1;
                serverState.method_80();
                EffectManager.onPlayerLevelChange(player, serverState, oldLevel, 1);
                source.method_9226(() -> class_2561.method_43470((String)String.format("Reset %s to %s (Level 1)", player.method_5477().getString(), EffectCommands.getEffectDisplayName(data.effectType))), true);
            }
            return targets.size();
        }
        catch (Exception e) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Error resetting player: " + e.getMessage())));
            return 0;
        }
    }

    private static int enableRerollTracking(CommandContext<class_2168> context) {
        trackRerollUsage = true;
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7a\u2714 Reroll potion usage tracking is now ENABLED"), true);
        return 1;
    }

    private static int disableRerollTracking(CommandContext<class_2168> context) {
        trackRerollUsage = false;
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7c\u2716 Reroll potion usage tracking is now DISABLED"), true);
        return 1;
    }

    private static int showRerollTrackingStatus(CommandContext<class_2168> context) {
        String status = trackRerollUsage ? "\u00a7aENABLED" : "\u00a7cDISABLED";
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("\u00a76Reroll potion usage tracking is currently %s\n\u00a77Use '/effectionate tracking on' or '/effectionate tracking off' to toggle", status)), false);
        return 1;
    }

    private static int revivePlayer(CommandContext<class_2168> context) {
        try {
            String playerName = StringArgumentType.getString(context, (String)"player");
            class_2168 source = (class_2168)context.getSource();
            class_1297 class_12972 = source.method_9228();
            if (!(class_12972 instanceof class_3222)) {
                source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players"));
                return 0;
            }
            class_3222 reviver = (class_3222)class_12972;
            if (!BanReviveSystem.canRevive(reviver, playerName)) {
                source.method_9213((class_2561)class_2561.method_43470((String)String.format("\u00a7c\u2716 You cannot revive %s.\n\u00a77\u2022 Only the killer can immediately revive\n\u00a77\u2022 OPs can revive after 10 minutes\n\u00a77\u2022 Player may not be banned by this system", playerName)));
                return 0;
            }
            boolean success = BanReviveSystem.revivePlayer(reviver, playerName);
            if (success) {
                source.method_9226(() -> class_2561.method_43470((String)String.format("\u00a7a\u2713 Successfully revived %s!\n\u00a77They can now rejoin the server with level 1 effects.", playerName)), true);
                return 1;
            }
            source.method_9213((class_2561)class_2561.method_43470((String)String.format("\u00a7c\u2716 Failed to revive %s. They may not be banned.", playerName)));
            return 0;
        }
        catch (Exception e) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Error reviving player: " + e.getMessage())));
            return 0;
        }
    }

    private static int listBannedPlayers(CommandContext<class_2168> context) {
        Map<UUID, UUID> bannedPlayers = BanReviveSystem.getBannedPlayers();
        class_2168 source = (class_2168)context.getSource();
        if (bannedPlayers.isEmpty()) {
            source.method_9226(() -> class_2561.method_43470((String)"\u00a77No players are currently banned by the effect system."), false);
            return 1;
        }
        StringBuilder message = new StringBuilder("\u00a76Banned Players (Effect System):\n");
        message.append(String.format("\u00a77\u2022 %d players banned for reaching -3 effect level\n", bannedPlayers.size()));
        message.append("\u00a77\u2022 Use /banlist to see all banned players\n");
        message.append("\u00a77\u2022 Use /effectionate revive <player> to revive them");
        source.method_9226(() -> class_2561.method_43470((String)message.toString()), false);
        return bannedPlayers.size();
    }

    private static int adminReset(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_1297 class_12972 = source.method_9228();
        if (!(class_12972 instanceof class_3222)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players"));
            return 0;
        }
        class_3222 player = (class_3222)class_12972;
        if (!player.method_5687(2)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7c\u2716 This command is only for admins (OP level 2+)"));
            return 0;
        }
        player.method_7336(class_1934.field_9215);
        PlayerEffectData serverState = PlayerEffectData.getServerState((class_1937)player.method_51469());
        PlayerEffectData.PlayerData data = serverState.getPlayerData(player);
        if (data.level != 1) {
            data.level = 1;
            serverState.method_80();
        }
        EffectManager.applyPlayerEffects(player, serverState);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a7a\u2713 Admin reset complete!\n\u00a77\u2022 Game mode: Survival\n\u00a77\u2022 Effect level: 1\n\u00a77\u2022 Ready to play!"), false);
        AdamltsEffectionate.LOGGER.info("Admin {} used adminreset command", (Object)player.method_5477().getString());
        return 1;
    }

    private static int testMode(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_1297 class_12972 = source.method_9228();
        if (!(class_12972 instanceof class_3222)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players"));
            return 0;
        }
        class_3222 player = (class_3222)class_12972;
        if (!player.method_5687(2)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7c\u2716 This command is only for admins (OP level 2+)"));
            return 0;
        }
        if (AdminTransparencySystem.isInTestMode(player)) {
            AdminTransparencySystem.endTestMode(player, true);
        } else {
            AdminTransparencySystem.startTestMode(player);
        }
        return 1;
    }

    private static int withdrawLevel(CommandContext<class_2168> context) {
        String colorCode;
        String levelStatus;
        class_2168 source = (class_2168)context.getSource();
        class_1297 class_12972 = source.method_9228();
        if (!(class_12972 instanceof class_3222)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players"));
            return 0;
        }
        class_3222 player = (class_3222)class_12972;
        PlayerEffectData serverState = PlayerEffectData.getServerState((class_1937)player.method_51469());
        PlayerEffectData.PlayerData data = serverState.getPlayerData(player);
        int oldLevel = data.level;
        if (data.level <= -2) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7c\u2716 Cannot withdraw at level -2!\n\u00a77Withdrawing would result in a ban (level -3).\n\u00a7eUse with caution - you're already in danger!"));
            return 0;
        }
        --data.level;
        serverState.method_80();
        EffectManager.onPlayerLevelChange(player, serverState, oldLevel, data.level);
        if (data.level > 0) {
            levelStatus = "positive";
            colorCode = "\u00a7a";
        } else if (data.level == 0) {
            levelStatus = "neutral (no effect)";
            colorCode = "\u00a7e";
        } else if (data.level == -1) {
            levelStatus = "negative (vulnerable)";
            colorCode = "\u00a7c";
        } else {
            levelStatus = "critically negative (one death from ban!)";
            colorCode = "\u00a74";
        }
        source.method_9226(() -> class_2561.method_43470((String)String.format("\u00a76\u2699 Level withdrawn!\n\u00a77\u2022 %s: %d \u2192 %d\n\u00a77\u2022 Status: %s%s\n\u00a77\u2022 Effects updated", EffectCommands.getEffectDisplayName(data.effectType), oldLevel, data.level, colorCode, levelStatus)), false);
        if (data.level == -2) {
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7c\u26a0\u26a0\u26a0 DANGER WARNING \u26a0\u26a0\u26a0\n\u00a7cYou are now at level -2!\n\u00a7cOne more death will result in a BAN!\n\u00a7eBe extremely careful in combat!"), false);
        } else if (data.level == -1) {
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7e\u26a0 You are now at negative level -1\n\u00a77Two deaths away from ban. Stay alert!"), true);
        }
        AdamltsEffectionate.LOGGER.info("Player {} withdrew a level ({} -> {})", new Object[]{player.method_5477().getString(), oldLevel, data.level});
        return 1;
    }

    private static String getEffectDisplayName(PlayerEffectData.EffectType effectType) {
        return switch (effectType) {
            default -> throw new MatchException(null, null);
            case PlayerEffectData.EffectType.STRENGTH -> "Strength/Weakness";
            case PlayerEffectData.EffectType.SPEED -> "Speed/Slowness";
            case PlayerEffectData.EffectType.RESISTANCE -> "Resistance/Vulnerability";
            case PlayerEffectData.EffectType.HASTE -> "Haste/Mining Fatigue";
        };
    }
}

