/*
 * Decompiled with CFR 0.152.
 */
package org.adamLTs.adamltsEffectionate.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String CONFIG_FILE_NAME = "adamlts-effectionate.json";
    private static final List<String> testCommands = new ArrayList<String>();

    public static void load() {
        Path configPath = ConfigManager.getConfigPath();
        testCommands.clear();
        if (Files.exists(configPath, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(configPath);){
                JsonObject root = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                if (root != null && root.has("testCommands")) {
                    JsonArray arr = root.getAsJsonArray("testCommands");
                    for (JsonElement el : arr) {
                        String cmd;
                        if (!el.isJsonPrimitive() || (cmd = el.getAsString().trim()).isEmpty()) continue;
                        testCommands.add(cmd);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (testCommands.isEmpty()) {
            testCommands.add("time set day");
        }
    }

    public static void save() {
        Path configPath = ConfigManager.getConfigPath();
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        JsonObject root = new JsonObject();
        JsonArray arr = new JsonArray();
        for (String cmd : testCommands) {
            arr.add(cmd);
        }
        root.add("testCommands", (JsonElement)arr);
        try (BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);){
            GSON.toJson((JsonElement)root, (Appendable)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static List<String> getTestCommands() {
        return Collections.unmodifiableList(testCommands);
    }

    public static void setTestCommands(List<String> commands) {
        testCommands.clear();
        for (String cmd : commands) {
            String c = ConfigManager.sanitize(cmd);
            if (c.isEmpty()) continue;
            testCommands.add(c);
        }
        ConfigManager.save();
    }

    public static void addTestCommand(String command) {
        String c = ConfigManager.sanitize(command);
        if (!c.isEmpty()) {
            testCommands.add(c);
            ConfigManager.save();
        }
    }

    public static void removeTestCommand(int index) {
        if (index >= 0 && index < testCommands.size()) {
            testCommands.remove(index);
            ConfigManager.save();
        }
    }

    private static String sanitize(String cmd) {
        if (cmd == null) {
            return "";
        }
        if ((cmd = cmd.trim()).startsWith("/")) {
            cmd = cmd.substring(1);
        }
        return cmd;
    }

    private static Path getConfigPath() {
        return FabricLoader.getInstance().getConfigDir().resolve(CONFIG_FILE_NAME);
    }
}

