/*
 * Decompiled with CFR 0.152.
 */
package org.adamLTs.adamltsEffectionate.system;

import com.mojang.authlib.GameProfile;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3312;
import net.minecraft.class_3330;
import net.minecraft.class_3336;
import net.minecraft.class_5250;
import org.adamLTs.adamltsEffectionate.AdamltsEffectionate;
import org.adamLTs.adamltsEffectionate.data.PlayerEffectData;

public class BanReviveSystem {
    private static final Map<UUID, UUID> bannedPlayers = new HashMap<UUID, UUID>();
    private static final Map<UUID, Long> banTimestamps = new HashMap<UUID, Long>();

    public static void banPlayer(class_3222 player, class_3222 killer) {
        UUID killerUuid;
        UUID playerUuid = player.method_5667();
        UUID uUID = killerUuid = killer != null ? killer.method_5667() : null;
        if (player.method_5687(2)) {
            BanReviveSystem.spectateAdmin(player, killer);
            return;
        }
        bannedPlayers.put(playerUuid, killerUuid);
        banTimestamps.put(playerUuid, System.currentTimeMillis());
        String banReason = killer != null ? String.format("Effect level reached -3. Killed by %s. Use /effectionate revive to be unbanned.", killer.method_5477().getString()) : "Effect level reached -3. Use /effectionate revive to be unbanned.";
        class_3336 banEntry = new class_3336(player.method_7334(), new Date(), "AdamLts-Effectionate System", null, banReason);
        player.method_5682().method_3760().method_14563().method_14633((class_3330)banEntry);
        class_5250 banMessage = killer != null ? class_2561.method_43470((String)String.format("\u00a7c\u26a0 %s has been banned for reaching -3 effect level! Killed by %s", player.method_5477().getString(), killer.method_5477().getString())) : class_2561.method_43470((String)String.format("\u00a7c\u26a0 %s has been banned for reaching -3 effect level!", player.method_5477().getString()));
        player.method_5682().method_3760().method_43514((class_2561)banMessage, false);
        player.field_13987.method_52396((class_2561)class_2561.method_43470((String)"\u00a7c\u00a7lBANNED!\n\n\u00a77Your effect level reached -3\n\u00a77Use /effectionate revive to be unbanned\n\n\u00a76Banned by AdamLts-Effectionate"));
        AdamltsEffectionate.LOGGER.info("Banned player {} for reaching -3 effect level", (Object)player.method_5477().getString());
    }

    private static void spectateAdmin(class_3222 admin, class_3222 killer) {
        admin.method_6012();
        admin.method_7336(class_1934.field_9219);
        PlayerEffectData serverState = PlayerEffectData.getServerState((class_1937)admin.method_51469());
        PlayerEffectData.PlayerData data = serverState.getPlayerData(admin);
        data.level = 1;
        data.effectType = PlayerEffectData.EffectType.getRandomEffect();
        serverState.method_80();
        admin.method_7353((class_2561)class_2561.method_43470((String)"\u00a76\u00a7l[ADMIN PROTECTION]\n\u00a7e\u26a0 Your effect level reached -3!\n\u00a77You've been put in spectator mode instead of being banned.\n\u00a77Your effects have been reset to level 1.\n\u00a7bUse /gamemode survival to return to play."), false);
        class_5250 adminMessage = killer != null ? class_2561.method_43470((String)String.format("\u00a76\u00a7l[ADMIN] \u00a7e%s reached -3 effect level but was protected! Put in spectator mode. Killed by %s", admin.method_5477().getString(), killer.method_5477().getString())) : class_2561.method_43470((String)String.format("\u00a76\u00a7l[ADMIN] \u00a7e%s reached -3 effect level but was protected! Put in spectator mode.", admin.method_5477().getString()));
        admin.method_5682().method_3760().method_43514((class_2561)adminMessage, false);
        AdamltsEffectionate.LOGGER.info("Admin {} reached -3 effect level - put in spectator mode instead of banning", (Object)admin.method_5477().getString());
    }

    public static boolean canRevive(class_3222 reviver, String bannedPlayerName) {
        try {
            Long banTime;
            class_3312 userCache = reviver.method_5682().method_3793();
            if (userCache == null) {
                return false;
            }
            Optional profile = userCache.method_14515(bannedPlayerName);
            if (profile.isEmpty()) {
                return false;
            }
            UUID bannedUuid = ((GameProfile)profile.get()).getId();
            UUID killerUuid = bannedPlayers.get(bannedUuid);
            if (killerUuid != null && killerUuid.equals(reviver.method_5667())) {
                return true;
            }
            if (reviver.method_5687(2) && (banTime = banTimestamps.get(bannedUuid)) != null) {
                long timePassed = System.currentTimeMillis() - banTime;
                return timePassed > 600000L;
            }
            return false;
        }
        catch (Exception e) {
            AdamltsEffectionate.LOGGER.error("Error checking revive permission", (Throwable)e);
            return false;
        }
    }

    public static boolean revivePlayer(class_3222 reviver, String bannedPlayerName) {
        try {
            class_3312 userCache = reviver.method_5682().method_3793();
            if (userCache == null) {
                return false;
            }
            Optional profile = userCache.method_14515(bannedPlayerName);
            if (profile.isEmpty()) {
                return false;
            }
            UUID bannedUuid = ((GameProfile)profile.get()).getId();
            if (!bannedPlayers.containsKey(bannedUuid)) {
                return false;
            }
            reviver.method_5682().method_3760().method_14563().method_14635((Object)((GameProfile)profile.get()));
            PlayerEffectData serverState = PlayerEffectData.getServerState((class_1937)reviver.method_51469());
            PlayerEffectData.PlayerData data = new PlayerEffectData.PlayerData();
            data.level = 1;
            bannedPlayers.remove(bannedUuid);
            banTimestamps.remove(bannedUuid);
            class_5250 reviveMessage = class_2561.method_43470((String)String.format("\u00a7a\u2713 %s has been revived by %s! They can now rejoin the server.", bannedPlayerName, reviver.method_5477().getString()));
            reviver.method_5682().method_3760().method_43514((class_2561)reviveMessage, false);
            AdamltsEffectionate.LOGGER.info("{} revived banned player {}", (Object)reviver.method_5477().getString(), (Object)bannedPlayerName);
            return true;
        }
        catch (Exception e) {
            AdamltsEffectionate.LOGGER.error("Error reviving player", (Throwable)e);
            return false;
        }
    }

    public static Map<UUID, UUID> getBannedPlayers() {
        return new HashMap<UUID, UUID>(bannedPlayers);
    }

    public static boolean isBanned(UUID playerUuid) {
        return bannedPlayers.containsKey(playerUuid);
    }
}

