/*
 * Decompiled with CFR 0.152.
 */
package com.styenvy.mcooxidizer;

import com.styenvy.mcooxidizer.OxidizerBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OxidizerBlock
extends Block
implements EntityBlock {
    public OxidizerBlock(BlockBehaviour.Properties p) {
        super(p);
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new OxidizerBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return level.isClientSide ? null : (lvl, pos, st, be) -> {
            if (be instanceof OxidizerBlockEntity) {
                OxidizerBlockEntity e = (OxidizerBlockEntity)be;
                OxidizerBlockEntity.serverTick(lvl, pos, st, e);
            }
        };
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hit) {
        if (!level.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            BlockEntity be = level.getBlockEntity(pos);
            if (be instanceof MenuProvider) {
                MenuProvider provider = (MenuProvider)be;
                sp.openMenu(provider, buf -> buf.writeBlockPos(pos));
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    @NotNull
    public ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (!level.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            BlockEntity be = level.getBlockEntity(pos);
            if (be instanceof MenuProvider) {
                MenuProvider provider = (MenuProvider)be;
                sp.openMenu(provider, buf -> buf.writeBlockPos(pos));
            }
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }
}

