/*
 * Decompiled with CFR 0.152.
 */
package com.styenvy.mcooxidizer;

import com.styenvy.mcooxidizer.MCOxTags;
import com.styenvy.mcooxidizer.ModConfigs;
import com.styenvy.mcooxidizer.ModContent;
import com.styenvy.mcooxidizer.OxidizerMenu;
import com.styenvy.mcooxidizer.OxidizerSTick;
import com.styenvy.mcooxidizer.StageChipItem;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OxidizerBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler inv = new ItemStackHandler(4){

        protected void onContentsChanged(int slot) {
            OxidizerBlockEntity.this.setChanged();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> OxidizerBlockEntity.isCopperBlock(stack);
                case 1 -> OxidizerBlockEntity.isWaxPrecursor(stack);
                case 2 -> stack.getItem() instanceof StageChipItem;
                default -> false;
            };
        }
    };
    private final EnergyStorage energy = new NotifyingEnergyStorage((Integer)ModConfigs.BUFFER_FE.get(), this::sync);
    private int progress = 0;
    private int maxProgress = (Integer)ModConfigs.PROCESS_TICKS.get();
    private final ContainerData data = new SimpleContainerData(4){

        public int get(int i) {
            return switch (i) {
                case 0 -> OxidizerBlockEntity.this.progress;
                case 1 -> OxidizerBlockEntity.this.maxProgress;
                case 2 -> OxidizerBlockEntity.this.energy.getEnergyStored();
                case 3 -> OxidizerBlockEntity.this.energy.getMaxEnergyStored();
                default -> 0;
            };
        }

        public void set(int i, int v) {
            if (i == 0) {
                OxidizerBlockEntity.this.progress = v;
            } else if (i == 1) {
                OxidizerBlockEntity.this.maxProgress = v;
            }
        }

        public int getCount() {
            return 4;
        }
    };
    private final IItemHandler itemIOAnySideHandler = new IItemHandler(){

        public int getSlots() {
            return 4;
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return OxidizerBlockEntity.this.inv.getStackInSlot(slot);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (slot == 0 || slot == 1) {
                if (!OxidizerBlockEntity.this.inv.isItemValid(slot, stack)) {
                    return stack;
                }
                return OxidizerBlockEntity.this.inv.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 3) {
                return OxidizerBlockEntity.this.inv.extractItem(3, amount, simulate);
            }
            return ItemStack.EMPTY;
        }

        public int getSlotLimit(int slot) {
            return OxidizerBlockEntity.this.inv.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return (slot == 0 || slot == 1) && OxidizerBlockEntity.this.inv.isItemValid(slot, stack);
        }
    };
    private final IEnergyStorage externalEnergy = new IEnergyStorage(){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return OxidizerBlockEntity.this.energy.receiveEnergy(maxReceive, simulate);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return OxidizerBlockEntity.this.energy.getEnergyStored();
        }

        public int getMaxEnergyStored() {
            return OxidizerBlockEntity.this.energy.getMaxEnergyStored();
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }
    };

    private void sync() {
        this.setChanged();
        if (this.level != null && !this.level.isClientSide()) {
            BlockState st = this.getBlockState();
            this.level.sendBlockUpdated(this.worldPosition, st, st, 3);
        }
    }

    public @NotNull ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookup) {
        return this.saveWithoutMetadata(lookup);
    }

    public void handleUpdateTag(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookup) {
        this.loadAdditional(tag, lookup);
    }

    public OxidizerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModContent.OXIDIZER_BE.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, OxidizerBlockEntity be) {
        OxidizerSTick.tick(level, pos, state, be);
    }

    private static boolean isCopperBlock(ItemStack s) {
        return s.is(MCOxTags.COPPER_INPUTS) || s.is(MCOxTags.WAXED_COPPER_INPUTS);
    }

    private static boolean isWaxPrecursor(ItemStack s) {
        if (s.isEmpty()) {
            return false;
        }
        if (((Boolean)ModConfigs.ALLOW_HONEYCOMB.get()).booleanValue() && s.is(Items.HONEYCOMB)) {
            return true;
        }
        return (Boolean)ModConfigs.ALLOW_OIL_TAG.get() != false && s.is(MCOxTags.WAX_PRECURSORS);
    }

    public IEnergyStorage getEnergy() {
        return this.energy;
    }

    public ItemStackHandler getInv() {
        return this.inv;
    }

    public ContainerData getData() {
        return this.data;
    }

    public IItemHandler getItemHandlerForSide(@Nullable Direction side) {
        return this.itemIOAnySideHandler;
    }

    public IEnergyStorage getExternalEnergy() {
        return this.externalEnergy;
    }

    public void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookup) {
        super.loadAdditional(tag, lookup);
        this.progress = tag.getInt("Progress");
        this.maxProgress = tag.getInt("MaxProgress");
        if (tag.contains("FE")) {
            this.energy.deserializeNBT(lookup, Objects.requireNonNull(tag.get("FE")));
        }
        if (tag.contains("Items")) {
            this.inv.deserializeNBT(lookup, tag.getCompound("Items"));
        }
    }

    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookup) {
        super.saveAdditional(tag, lookup);
        tag.putInt("Progress", this.progress);
        tag.putInt("MaxProgress", this.maxProgress);
        tag.put("FE", this.energy.serializeNBT(lookup));
        tag.put("Items", (Tag)this.inv.serializeNBT(lookup));
    }

    public AbstractContainerMenu createMenu(int id, @NotNull Inventory inv, @NotNull Player player) {
        return new OxidizerMenu(id, inv, this, this.data);
    }

    public @NotNull Component getDisplayName() {
        return Component.translatable((String)"block.mcooxidizer.oxidizer");
    }

    private static final class NotifyingEnergyStorage
    extends EnergyStorage {
        private final Runnable onChange;

        private NotifyingEnergyStorage(int capacity, Runnable onChange) {
            super(capacity);
            this.onChange = onChange;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int r = super.receiveEnergy(maxReceive, simulate);
            if (r > 0 && !simulate) {
                this.onChange.run();
            }
            return r;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int r = super.extractEnergy(maxExtract, simulate);
            if (r > 0 && !simulate) {
                this.onChange.run();
            }
            return r;
        }
    }
}

