/*
 * Decompiled with CFR 0.152.
 */
package com.styenvy.mcooxidizer;

import com.styenvy.mcooxidizer.ModContent;
import com.styenvy.mcooxidizer.OxidizerBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public final class OxidizerMenu
extends AbstractContainerMenu {
    public static final int IDX_INPUT_COPPER = 0;
    public static final int IDX_INPUT_CHIP = 1;
    public static final int IDX_INPUT_WAX = 2;
    public static final int IDX_OUTPUT = 3;
    private static final int MACHINE_SLOTS = 4;
    private static final int PLAYER_INV_ROWS = 3;
    private static final int PLAYER_INV_COLS = 9;
    private static final int PLAYER_INV_SLOTS = 27;
    private static final int PLAYER_HOTBAR_SLOTS = 9;
    private final ContainerData data;

    public static OxidizerMenu fromNetwork(int id, Inventory inv, FriendlyByteBuf buf) {
        BlockPos pos = buf.readBlockPos();
        OxidizerBlockEntity be = (OxidizerBlockEntity)inv.player.level().getBlockEntity(pos);
        if (be == null) {
            throw new IllegalStateException("Oxidizer BE missing at " + String.valueOf(pos));
        }
        return new OxidizerMenu(id, inv, be, (ContainerData)new SimpleContainerData(4));
    }

    public OxidizerMenu(int id, Inventory playerInv, OxidizerBlockEntity be, ContainerData data) {
        super((MenuType)ModContent.OXIDIZER_MENU.get(), id);
        this.data = data;
        this.addDataSlots(data);
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)be.getInv(), 0, 25, 46));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)be.getInv(), 1, 46, 46));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)be.getInv(), 2, 68, 46));
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)be.getInv(), 3, 135, 46){

            public boolean mayPlace(@NotNull ItemStack s) {
                return false;
            }
        });
        for (int r = 0; r < 3; ++r) {
            for (int c = 0; c < 9; ++c) {
                this.addSlot(new Slot((Container)playerInv, 9 + r * 9 + c, 8 + c * 18, 84 + r * 18));
            }
        }
        for (int h = 0; h < 9; ++h) {
            this.addSlot(new Slot((Container)playerInv, h, 8 + h * 18, 142));
        }
    }

    public boolean stillValid(@NotNull Player p) {
        return true;
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        ItemStack ret = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack stack = slot.getItem();
            ret = stack.copy();
            int playerEndEx = 40;
            if (index < 4) {
                if (!this.moveItemStackTo(stack, 4, playerEndEx, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(stack, ret);
            } else if (!(this.moveItemStackTo(stack, 1, 2, false) || this.moveItemStackTo(stack, 2, 3, false) || this.moveItemStackTo(stack, 0, 1, false))) {
                return ItemStack.EMPTY;
            }
            if (stack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return ret;
    }

    public int progress() {
        return this.data.get(0);
    }

    public int maxProgress() {
        return Math.max(1, this.data.get(1));
    }

    public int energy() {
        return this.data.get(2);
    }

    public int energyMax() {
        return Math.max(1, this.data.get(3));
    }
}

