/*
 * Decompiled with CFR 0.152.
 */
package com.styenvy.mcooxidizer;

import com.styenvy.mcooxidizer.CopperTransform;
import com.styenvy.mcooxidizer.MCOxTags;
import com.styenvy.mcooxidizer.ModConfigs;
import com.styenvy.mcooxidizer.OxidizerBlockEntity;
import com.styenvy.mcooxidizer.StageChipItem;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.ItemStackHandler;

public final class OxidizerSTick {
    private OxidizerSTick() {
    }

    public static void tick(Level level, BlockPos pos, BlockState state, OxidizerBlockEntity be) {
        ItemStackHandler inv = be.getInv();
        IEnergyStorage energy = be.getEnergy();
        ItemStack in = inv.getStackInSlot(0);
        ItemStack chip = inv.getStackInSlot(2);
        if (in.isEmpty() || !OxidizerSTick.isCopperBlock(in) || !(chip.getItem() instanceof StageChipItem)) {
            be.getData().set(0, 0);
            be.setChanged();
            return;
        }
        boolean wantWaxed = OxidizerSTick.isWaxedInput(in) || OxidizerSTick.isWaxPrecursor(inv.getStackInSlot(1));
        ItemStack result = CopperTransform.compute(in, ((StageChipItem)chip.getItem()).getStage(), wantWaxed);
        if (result.isEmpty()) {
            be.getData().set(0, 0);
            be.setChanged();
            return;
        }
        if (!OxidizerSTick.canOutput(inv, result)) {
            be.getData().set(0, 0);
            be.setChanged();
            return;
        }
        int ept = (Integer)ModConfigs.ENERGY_PER_TICK.get();
        if (energy.getEnergyStored() < ept) {
            return;
        }
        energy.extractEnergy(ept, false);
        int progress = be.getData().get(0);
        int max = Math.max(1, be.getData().get(1));
        be.getData().set(0, ++progress);
        if (progress >= max) {
            boolean inputWasWaxed = OxidizerSTick.isWaxedInput(in);
            boolean needConsumeWax = !inputWasWaxed && OxidizerSTick.isWaxPrecursor(inv.getStackInSlot(1));
            in.shrink(1);
            if (needConsumeWax) {
                inv.extractItem(1, 1, false);
            }
            OxidizerSTick.insertOutput(inv, result);
            be.getData().set(0, 0);
        }
        be.setChanged();
    }

    private static boolean isCopperBlock(ItemStack s) {
        return s.is(MCOxTags.COPPER_INPUTS) || s.is(MCOxTags.WAXED_COPPER_INPUTS);
    }

    private static boolean isWaxedInput(ItemStack s) {
        return s.is(MCOxTags.WAXED_COPPER_INPUTS);
    }

    private static boolean isWaxPrecursor(ItemStack s) {
        if (s.isEmpty()) {
            return false;
        }
        if (((Boolean)ModConfigs.ALLOW_HONEYCOMB.get()).booleanValue() && s.is(Items.HONEYCOMB)) {
            return true;
        }
        return (Boolean)ModConfigs.ALLOW_OIL_TAG.get() != false && s.is(MCOxTags.WAX_PRECURSORS);
    }

    private static boolean canOutput(ItemStackHandler inv, ItemStack stack) {
        ItemStack cur = inv.getStackInSlot(3);
        if (cur.isEmpty()) {
            return true;
        }
        if (!ItemStack.isSameItemSameComponents((ItemStack)cur, (ItemStack)stack)) {
            return false;
        }
        return cur.getCount() + stack.getCount() <= cur.getMaxStackSize();
    }

    private static void insertOutput(ItemStackHandler inv, ItemStack stack) {
        ItemStack cur = inv.getStackInSlot(3);
        if (cur.isEmpty()) {
            inv.setStackInSlot(3, stack.copy());
        } else {
            cur.grow(stack.getCount());
            inv.setStackInSlot(3, cur);
        }
    }
}

