/*
 * Decompiled with CFR 0.152.
 */
package com.styenvy.mcooxidizer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.styenvy.mcooxidizer.OxidizerMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public final class OxidizerScreen
extends AbstractContainerScreen<OxidizerMenu> {
    private static final ResourceLocation BG = ResourceLocation.fromNamespaceAndPath((String)"mcooxidizer", (String)"textures/gui/oxidizer_screen.png");
    private static final int TITLE_X = 9;
    private static final int TITLE_Y = 7;
    private static final int PROG_X = 24;
    private static final int PROG_Y = 27;
    private static final int OUT_X = 135;
    private static final int OUT_Y = 46;
    private static final int FE_X = 158;
    private static final int FE_Y = 15;
    private static final int SLOT_W = 18;
    private static final int SLOT_H = 18;
    private static final int SLOT3_X = 66;
    private static final int SLOT3_Y = 46;

    public OxidizerScreen(OxidizerMenu menu, Inventory inv, Component ignoredTitle) {
        super((AbstractContainerMenu)menu, inv, (Component)Component.literal((String)"Oxidizer"));
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    protected void init() {
        super.init();
        this.titleLabelX = 9;
        this.titleLabelY = 7;
    }

    protected void renderBg(GuiGraphics g, float partial, int mx, int my) {
        RenderSystem.enableBlend();
        g.blit(BG, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        int thirdRight = this.leftPos + 66 + 18;
        int outputLeft = this.leftPos + 135;
        int gap = Math.max(0, outputLeft - thirdRight);
        int aw = Math.min(40, Math.max(24, gap - 8));
        int ah = 12;
        int centerX = thirdRight + gap / 2;
        int ax = centerX - aw / 2;
        int ay = this.topPos + 46 + 9 - ah / 2;
        float prog = (float)((OxidizerMenu)this.menu).progress() / (float)((OxidizerMenu)this.menu).maxProgress();
        OxidizerScreen.drawProgressArrow(g, ax, ay, aw, ah, prog);
        int eW = 8;
        int eH = 58;
        int eX = this.leftPos + 158;
        int eY = this.topPos + 15;
        g.drawString(this.font, (Component)Component.literal((String)"FE"), eX - 1, eY - 10, -16777216, false);
        g.fill(eX - 1, eY - 1, eX + eW + 1, eY + eH + 1, -14671840);
        g.fill(eX, eY, eX + eW, eY + eH, -14013910);
        int eFill = (int)((float)eH * ((float)((OxidizerMenu)this.menu).energy() / (float)((OxidizerMenu)this.menu).energyMax()));
        g.fill(eX, eY + (eH - eFill), eX + eW, eY + eH, -16740097);
    }

    public void render(@NotNull GuiGraphics g, int mx, int my, float partial) {
        this.renderBackground(g, mx, my, partial);
        super.render(g, mx, my, partial);
        int eW = 8;
        int eH = 58;
        int eX = this.leftPos + 158;
        int eY = this.topPos + 15;
        if (mx >= eX && mx < eX + eW && my >= eY && my < eY + eH) {
            g.renderTooltip(this.font, (Component)Component.literal((String)(((OxidizerMenu)this.menu).energy() + " / " + ((OxidizerMenu)this.menu).energyMax() + " FE")), mx, my);
        }
        this.renderTooltip(g, mx, my);
    }

    private static void drawProgressArrow(GuiGraphics g, int x, int y, int w, int h, float progress) {
        int remaining;
        progress = Math.max(0.0f, Math.min(1.0f, progress));
        if (w <= 4 || h <= 3) {
            return;
        }
        g.fill(x, y, x + w, y + 1, -14671840);
        g.fill(x, y + h - 1, x + w, y + h, -14671840);
        g.fill(x, y, x + 1, y + h, -14671840);
        g.fill(x + w - 1, y, x + w, y + h, -14671840);
        g.fill(x + 1, y + 1, x + w - 1, y + h - 1, -15066598);
        int innerX = x + 1;
        int innerY = y + 1;
        int innerW = w - 2;
        int innerH = h - 2;
        int headW = Math.max(4, h / 2);
        int shaftW = Math.max(0, innerW - headW);
        int filled = Math.round(progress * (float)innerW);
        int shaftFill = Math.min(filled, shaftW);
        if (shaftFill > 0) {
            g.fill(innerX, innerY, innerX + shaftFill, innerY + innerH, -16724907);
        }
        if ((remaining = filled - shaftFill) > 0) {
            int headStartX = innerX + shaftW;
            int slices = Math.min(remaining, headW);
            for (int i = 0; i < slices; ++i) {
                int sliceX = headStartX + i;
                float t = ((float)i + 0.5f) / (float)headW;
                int half = Math.max(0, Math.round((float)innerH / 2.0f * (1.0f - t)));
                int y1 = innerY + innerH / 2 - half;
                int y2 = innerY + innerH / 2 + half + 1;
                g.fill(sliceX, y1, sliceX + 1, y2, -16724907);
            }
        }
    }
}

