/*
 * Decompiled with CFR 0.152.
 */
package com.liba.menu;

import com.liba.menu.MenuSlot;
import com.liba.utils.MinecraftColor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public abstract class Menu
implements InventoryHolder {
    String title;
    Inventory inventory;
    OpenInvenyoryAction openAction;
    GlobalAction globalAction;
    TopInventoryClick topInventoryClick;
    BottomInventoryClick bottomInventoryClick;
    List<Player> vievers = new ArrayList<Player>();
    HashMap<Integer, MenuSlot> buttonHashMap = new HashMap();
    Player owner;

    public Menu(String title, int size) {
        this.title = MinecraftColor.format(title);
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)size, (String)title);
    }

    public Menu(String title, int size, Player player) {
        this(title, size);
        this.owner = player;
    }

    public abstract void setItems();

    public void addSlot(int slotid, MenuSlot menuSlot) {
        this.buttonHashMap.put(slotid, menuSlot);
        this.inventory.setItem(slotid, menuSlot.getButton().getItem());
    }

    public void open(Player p) {
        this.vievers.add(p);
        if (this.openAction != null) {
            this.openAction.open(p);
        }
        this.setItems();
        p.openInventory(this.inventory);
    }

    public void close(Player p) {
        this.vievers.remove(p);
    }

    public BottomInventoryClick getBottomInventoryClick() {
        return this.bottomInventoryClick;
    }

    public void setBottomInventoryClick(BottomInventoryClick bottomInventoryClick) {
        this.bottomInventoryClick = bottomInventoryClick;
    }

    public TopInventoryClick getTopInventoryClick() {
        return this.topInventoryClick;
    }

    public void setTopInventoryClick(TopInventoryClick topInventoryClick) {
        this.topInventoryClick = topInventoryClick;
    }

    public OpenInvenyoryAction getOpenAction() {
        return this.openAction;
    }

    public void setOpenAction(OpenInvenyoryAction openAction) {
        this.openAction = openAction;
    }

    public GlobalAction getGlobalAction() {
        return this.globalAction;
    }

    public void setGlobalAction(GlobalAction globalAction) {
        this.globalAction = globalAction;
    }

    public List<Player> getVievers() {
        return this.vievers;
    }

    public ClickAction getClickAction(int slot) {
        return ((MenuSlot)this.buttonHashMap.getOrDefault((Object)Integer.valueOf((int)slot), null)).clickAction;
    }

    public void updateSlot(int slot) {
        MenuSlot menuSlot = this.getMenuSlot(slot);
        if (menuSlot != null) {
            this.getInventory().setItem(slot, menuSlot.getButton().getItem());
        } else {
            this.getInventory().setItem(slot, null);
        }
    }

    public MenuSlot getMenuSlot(int slot) {
        return this.buttonHashMap.getOrDefault(slot, null);
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public Player getOwner() {
        return this.owner;
    }

    public static interface OpenInvenyoryAction {
        public void open(Player var1);
    }

    public static interface BottomInventoryClick {
        public void click(Player var1, InventoryClickEvent var2);
    }

    public static interface TopInventoryClick {
        public void click(Player var1, InventoryClickEvent var2);
    }

    public static interface GlobalAction {
        public void click(Player var1, InventoryClickEvent var2);
    }

    public static interface ClickAction {
        public void click(Player var1, InventoryClickEvent var2);
    }
}

