/*
 * Decompiled with CFR 0.152.
 */
package com.modencore;

import com.modencore.TreeCapitator;
import com.modencore.gui.user.UserMenu;
import java.io.File;
import java.io.IOException;
import org.bukkit.Particle;
import org.bukkit.configuration.file.YamlConfiguration;

public class PlayerConfig {
    boolean cantreecapitate = true;
    Particle treecuteEffect;
    int blockcutes;
    UserMenu menu = new UserMenu(this);
    String playername;
    File f;
    YamlConfiguration config;

    public PlayerConfig(String playername) {
        File dir = new File(String.valueOf(TreeCapitator.treeCapitator.getDataFolder()) + File.separator + "playerdata");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.playername = playername;
        this.f = new File(String.valueOf(TreeCapitator.treeCapitator.getDataFolder()) + File.separator + "playerdata" + File.separator + playername + ".yml");
        if (!this.f.exists()) {
            try {
                this.f.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.config = YamlConfiguration.loadConfiguration((File)this.f);
            this.saveData();
        } else {
            this.config = YamlConfiguration.loadConfiguration((File)this.f);
        }
        this.loadData();
    }

    public void loadData() {
        this.cantreecapitate = this.config.getBoolean("cantreecapitate");
        this.blockcutes = this.config.getInt("blockcutes");
        String particle = this.config.getString("particle");
        if (particle != null) {
            this.treecuteEffect = Particle.valueOf((String)this.config.getString("particle"));
        }
    }

    public void saveData() {
        this.config.set("cantreecapitate", (Object)this.cantreecapitate);
        this.config.set("blockcutes", (Object)this.blockcutes);
        if (this.getTreecuteEffect() != null) {
            this.config.set("particle", (Object)this.getTreecuteEffect().name());
        }
        try {
            this.config.save(this.f);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isCantreecapitate() {
        return this.cantreecapitate;
    }

    public void setCantreecapitate(boolean cantreecapitate) {
        this.cantreecapitate = cantreecapitate;
    }

    public UserMenu getMenu() {
        return this.menu;
    }

    public Particle getTreecuteEffect() {
        return this.treecuteEffect;
    }

    public void setTreecuteEffect(Particle treecuteEffect) {
        this.treecuteEffect = treecuteEffect;
    }

    public int getBlockcutes() {
        return this.blockcutes;
    }

    public void setBlockcutes(int blockcutes) {
        this.blockcutes = blockcutes;
    }

    public String getPlayername() {
        return this.playername;
    }
}

