/*
 * Decompiled with CFR 0.152.
 */
package com.modencore;

import com.liba.inject.InjectPlugin;
import com.liba.utils.ItemUtil;
import com.modencore.LogBlock;
import com.modencore.LogEntry;
import com.modencore.TreeCapitator;
import com.modencore.datastorage.DbStorage;
import com.modencore.lang.Config;
import com.modencore.listener.TreeChopEvent;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Tree {
    final List<Block> blockList;
    InjectPlugin mcmmo = TreeCapitator.getInstance().getMcmmo();
    InjectPlugin quests = TreeCapitator.getInstance().getQuests();
    Player player;
    int leavesfindradius = 2;
    Material material;
    Config config;

    public Tree(List<Block> blockList, Player player, Material material) {
        this.blockList = blockList;
        this.player = player;
        this.material = material;
        this.config = TreeCapitator.getInstance().getConfigStorage();
        if (TreeCapitator.getInstance().getLogblock().isInjected()) {
            this.leavesfindradius = 3;
        }
    }

    public Enchantment getEnchant() {
        try {
            Field unbreakingField = Enchantment.class.getField("UNBREAKING");
            return (Enchantment)unbreakingField.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            try {
                Field durabilityField = Enchantment.class.getField("DURABILITY");
                return (Enchantment)durabilityField.get(null);
            }
            catch (IllegalAccessException | NoSuchFieldException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public void treeFalling(final Player player) {
        if (this.blockList.isEmpty()) {
            return;
        }
        final ItemStack itemOnHand = player.getInventory().getItemInMainHand();
        final Random random = new Random();
        final int dur = this.config.getInt("axe-durability");
        new BukkitRunnable(){
            double chance = 1.0;
            int index = 0;
            int count = 0;

            public void run() {
                if (this.index >= Tree.this.blockList.size()) {
                    int min = Tree.this.blockList.stream().mapToInt(Block::getY).min().getAsInt();
                    Location sapl = Tree.this.blockList.get(0).getLocation().clone();
                    sapl.setY((double)min);
                    if (TreeCapitator.getInstance().getConfigStorage().getBool("plant-sapling")) {
                        Tree.this.plantSapling(Tree.this.material);
                    }
                    TreeCapitator.getInstance().getServer().getPluginManager().callEvent((Event)new TreeChopEvent(player, this.count, Tree.this.material, sapl));
                    this.cancel();
                    return;
                }
                Block block = Tree.this.blockList.get(this.index);
                ++this.index;
                int unbreaking = itemOnHand.getEnchantmentLevel(Tree.this.getEnchant());
                if (unbreaking > 0) {
                    this.chance = 1.0 / (double)(unbreaking + 1);
                }
                if (random.nextDouble() <= this.chance) {
                    if (ItemUtil.getDamage(itemOnHand) == null || ItemUtil.getDamage(itemOnHand) + dur > itemOnHand.getType().getMaxDurability()) {
                        this.cancel();
                        return;
                    }
                    ItemUtil.damageItem(itemOnHand, dur, true);
                }
                if (TreeCapitator.getInstance().getLogblock().isInjected()) {
                    LogBlock.getLogBlockApi().getLastLogAtLocationAsync(block.getWorld().getName(), block.getX(), block.getY(), block.getZ()).thenAcceptAsync(logEntry -> {
                        boolean placedByPlayer;
                        boolean bl = placedByPlayer = logEntry != null && logEntry.getAction().equals((Object)LogEntry.BlockAction.PLACE);
                        if (placedByPlayer) {
                            return;
                        }
                        Bukkit.getScheduler().runTask((Plugin)TreeCapitator.getInstance(), () -> {
                            Tree.this.processBlockBreak(block, player, itemOnHand);
                            ++this.count;
                        });
                    });
                } else {
                    Tree.this.processBlockBreak(block, player, itemOnHand);
                    ++this.count;
                }
            }
        }.runTaskTimer((Plugin)TreeCapitator.getInstance(), 0L, 2L);
    }

    private void processBlockBreak(Block block, Player player, ItemStack tool) {
        this.playEffect(block);
        for (int x = block.getX() - this.leavesfindradius; x < block.getX() + this.leavesfindradius; ++x) {
            for (int y = block.getY() - this.leavesfindradius; y < block.getY() + this.leavesfindradius; ++y) {
                for (int z = block.getZ() - this.leavesfindradius; z < block.getZ() + this.leavesfindradius; ++z) {
                    Block bl = block.getWorld().getBlockAt(x, y, z);
                    if (TreeCapitator.getInstance().getLogblock().isInjected()) {
                        DbStorage.getLastActionAtLocationAsync((String)bl.getWorld().getName(), (int)bl.getX(), (int)bl.getY(), (int)bl.getZ()).thenAcceptAsync(leafEntry -> {
                            boolean placedLeaf;
                            boolean bl2 = placedLeaf = leafEntry != null && leafEntry.getAction().equals((Object)LogEntry.BlockAction.PLACE) && TreeCapitator.getInstance().getLeaves().contains(leafEntry.getMaterial());
                            if (!placedLeaf && TreeCapitator.getInstance().getLeaves().contains(bl.getType())) {
                                Bukkit.getScheduler().runTask((Plugin)TreeCapitator.getInstance(), () -> bl.breakNaturally());
                            }
                        });
                        continue;
                    }
                    if (!bl.getType().name().toLowerCase().endsWith("_leaves")) continue;
                    bl.breakNaturally();
                }
            }
        }
        if (TreeCapitator.getInstance().getLogblock().isInjected()) {
            LogBlock.getLogBlockApi().addLogEntry(new LogEntry(player.getUniqueId(), block.getX(), block.getY(), block.getZ(), block.getWorld().getName(), LogEntry.BlockAction.BREAK, block.getType(), System.currentTimeMillis()));
        }
        block.breakNaturally(tool);
        block.getWorld().playSound(block.getLocation(), Sound.BLOCK_WOOD_BREAK, 1.0f, 1.0f);
    }

    public List<Block> getBlockList() {
        return this.blockList;
    }

    public void plantSapling(Material material) {
        if (this.getBlockList().isEmpty() || this.getBlockList().size() <= 2) {
            return;
        }
        int min = this.getBlockList().stream().mapToInt(Block::getY).min().getAsInt();
        final Location sapl = this.getBlockList().get(0).getLocation().clone();
        sapl.setY((double)min);
        final String type = material.name().replace("LOG", "") + "SAPLING";
        new BukkitRunnable(){

            public void run() {
                Block downBlock = sapl.getBlock().getRelative(BlockFace.DOWN);
                if (downBlock.getType() == Material.GRASS_BLOCK || downBlock.getType() == Material.DIRT) {
                    try {
                        sapl.getBlock().setType(Material.valueOf((String)type));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }.runTaskLater((Plugin)TreeCapitator.getInstance(), 40L);
    }

    public void playEffect(Block block) {
        Random random = new Random();
        if (TreeCapitator.treeCapitator.getPlayerConfig((Player)this.player).treecuteEffect != null) {
            for (int i = 0; i < 5; ++i) {
                float x = (float)(-0.5 + (double)random.nextFloat() * 1.5);
                float y = (float)(-0.5 + (double)random.nextFloat() * 1.5);
                float z = (float)(-0.5 + (double)random.nextFloat() * 1.5);
                Location spawnloc = new Location(block.getWorld(), block.getLocation().getX() + (double)x, block.getLocation().getY() + (double)y, block.getLocation().getZ() + (double)z);
                block.getLocation().getWorld().spawnParticle(TreeCapitator.treeCapitator.getPlayerConfig((Player)this.player).treecuteEffect, spawnloc, 1, 0.3, 0.6, 0.3);
            }
        }
    }
}

