/*
 * Decompiled with CFR 0.152.
 */
package com.modencore;

import com.liba.Liba;
import com.liba.inject.InjectPlugin;
import com.liba.version.VersionChecker;
import com.modencore.PlayerConfig;
import com.modencore.commands.TreeCommands;
import com.modencore.gui.admin.MainMenu;
import com.modencore.lang.Config;
import com.modencore.lang.LoadEffects;
import com.modencore.lang.UserMenuLang;
import com.modencore.listener.ChopedListener;
import com.modencore.listener.LogBreakEvent;
import com.modencore.listener.PlaceholderExpansion;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class TreeCapitator
extends JavaPlugin {
    static TreeCapitator treeCapitator;
    HashMap<UUID, PlayerConfig> playerConfig = new HashMap();
    MainMenu menu;
    Config config;
    List<Material> worked_axes = new ArrayList<Material>();
    List<Material> blocked_trees = new ArrayList<Material>();
    InjectPlugin mcmmo;
    InjectPlugin quests;
    InjectPlugin griefprotection;
    InjectPlugin auraskills;
    InjectPlugin logblock;
    InjectPlugin placeholder;
    UserMenuLang userMenuLang;
    LoadEffects loadEffects;
    List<Material> treeblocks = new ArrayList<Material>();
    Set<String> additionalTreeBlocks = Set.of("CRIMSON_STEM", "WARPED_STEM", "STRIPPED_CRIMSON_STEM", "STRIPPED_WARPED_STEM", "CRIMSON_HYPHAE", "WARPED_HYPHAE", "STRIPPED_CRIMSON_HYPHAE", "STRIPPED_WARPED_HYPHAE");
    List<Material> leaves = new ArrayList<Material>();
    Liba liba;
    private Map<String, Integer> topData = new HashMap<String, Integer>();
    private VersionChecker checker;

    public static TreeCapitator getInstance() {
        return treeCapitator;
    }

    public void onEnable() {
        treeCapitator = this;
        this.loadEffects = new LoadEffects();
        this.liba = new Liba((Plugin)this);
        this.config = new Config();
        this.config.checkStorage();
        this.userMenuLang = new UserMenuLang(String.valueOf(this.getDataFolder()) + File.separator + "gui" + File.separator + "usermenu.yml");
        this.userMenuLang.checkStorage();
        this.mcmmo = new InjectPlugin("mcmmo", null);
        this.quests = new InjectPlugin("quests", "com.leonardobishop.quests.bukkit.BukkitQuestsPlugin");
        this.griefprotection = new InjectPlugin("GriefPrevention", null);
        this.logblock = new InjectPlugin("LogBlock", null);
        if (!this.logblock.isInjected()) {
            Bukkit.getLogger().warning("\u001b[33mLogBlock isn't injected! \u001b[0m");
            Bukkit.getLogger().warning("\u001b[33mInstall the plugin to improve tree detection \u001b[0m");
            Bukkit.getLogger().warning("\u001b[33mDownload link: \u001b[32mhttps://www.curseforge.com/minecraft/bukkit-plugins/logblocks \u001b[0m");
        }
        this.auraskills = new InjectPlugin("AuraSkills", null);
        this.loadWorkedAxe();
        this.loadBlockedTrees();
        this.checker = this.liba.registerVersionChecker(3, "https://www.curseforge.com/minecraft/bukkit-plugins/treetimber");
        this.liba.registerMetrica(20184);
        this.placeholder = new InjectPlugin("PlaceholderAPI", null);
        if (this.placeholder.isInjected()) {
            new PlaceholderExpansion(this.config).register();
        }
        TreeCapitator.getInstance().getServer().getPluginManager().registerEvents((Listener)new LogBreakEvent(this), (Plugin)this);
        TreeCapitator.getInstance().getServer().getPluginCommand("timber").setExecutor((CommandExecutor)new TreeCommands(this));
        TreeCapitator.getInstance().getServer().getPluginManager().registerEvents((Listener)new ChopedListener(), (Plugin)this);
        this.menu = new MainMenu("Timber menu", 3, this);
        this.startTopUpdater();
        this.leaves = Arrays.stream(Material.values()).filter(f -> f.name().toLowerCase().endsWith("_leaves") || f.name().toLowerCase().endsWith("wart_block")).toList();
    }

    public void loadWorkedAxe() {
        List<?> materials = this.config.getParamList("worked-axes");
        materials.removeIf(f -> f.startsWith("#"));
        materials.forEach(e -> {
            if (Material.getMaterial((String)e) != null) {
                this.worked_axes.add(Material.getMaterial((String)e));
            }
        });
    }

    public void loadBlockedTrees() {
        List<?> blocked = this.config.getParamList("blocked-trees");
        blocked.removeIf(f -> f.startsWith("#"));
        blocked.forEach(e -> {
            if (Material.getMaterial((String)e) != null) {
                this.blocked_trees.add(Material.getMaterial((String)e));
            }
        });
    }

    public boolean isLog(Material material) {
        return this.treeblocks.contains(material);
    }

    public void onDisable() {
        this.playerConfig.values().forEach(PlayerConfig::saveData);
        try {
            this.config.setParam("worked-axes", this.worked_axes.stream().map(Enum::name).toList());
            this.config.setParam("blocked-trees", this.blocked_trees.stream().map(Enum::name).toList());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.liba.onDisable();
    }

    public Config getConfigStorage() {
        return this.config;
    }

    public MainMenu getMenu() {
        return this.menu;
    }

    public Map<UUID, PlayerConfig> getPlayerConfig() {
        return this.playerConfig;
    }

    public PlayerConfig getPlayerConfig(Player player) {
        if (this.playerConfig.containsKey(player.getUniqueId())) {
            this.playerConfig.get(player.getUniqueId());
        } else {
            this.playerConfig.put(player.getUniqueId(), new PlayerConfig(player.getName()));
        }
        return this.playerConfig.get(player.getUniqueId());
    }

    public List<Material> getWorked_axes() {
        return this.worked_axes;
    }

    public List<Material> getBlocked_trees() {
        return this.blocked_trees;
    }

    public InjectPlugin getMcmmo() {
        return this.mcmmo;
    }

    public InjectPlugin getQuests() {
        return this.quests;
    }

    public UserMenuLang getUserMenuLang() {
        return this.userMenuLang;
    }

    public VersionChecker getChecker() {
        return this.checker;
    }

    public InjectPlugin getGriefprotection() {
        return this.griefprotection;
    }

    public LoadEffects getLoadEffects() {
        return this.loadEffects;
    }

    public List<Material> getTreeblocks() {
        this.treeblocks = Arrays.stream(Material.values()).filter(mat -> mat.isBlock() && (mat.name().endsWith("_LOG") || mat.name().toLowerCase().endsWith("_wood") || mat.name().toLowerCase().endsWith("_planks") || mat.name().startsWith("STRIPPED_") && (mat.name().contains("_LOG") || mat.name().contains("_WOOD")) || this.additionalTreeBlocks.contains(mat.name()))).collect(Collectors.toList());
        return this.treeblocks;
    }

    private void startTopUpdater() {
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> {
            try {
                File dir = new File(this.getDataFolder(), "playerdata");
                if (!dir.exists()) {
                    return;
                }
                HashMap<String, Integer> newData = new HashMap<String, Integer>();
                File[] files = dir.listFiles((d, n) -> n.endsWith(".yml"));
                if (files == null) {
                    return;
                }
                for (File f : files) {
                    YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)f);
                    int amount = cfg.getInt("blockcutes");
                    newData.put(f.getName().replace(".yml", ""), amount);
                }
                this.topData = newData.entrySet().stream().sorted((a, b) -> ((Integer)b.getValue()).compareTo((Integer)a.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a, LinkedHashMap::new));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, 0L, 1200L);
    }

    public Map<String, Integer> getTopData() {
        return this.topData;
    }

    public InjectPlugin getAuraskills() {
        return this.auraskills;
    }

    public InjectPlugin getLogblock() {
        return this.logblock;
    }

    public List<Material> getLeaves() {
        return this.leaves;
    }
}

