/*
 * Decompiled with CFR 0.152.
 */
package com.modencore.gui.admin;

import com.liba.gui.Gui;
import com.liba.gui.ListedGui;
import com.liba.gui.MenuSlot;
import com.liba.gui.buttons.BackButton;
import com.liba.utils.ItemUtil;
import com.modencore.TreeCapitator;
import com.modencore.lang.Config;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class BlockTreesGui
extends ListedGui {
    private final Config config = TreeCapitator.getInstance().getConfigStorage();

    public BlockTreesGui(String title, int rows, List<Material> treeblocks, Gui backGui) {
        super(title, rows, treeblocks, 45, backGui);
        this.setGlobalcancel(true);
    }

    @Override
    public void setInventoryItems() {
        this.getInventory().clear();
        this.menuSlot.clear();
        List<Material> worked = TreeCapitator.getInstance().getBlocked_trees();
        for (int i = 0; i < this.getDataPerPage(); ++i) {
            int id = this.getDataPerPage() * this.getPage() + i;
            if (id >= this.getData().size()) continue;
            Material material = (Material)this.getData().get(id);
            boolean isBlocked = worked.stream().anyMatch(f -> f.equals((Object)material));
            ItemStack itemStack = new ItemStack(isBlocked ? Material.BARRIER : material);
            String displayName = ItemUtil.getMaterialName(material);
            String statusLine = isBlocked ? "\u00a7bStatus: \u00a74Disable" : "\u00a7bStatus: \u00a7aEnable";
            this.addSlot(i, new MenuSlot(ItemUtil.create(itemStack, "\u00a7e" + displayName, " ", "\u00a7bClick to block or to enable", statusLine), e -> {
                if (worked.contains(material)) {
                    worked.removeIf(f -> f.equals((Object)material));
                } else {
                    worked.add(material);
                }
                this.open((Player)e.getWhoClicked());
            }));
        }
        this.addSlot(this.getSlots() - 9, new BackButton(new ItemStack(Material.BARRIER), this.getBackGui(), "Back"));
        super.setInventoryItems();
    }
}

