/*
 * Decompiled with CFR 0.152.
 */
package com.modencore.gui.user;

import com.liba.gui.Gui;
import com.liba.gui.MenuSlot;
import com.liba.utils.ItemUtil;
import com.modencore.PlayerConfig;
import com.modencore.TreeCapitator;
import com.modencore.gui.admin.TreeCuteEffects;
import com.modencore.lang.UserMenuLang;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class UserMenu
extends Gui {
    PlayerConfig config;
    TreeCuteEffects effects;
    UserMenuLang lang;

    public UserMenu(PlayerConfig config) {
        super("User menu", 3);
        this.config = config;
        this.effects = new TreeCuteEffects("Tree cute effects", TreeCapitator.getInstance().getLoadEffects().load(), this, config);
        this.setGlobalcancel(true);
        this.lang = TreeCapitator.getInstance().getUserMenuLang();
        this.setTitle(this.lang.getString("gui.title"));
    }

    @Override
    public void setInventoryItems() {
        this.addSlot(10, new MenuSlot(this.config.isCantreecapitate() ? ItemUtil.create(new ItemStack(Material.GREEN_WOOL), this.lang.getString("treecuting.enable.title"), this.lang.getStringOrList("treecuting.enable.lore")) : ItemUtil.create(new ItemStack(Material.RED_WOOL), this.lang.getString("treecuting.disable.title"), this.lang.getStringOrList("treecuting.disable.lore")), e -> {
            if (e.getWhoClicked().hasPermission("timber.capitate") || !TreeCapitator.getInstance().getConfigStorage().getBool("needsperms") || e.getWhoClicked().hasPermission("*")) {
                this.config.setCantreecapitate(!this.config.isCantreecapitate());
                this.open((Player)e.getWhoClicked());
            } else {
                e.getWhoClicked().sendMessage(this.lang.getString("norightmessage"));
            }
            e.setCancelled(true);
        }));
        if (this.getOwner().hasPermission("timber.useparticle")) {
            this.addSlot(12, new MenuSlot(ItemUtil.create(new ItemStack(Material.REDSTONE), this.lang.getString("effects.title"), this.config.getTreecuteEffect() != null ? this.lang.getString("effects.description").replace("{particle}", this.config.getTreecuteEffect().name()) : this.lang.getString("effects.descriptionnotselected"), this.lang.getString("effects.descriptionselected")), e -> {
                if (e.isLeftClick()) {
                    if (e.getWhoClicked().hasPermission("timber.useparticle") || e.getWhoClicked().hasPermission("*")) {
                        this.effects.open((Player)e.getWhoClicked());
                    } else {
                        e.getWhoClicked().sendMessage(this.lang.getString("norightmessage"));
                    }
                } else {
                    this.effects.playerConfig.setTreecuteEffect(null);
                    this.open((Player)e.getWhoClicked());
                }
                e.setCancelled(true);
            }));
        }
        this.addSlot(14, new MenuSlot(ItemUtil.create(new ItemStack(Material.PAPER), this.lang.getString("gui.logscount.title").replace("{count}", "" + TreeCapitator.getInstance().getPlayerConfig(this.getOwner()).getBlockcutes()), this.lang.getStringOrList("gui.logscount.lore").stream().map(f -> f.replace("{count}", "" + TreeCapitator.getInstance().getPlayerConfig(this.getOwner()).getBlockcutes())).collect(Collectors.toUnmodifiableList())), e -> {}));
    }
}

