/*
 * Decompiled with CFR 0.152.
 */
package com.modencore.lang;

import com.liba.utils.ItemUtil;
import com.liba.utils.MinecraftColor;
import com.liba.utils.headcreator.HeadCache;
import com.modencore.TreeCapitator;
import com.modencore.util.MineEffect;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;

public class LoadEffects {
    File file = new File(String.valueOf(TreeCapitator.getInstance().getDataFolder()) + File.separator + "effects.yml");
    YamlConfiguration config;

    public LoadEffects() {
        if (!this.file.exists()) {
            TreeCapitator.getInstance().saveResource("effects.yml", true);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public List<MineEffect> load() {
        ArrayList<MineEffect> mineEffects = new ArrayList<MineEffect>();
        ConfigurationSection section = this.config.getConfigurationSection("effects");
        for (String string : section.getKeys(false)) {
            ConfigurationSection effect = section.getConfigurationSection(string);
            String particlename = effect.getString("particle");
            String guiitemname = effect.getString("guiitem");
            String title = effect.getString("title");
            try {
                ItemStack itemStack;
                Material guiitem = Material.valueOf((String)guiitemname);
                Particle particle = Particle.valueOf((String)particlename);
                if (guiitem == Material.PLAYER_HEAD) {
                    String skull = effect.getString("skull");
                    itemStack = HeadCache.getItem(skull);
                } else {
                    itemStack = new ItemStack(guiitem);
                }
                ItemUtil.rename(itemStack, title == null ? particle.name() : MinecraftColor.format(title));
                mineEffects.add(new MineEffect(particle, itemStack));
            }
            catch (Exception ignored) {
                Bukkit.getLogger().log(Level.WARNING, "Particle not exist or material, in effects.yml PARTICLE: " + particlename + " ITEM: " + guiitemname);
            }
        }
        return mineEffects;
    }
}

