/*
 * Decompiled with CFR 0.152.
 */
package com.modencore.listener;

import com.liba.dependency.WorldGuardDep;
import com.liba.utils.file.FileChecker;
import com.modencore.PlayerConfig;
import com.modencore.Tree;
import com.modencore.TreeCapitator;
import com.modencore.treefinder.TreeFinder;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class LogBreakEvent
implements Listener {
    public WorldGuardDep dep = new WorldGuardDep();
    public FileChecker cfg;
    TreeCapitator plugin;

    public LogBreakEvent(TreeCapitator plugin) {
        this.plugin = plugin;
        this.cfg = TreeCapitator.getInstance().getConfigStorage();
    }

    private static int getCount(Location location, Block block) {
        int count = 0;
        int radius = 2;
        for (int x = location.getBlockX() - radius; x < location.getBlockX() + radius; ++x) {
            for (int y = location.getBlockY() - radius; y < location.getBlockY() + radius; ++y) {
                for (int z = location.getBlockZ() - radius; z < location.getBlockZ() + radius; ++z) {
                    Location lc = new Location(block.getWorld(), (double)x, (double)y, (double)z);
                    if (!TreeCapitator.getInstance().getLeaves().contains(lc.getBlock().getType())) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    @EventHandler
    public void join(PlayerJoinEvent e) {
    }

    @EventHandler
    public void leave(PlayerQuitEvent e) {
        PlayerConfig config = this.plugin.getPlayerConfig(e.getPlayer());
        config.saveData();
    }

    @EventHandler
    public void logBreakEvent(BlockBreakEvent e) {
        Player player = e.getPlayer();
        Block block = e.getBlock();
        Material material = block.getType();
        if (player.isSneaking()) {
            return;
        }
        if (player.getGameMode() != GameMode.SURVIVAL && player.getGameMode() != GameMode.ADVENTURE) {
            return;
        }
        if (this.cfg.getBool("needsperms") && !player.hasPermission("timber.capitate") && !player.hasPermission("*")) {
            return;
        }
        if (!this.plugin.getPlayerConfig(player).isCantreecapitate()) {
            return;
        }
        if (!TreeCapitator.getInstance().isLog(block.getType())) {
            return;
        }
        if (TreeCapitator.getInstance().getBlocked_trees().contains(block.getType())) {
            return;
        }
        ItemStack itemOnHand = player.getInventory().getItemInHand();
        if (!itemOnHand.getType().name().endsWith("_AXE")) {
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            Tree tree = this.getTree(block, player, material);
            if (this.isTree(tree.getBlockList()) && (TreeCapitator.getInstance().getWorked_axes().isEmpty() || TreeCapitator.getInstance().getWorked_axes().contains(itemOnHand.getType()))) {
                if (this.dep.isEnabled()) {
                    for (Block block1 : tree.getBlockList()) {
                        if (this.dep.checkLocation(block1.getLocation(), player.getUniqueId())) continue;
                        return;
                    }
                }
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> tree.treeFalling(player));
            }
        });
    }

    public boolean isTree(List<Block> blockList) {
        if (TreeFinder.getTreeFinder().equals((Object)TreeFinder.TreeFinderTypes.LOGBLOCK)) {
            return true;
        }
        int maxy = blockList.stream().mapToInt(Block::getY).max().getAsInt();
        if (blockList.get(0).getType().name().endsWith("_STEM")) {
            return true;
        }
        if (blockList.get(0) != null) {
            Location location = blockList.get(0).getLocation();
            location.setY((double)maxy);
            Block block = blockList.get(0).getWorld().getBlockAt(location);
            int count = LogBreakEvent.getCount(location, block);
            return count >= 3;
        }
        return false;
    }

    public Tree getTree(Block block, Player player, Material material) {
        ArrayList<Block> temp = new ArrayList<Block>();
        ArrayList<Block> tree = new ArrayList<Block>();
        temp.add(block);
        tree.add(block);
        while (!temp.isEmpty()) {
            Block block0 = (Block)temp.get(0);
            for (BlockFace face : BlockFace.values()) {
                Block relative = block0.getRelative(face);
                if (!TreeCapitator.getInstance().isLog(relative.getType()) || tree.contains(relative) || TreeCapitator.getInstance().getBlocked_trees().contains(material)) continue;
                tree.add(relative);
                temp.add(relative);
            }
            temp.remove(0);
            int limit = TreeCapitator.getInstance().getConfigStorage().getInt("blocklimit");
            if (limit == 0 || tree.size() < limit) continue;
            return new Tree(tree, player, material);
        }
        return new Tree(tree, player, material);
    }
}

