/*
 * Decompiled with CFR 0.152.
 */
package com.oneaura.cpscounter;

import com.oneaura.cpscounter.CPSManager;
import com.oneaura.cpscounter.config.CPSConfig;
import com.oneaura.cpscounter.configlib.ConfigManager;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_310;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneaurasCPSCounterClient
implements ClientModInitializer {
    public static final String MOD_ID = "cpscounter";
    public static CPSConfig config;
    public static final Logger LOGGER;

    public void onInitializeClient() {
        LOGGER.info("CPS Counter is initializing!");
        config = ConfigManager.register(MOD_ID, CPSConfig.class).orElseThrow(() -> new IllegalStateException("Could not load CPS Counter configuration"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> CPSManager.tick());
        HudRenderCallback.EVENT.register((drawContext, tickDelta) -> {
            if (!OneaurasCPSCounterClient.config.enabled) {
                return;
            }
            class_310 client = class_310.method_1551();
            if (client.field_1724 != null && client.field_1755 == null) {
                int textColor;
                int x;
                int leftCPS = CPSManager.getLeftCPS();
                int rightCPS = CPSManager.getRightCPS();
                String textToRender = leftCPS + " | " + rightCPS + OneaurasCPSCounterClient.config.labelText;
                int textWidth = client.field_1772.method_1727(textToRender);
                int padding = OneaurasCPSCounterClient.config.padding;
                int screenWidth = client.method_22683().method_4486();
                int screenHeight = client.method_22683().method_4502();
                int y = switch (OneaurasCPSCounterClient.config.hudPosition.ordinal()) {
                    case 1 -> {
                        x = screenWidth - textWidth - padding;
                        yield padding;
                    }
                    case 2 -> {
                        x = padding;
                        yield screenHeight - 10 - padding;
                    }
                    case 3 -> {
                        x = screenWidth - textWidth - padding;
                        yield screenHeight - 10 - padding;
                    }
                    default -> {
                        x = padding;
                        yield padding;
                    }
                };
                switch (OneaurasCPSCounterClient.config.textStyle.ordinal()) {
                    case 1: {
                        textToRender = "\u00a7l" + textToRender;
                        break;
                    }
                    case 2: {
                        textToRender = "\u00a7o" + textToRender;
                        break;
                    }
                    case 3: {
                        textToRender = "\u00a7n" + textToRender;
                        break;
                    }
                }
                try {
                    textColor = 0xFF000000 | Integer.parseInt(OneaurasCPSCounterClient.config.textColor.trim(), 16);
                }
                catch (NumberFormatException e) {
                    textColor = -1;
                }
                if (OneaurasCPSCounterClient.config.showBackground) {
                    int backgroundColor;
                    try {
                        backgroundColor = (int)Long.parseLong(OneaurasCPSCounterClient.config.backgroundColor.trim(), 16);
                    }
                    catch (NumberFormatException e) {
                        backgroundColor = Integer.MIN_VALUE;
                    }
                    int x1 = x - 2;
                    int y1 = y - 2;
                    int x2 = x + textWidth + 2;
                    int y2 = y + 10;
                    int radius = OneaurasCPSCounterClient.config.backgroundCornerRadius;
                    if (radius <= 0) {
                        drawContext.method_25294(x1, y1, x2, y2, backgroundColor);
                    } else {
                        drawContext.method_25294(x1 + radius, y1, x2 - radius, y2, backgroundColor);
                        drawContext.method_25294(x1, y1 + radius, x1 + radius, y2 - radius, backgroundColor);
                        drawContext.method_25294(x2 - radius, y1 + radius, x2, y2 - radius, backgroundColor);
                    }
                }
                drawContext.method_51433(client.field_1772, textToRender, x, y, textColor, OneaurasCPSCounterClient.config.textShadow);
            }
        });
    }

    static {
        LOGGER = LoggerFactory.getLogger((String)MOD_ID);
    }

    public static enum HudPosition {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }

    public static enum TextStyle {
        NONE,
        BOLD,
        ITALIC,
        UNDERLINED;

    }
}

