/*
 * Decompiled with CFR 0.152.
 */
package com.oneaura.cpscounter.configlib;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.oneaura.cpscounter.configlib.ConfigHolder;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigManager {
    private static final Map<String, ConfigHolder> configs = new HashMap<String, ConfigHolder>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_DIR = FabricLoader.getInstance().getConfigDir();

    public static <T extends ConfigHolder> Optional<T> register(String modId, Class<T> configClass) {
        try {
            Path path = CONFIG_DIR.resolve(modId + ".json");
            ConfigHolder configInstance = (ConfigHolder)configClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (path.toFile().exists()) {
                ConfigManager.load(configInstance, path);
            }
            ConfigManager.save(configInstance, path);
            configs.put(modId, configInstance);
            return Optional.of(configInstance);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    public static ConfigHolder get(String modId) {
        return configs.get(modId);
    }

    public static void save(String modId) {
        ConfigHolder config = configs.get(modId);
        if (config != null) {
            Path path = CONFIG_DIR.resolve(modId + ".json");
            try {
                ConfigManager.save(config, path);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void save(ConfigHolder config, Path path) throws IOException {
        try (FileWriter writer = new FileWriter(path.toFile());){
            GSON.toJson((Object)config, (Appendable)writer);
        }
    }

    private static void load(ConfigHolder config, Path path) throws IOException, IllegalAccessException {
        try (FileReader reader = new FileReader(path.toFile());){
            ConfigHolder loadedConfig = (ConfigHolder)GSON.fromJson((Reader)reader, config.getClass());
            if (loadedConfig != null) {
                for (Field field : config.getClass().getDeclaredFields()) {
                    field.setAccessible(true);
                    Object loadedValue = field.get(loadedConfig);
                    if (loadedValue == null) continue;
                    field.set(config, loadedValue);
                }
            }
        }
    }
}

