/*
 * Decompiled with CFR 0.152.
 */
package com.example;

import com.example.MacroRecorderConfigManager;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2846;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_3966;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class MacroRecorder {
    private static final class_310 client = class_310.method_1551();
    private static final List<MacroFrame> recordedFrames = new ArrayList<MacroFrame>();
    private static final List<MacroFrame> playbackFrames = new ArrayList<MacroFrame>();
    private static boolean isRecording = false;
    private static boolean isPlaying = false;
    private static int playbackIndex = 0;
    private static int currentRepeat = 0;
    private static final Gson gson = new Gson();
    private static final File macroDir = new File(System.getProperty("user.home") + "/AppData/Roaming/.minecraft/macros");
    private static boolean waitingForInput = false;
    private static boolean showIndicator = MacroRecorderConfigManager.config.showIndicator;
    private static boolean loop = MacroRecorderConfigManager.config.loop;
    private static int startRecordKey = MacroRecorderConfigManager.config.startRecordKey;
    private static int stopRecordKey = MacroRecorderConfigManager.config.stopRecordKey;
    private static Map<String, Integer> macroKeybinds = MacroRecorderConfigManager.config.macroKeybinds;
    private static Map<String, Boolean> waitingForMacroBind = MacroRecorderConfigManager.config.waitingForMacroBind;
    private static boolean waitingForStartKeybind = false;
    private static boolean waitingForStopKeybind = false;
    private static boolean startKeyPressedLastTick = false;
    private static boolean stopKeyPressedLastTick = false;
    private static int skipTicks = 0;
    private static Map<String, Boolean> macroKeyPressedLastTick = new HashMap<String, Boolean>();
    private static boolean recordOnFirstInput = MacroRecorderConfigManager.config.recordOnFirstInput;
    private static boolean recordCamera = MacroRecorderConfigManager.config.recordCamera;
    private static boolean recordCrouch = MacroRecorderConfigManager.config.recordCrouch;
    private static boolean recordJump = MacroRecorderConfigManager.config.recordJump;
    private static boolean recordMovement = MacroRecorderConfigManager.config.recordMovement;
    private static boolean recordSprint = MacroRecorderConfigManager.config.recordSprint;
    private static boolean recordPlace = MacroRecorderConfigManager.config.recordPlace;
    private static boolean recordAttack = MacroRecorderConfigManager.config.recordAttack;
    private static boolean recordUse = MacroRecorderConfigManager.config.recordUse;
    private static boolean recordDrop = MacroRecorderConfigManager.config.recordDrop;
    private static boolean recordSwapHands = MacroRecorderConfigManager.config.recordSwapHands;
    private static boolean playbackCamera = MacroRecorderConfigManager.config.playbackCamera;
    private static boolean playbackCrouch = MacroRecorderConfigManager.config.playbackCrouch;
    private static boolean playbackJump = MacroRecorderConfigManager.config.playbackJump;
    private static boolean playbackMovement = MacroRecorderConfigManager.config.playbackMovement;
    private static boolean playbackSprint = MacroRecorderConfigManager.config.playbackSprint;
    private static boolean playbackPlace = MacroRecorderConfigManager.config.playbackPlace;
    private static boolean playbackAttack = MacroRecorderConfigManager.config.playbackAttack;
    private static boolean playbackUse = MacroRecorderConfigManager.config.playbackUse;
    private static boolean playbackDrop = MacroRecorderConfigManager.config.playbackDrop;
    private static boolean playbackSwapHands = MacroRecorderConfigManager.config.playbackSwapHands;

    private static void updateConfig() {
        MacroRecorderConfigManager.config.showIndicator = showIndicator;
        MacroRecorderConfigManager.config.loop = loop;
        MacroRecorderConfigManager.config.startRecordKey = startRecordKey;
        MacroRecorderConfigManager.config.stopRecordKey = stopRecordKey;
        MacroRecorderConfigManager.config.macroKeybinds = macroKeybinds;
        MacroRecorderConfigManager.config.waitingForMacroBind = waitingForMacroBind;
        MacroRecorderConfigManager.config.recordOnFirstInput = recordOnFirstInput;
        MacroRecorderConfigManager.config.recordCamera = recordCamera;
        MacroRecorderConfigManager.config.recordCrouch = recordCrouch;
        MacroRecorderConfigManager.config.recordJump = recordJump;
        MacroRecorderConfigManager.config.recordMovement = recordMovement;
        MacroRecorderConfigManager.config.recordSprint = recordSprint;
        MacroRecorderConfigManager.config.recordPlace = recordPlace;
        MacroRecorderConfigManager.config.recordAttack = recordAttack;
        MacroRecorderConfigManager.config.recordUse = recordUse;
        MacroRecorderConfigManager.config.recordDrop = recordDrop;
        MacroRecorderConfigManager.config.recordSwapHands = recordSwapHands;
        MacroRecorderConfigManager.config.playbackCamera = playbackCamera;
        MacroRecorderConfigManager.config.playbackCrouch = playbackCrouch;
        MacroRecorderConfigManager.config.playbackJump = playbackJump;
        MacroRecorderConfigManager.config.playbackMovement = playbackMovement;
        MacroRecorderConfigManager.config.playbackSprint = playbackSprint;
        MacroRecorderConfigManager.config.playbackPlace = playbackPlace;
        MacroRecorderConfigManager.config.playbackAttack = playbackAttack;
        MacroRecorderConfigManager.config.playbackUse = playbackUse;
        MacroRecorderConfigManager.config.playbackDrop = playbackDrop;
        MacroRecorderConfigManager.config.playbackSwapHands = playbackSwapHands;
        MacroRecorderConfigManager.save();
    }

    public static void releaseAllKeys() {
        class_310 client = class_310.method_1551();
        client.field_1690.field_1894.method_23481(false);
        client.field_1690.field_1913.method_23481(false);
        client.field_1690.field_1881.method_23481(false);
        client.field_1690.field_1849.method_23481(false);
        client.field_1690.field_1903.method_23481(false);
        client.field_1690.field_1867.method_23481(false);
        client.field_1690.field_1832.method_23481(false);
        client.field_1690.field_1886.method_23481(false);
        client.field_1690.field_1904.method_23481(false);
        client.field_1690.field_1869.method_23481(false);
        client.field_1690.field_1831.method_23481(false);
    }

    public static void init() {
        if (!macroDir.exists()) {
            macroDir.mkdirs();
        }
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            boolean bl;
            boolean startPressed;
            int key;
            if (client.field_1724 == null) {
                return;
            }
            long window = client.method_22683().method_4490();
            if (waitingForStartKeybind || waitingForStopKeybind) {
                for (int key2 = 32; key2 <= 348; ++key2) {
                    if (key2 == 257 || key2 == 335 || !class_3675.method_15987((long)window, (int)key2)) continue;
                    String string = class_3675.method_15985((int)key2, (int)0).method_1441().replace("key.keyboard.", "");
                    if (waitingForStartKeybind) {
                        startRecordKey = key2;
                        waitingForStartKeybind = false;
                        client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a7aStart Recording keybind set to: " + string)), false);
                        skipTicks = 5;
                    } else {
                        stopRecordKey = key2;
                        waitingForStopKeybind = false;
                        client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a7aStop Recording keybind set to: " + string)), false);
                        skipTicks = 5;
                    }
                    MacroRecorder.updateConfig();
                    break;
                }
            }
            block10: for (Map.Entry<String, Boolean> entry : waitingForMacroBind.entrySet()) {
                String filename = entry.getKey();
                if (!entry.getValue().booleanValue()) continue;
                for (key = 32; key <= 348; ++key) {
                    if (key == 257 || key == 335 || !class_3675.method_15987((long)window, (int)key)) continue;
                    macroKeybinds.put(filename, key);
                    waitingForMacroBind.put(filename, false);
                    String keyName = class_3675.method_15985((int)key, (int)0).method_1441().replace("key.keyboard.", "");
                    client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a7aMacro '" + filename + "' bound to key: " + keyName)), false);
                    skipTicks = 5;
                    MacroRecorder.updateConfig();
                    continue block10;
                }
            }
            --skipTicks;
            for (Map.Entry<String, Comparable<Boolean>> entry : macroKeybinds.entrySet()) {
                String name = entry.getKey();
                key = (Integer)entry.getValue();
                boolean wasPressed = macroKeyPressedLastTick.getOrDefault(name, false);
                boolean isPressed = class_3675.method_15987((long)window, (int)key);
                if (isPressed && !wasPressed && skipTicks < 0 && client.field_1755 == null) {
                    File file = new File(macroDir, name + ".json");
                    try (FileReader reader = new FileReader(file);){
                        if (isPlaying) {
                            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cCannot play while recording. Run /macrorecorder stop first."), false);
                        } else {
                            Type listType = new TypeToken<ArrayList<MacroFrame>>(){}.getType();
                            List loaded = (List)gson.fromJson((Reader)reader, listType);
                            playbackFrames.clear();
                            playbackFrames.addAll(loaded);
                            playbackIndex = 0;
                            isPlaying = true;
                            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a7aPlaying macro: " + name)), false);
                            if (loop) {
                                client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a77Note: Macro is set to loop after completing."), false);
                            }
                        }
                    }
                    catch (IOException e) {
                        client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a7cFailed to play bound macro: " + name)), false);
                        e.printStackTrace();
                    }
                }
                macroKeyPressedLastTick.put(name, isPressed);
            }
            boolean bl2 = startPressed = startRecordKey != -1 && class_3675.method_15987((long)window, (int)startRecordKey);
            if (startPressed && !startKeyPressedLastTick && skipTicks < 0 && client.field_1755 == null) {
                if (isPlaying) {
                    isPlaying = false;
                }
                recordedFrames.clear();
                if (!isRecording) {
                    isRecording = true;
                    client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7aRecording started. Run /macrorecorder stop to stop recording."), false);
                } else {
                    client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7aRecording restarted. Run /macrorecorder stop to stop recording."), false);
                }
            }
            startKeyPressedLastTick = startPressed;
            boolean bl3 = bl = startRecordKey != -1 && class_3675.method_15987((long)window, (int)stopRecordKey);
            if (bl && !stopKeyPressedLastTick && skipTicks < 0 && client.field_1755 == null) {
                if (isRecording) {
                    isRecording = false;
                    client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7eRecording stopped."), false);
                } else {
                    client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cUnable to stop recording. You are not recording."), false);
                }
            }
            stopKeyPressedLastTick = bl;
            if (isRecording) {
                if (waitingForInput && (client.field_1690.field_1894.method_1434() || client.field_1690.field_1913.method_1434() || client.field_1690.field_1849.method_1434() || client.field_1690.field_1881.method_1434() || client.field_1690.field_1903.method_1434() || client.field_1690.field_1832.method_1434() || client.field_1690.field_1886.method_1434() || client.field_1690.field_1904.method_1434())) {
                    waitingForInput = false;
                }
                if (!waitingForInput) {
                    MacroFrame newFrame = new MacroFrame(recordCamera ? client.field_1724.method_36454() : Float.MIN_VALUE, recordCamera ? client.field_1724.method_36455() : Float.MIN_VALUE, recordMovement ? Boolean.valueOf(client.field_1690.field_1894.method_1434()) : null, recordMovement ? Boolean.valueOf(client.field_1690.field_1913.method_1434()) : null, recordMovement ? Boolean.valueOf(client.field_1690.field_1881.method_1434()) : null, recordMovement ? Boolean.valueOf(client.field_1690.field_1849.method_1434()) : null, recordJump ? Boolean.valueOf(client.field_1690.field_1903.method_1434()) : null, recordSprint ? Boolean.valueOf(client.field_1690.field_1867.method_1434()) : null, recordCrouch ? Boolean.valueOf(client.field_1690.field_1832.method_1434()) : null, recordAttack ? Boolean.valueOf(client.field_1690.field_1886.method_1434()) : null, recordUse ? Boolean.valueOf(client.field_1690.field_1904.method_1434()) : null, MacroRecorder.getSelectedSlotReflect(client.field_1724), recordDrop ? Boolean.valueOf(client.field_1690.field_1869.method_1434()) : null, recordSwapHands ? Boolean.valueOf(client.field_1690.field_1831.method_1434()) : null, 1);
                    if (!recordedFrames.isEmpty()) {
                        MacroFrame lastFrame = recordedFrames.get(recordedFrames.size() - 1);
                        if (lastFrame.equalsWithoutRepeats(newFrame)) {
                            recordedFrames.set(recordedFrames.size() - 1, lastFrame.withIncreasedRepeats());
                        } else {
                            recordedFrames.add(newFrame);
                        }
                    } else {
                        recordedFrames.add(newFrame);
                    }
                }
            }
            if (isPlaying) {
                if (playbackIndex >= playbackFrames.size() && !loop) {
                    isPlaying = false;
                    MacroRecorder.releaseAllKeys();
                    client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7ePlayback finished and loop set to false. Stopping."), false);
                    return;
                }
                if (playbackIndex >= playbackFrames.size() && loop) {
                    playbackIndex = 0;
                    currentRepeat = 0;
                }
                MacroFrame frame = playbackFrames.get(playbackIndex);
                if (playbackCamera) {
                    if (frame.yaw != Float.MIN_VALUE) {
                        client.field_1724.method_36456(frame.yaw);
                    }
                    if (frame.pitch != Float.MIN_VALUE) {
                        client.field_1724.method_36457(frame.pitch);
                    }
                }
                if (playbackMovement) {
                    if (frame.forward != null) {
                        MacroRecorder.simulateKeyPress(client.field_1690.field_1894, frame.forward);
                    }
                    if (frame.left != null) {
                        MacroRecorder.simulateKeyPress(client.field_1690.field_1913, frame.left);
                    }
                    if (frame.back != null) {
                        MacroRecorder.simulateKeyPress(client.field_1690.field_1881, frame.back);
                    }
                    if (frame.right != null) {
                        MacroRecorder.simulateKeyPress(client.field_1690.field_1849, frame.right);
                    }
                }
                if (playbackJump && frame.jump != null) {
                    MacroRecorder.simulateKeyPress(client.field_1690.field_1903, frame.jump);
                }
                if (playbackSprint && frame.sprint != null) {
                    MacroRecorder.simulateKeyPress(client.field_1690.field_1867, frame.sprint);
                }
                if (playbackCrouch && frame.sneak != null) {
                    MacroRecorder.simulateKeyPress(client.field_1690.field_1832, frame.sneak);
                }
                if (playbackAttack && Boolean.TRUE.equals(frame.attack)) {
                    MacroRecorder.simulateKeyPress(client.field_1690.field_1886, true);
                    if (client.field_1765 != null && client.field_1765.method_17783() == class_239.class_240.field_1331) {
                        class_1297 target = ((class_3966)client.field_1765).method_17782();
                        client.field_1761.method_2918((class_1657)client.field_1724, target);
                    }
                    client.field_1724.method_6104(class_1268.field_5808);
                }
                if (playbackUse && frame.use != null) {
                    MacroRecorder.simulateKeyPress(client.field_1690.field_1904, frame.use);
                }
                if (playbackDrop && Boolean.TRUE.equals(frame.dropItem)) {
                    client.field_1724.method_7290(false);
                }
                if (playbackSwapHands && Boolean.TRUE.equals(frame.swapOffhand)) {
                    client.method_1562().method_52787((class_2596)new class_2846(class_2846.class_2847.field_12969, class_2338.field_10980, class_2350.field_11036));
                }
                try {
                    Field field = client.field_1724.method_31548().getClass().getDeclaredField("field_7545");
                    field.setAccessible(true);
                    field.setInt(client.field_1724.method_31548(), frame.selectedSlot);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (++currentRepeat >= frame.repeats) {
                    currentRepeat = 0;
                    ++playbackIndex;
                }
            }
        });
        HudRenderCallback.EVENT.register((drawContext, tickCounter) -> {
            if (isRecording && showIndicator && MacroRecorder.client.field_1724 != null) {
                int screenWidth = client.method_22683().method_4486();
                int screenHeight = client.method_22683().method_4502();
                int color = -65536;
                String message = "Recording";
                if (waitingForInput) {
                    message = "Waiting For Input";
                    color = -256;
                }
                Objects.requireNonNull(MacroRecorder.client.field_1772);
                int lineHeight = 9 + 2;
                int textWidth = MacroRecorder.client.field_1772.method_1727(message);
                int x = (screenWidth - textWidth) / 2;
                int y = screenHeight - 50;
                drawContext.method_51439(MacroRecorder.client.field_1772, (class_2561)class_2561.method_43470((String)message), x, y, -65536, true);
            }
        });
        MacroRecorder.registerCommands();
    }

    private static void simulateKeyPress(class_304 key, boolean pressed) {
        key.method_23481(pressed);
    }

    private static int getSelectedSlotReflect(class_746 player) {
        try {
            Field field = player.method_31548().getClass().getDeclaredField("field_7545");
            field.setAccessible(true);
            return field.getInt(player.method_31548());
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    private static void moveItemToSlot(class_1799 desired, int targetSlot) {
        class_1661 inv = MacroRecorder.client.field_1724.method_31548();
        class_1799 current = inv.method_5438(targetSlot);
        if (class_1799.method_7973((class_1799)desired, (class_1799)current)) {
            return;
        }
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 found;
            if (i == targetSlot || !class_1799.method_7973((class_1799)desired, (class_1799)(found = inv.method_5438(i)))) continue;
            inv.method_5447(i, current);
            inv.method_5447(targetSlot, found);
            return;
        }
    }

    private static void registerCommands() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"macrorecorder").then(ClientCommandManager.literal((String)"record").executes(ctx -> {
            if (isPlaying) {
                MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cCannot play while recording. Run /macrorecorder stop first."), false);
                return 1;
            }
            recordedFrames.clear();
            if (!isRecording) {
                isRecording = true;
                MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7aRecording started. Run /macrorecorder stop to stop recording."), false);
            } else {
                MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7aRecording restarted. Run /macrorecorder stop to stop recording."), false);
            }
            if (recordOnFirstInput) {
                waitingForInput = true;
            }
            return 1;
        }))).then(ClientCommandManager.literal((String)"stop").executes(ctx -> {
            waitingForInput = false;
            if (!isRecording && !isPlaying) {
                MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7eThere is nothing to stop!"), false);
            }
            if (isRecording) {
                isRecording = false;
                MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7eRecording stopped. To test this macro run /macrorecorder test, and to save this macro run /macrorecorder save <file name>"), false);
            }
            if (isPlaying) {
                isPlaying = false;
                MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7ePlayback stopped. Run /macrorecorder test to test, and /macrorecorder save <file name> to save."), false);
            }
            return 1;
        }))).then(ClientCommandManager.literal((String)"test").executes(ctx -> {
            if (recordedFrames.isEmpty()) {
                MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cNo macro recorded. Do /macrorecorder record to record one, and use this command to test it before saving with /macrorecorder save <file name>"), false);
                return 0;
            }
            if (isRecording) {
                MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cCannot test while recording. Use /macrorecorder stop first."), false);
                return 0;
            }
            playbackFrames.clear();
            playbackFrames.addAll(recordedFrames);
            playbackIndex = 0;
            isPlaying = true;
            MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7aTesting macro..."), false);
            if (loop) {
                MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a77Note: Macro is set to loop after completing."), false);
            }
            return 1;
        }))).then(ClientCommandManager.literal((String)"save").then(ClientCommandManager.argument((String)"filename", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"filename");
            File file = new File(macroDir, name + ".json");
            if (recordedFrames.size() == 0) {
                MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cRecord a macro with /macrorecorder record first."), false);
                return 0;
            }
            if (file.exists()) {
                MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a7cMacro '" + name + "' already exists. Run /macrorecorder delete " + name + " first.")), false);
                return 0;
            }
            Gson prettyGson = new GsonBuilder().setPrettyPrinting().create();
            try (FileWriter writer = new FileWriter(file);){
                writer.write("// Each entry in the below list is one tick, and the repeats parameter is how many times it will play that tick before moving to the next.\n\n");
                prettyGson.toJson(recordedFrames, (Appendable)writer);
                MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a7aMacro saved to: " + file.getAbsolutePath())), false);
            }
            catch (IOException e) {
                MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cFailed to save macro. Please try again. If the issue persists, try a different name, restarting Minecraft, or re-installing the mod."), false);
                e.printStackTrace();
            }
            return 1;
        })))).then(ClientCommandManager.literal((String)"play").then(ClientCommandManager.argument((String)"filename", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            File[] files = macroDir.listFiles((d, name) -> name.endsWith(".json"));
            if (files != null) {
                for (File f : files) {
                    builder.suggest(f.getName().replaceFirst("\\.json$", ""));
                }
            }
            return builder.buildFuture();
        }).executes(ctx -> {
            if (isRecording) {
                MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cCannot play while recording. Run /macrorecorder stop first."), false);
                return 0;
            }
            String filename = StringArgumentType.getString((CommandContext)ctx, (String)"filename") + ".json";
            File file = new File(macroDir, filename);
            try (FileReader reader = new FileReader(file);){
                Type listType = new TypeToken<ArrayList<MacroFrame>>(){}.getType();
                List loaded = (List)gson.fromJson((Reader)reader, listType);
                playbackFrames.clear();
                playbackFrames.addAll(loaded);
                playbackIndex = 0;
                isPlaying = true;
                MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a7aPlaying macro from " + filename)), false);
                if (loop) {
                    MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a77Note: Macro is set to loop after completing."), false);
                }
            }
            catch (IOException e) {
                MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cFailed to load macro."), false);
                e.printStackTrace();
                return 0;
            }
            return 1;
        })))).then(ClientCommandManager.literal((String)"delete").then(ClientCommandManager.argument((String)"filename", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            File[] files = macroDir.listFiles((d, name) -> name.endsWith(".json"));
            if (files != null) {
                for (File f : files) {
                    builder.suggest(f.getName().replaceFirst("\\.json$", ""));
                }
            }
            return builder.buildFuture();
        }).executes(ctx -> {
            String filename = StringArgumentType.getString((CommandContext)ctx, (String)"filename");
            String fullName = filename + ".json";
            File file = new File(macroDir, fullName);
            if (!file.exists()) {
                MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a7cMacro not found: " + fullName)), false);
                return 0;
            }
            macroKeybinds.remove(filename);
            if (file.delete()) {
                MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a7eDeleted macro: " + fullName)), false);
                return 1;
            }
            MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a7cFailed to delete macro: " + fullName)), false);
            return 0;
        })))).then(ClientCommandManager.literal((String)"showRecordingIndicator").then(ClientCommandManager.argument((String)"bool", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            boolean value;
            showIndicator = value = BoolArgumentType.getBool((CommandContext)ctx, (String)"bool");
            MacroRecorder.updateConfig();
            MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a7eRecording indicator shown set to: " + showIndicator)), false);
            return 1;
        })))).then(ClientCommandManager.literal((String)"recordOnFirstInput").then(ClientCommandManager.argument((String)"bool", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            boolean value;
            recordOnFirstInput = value = BoolArgumentType.getBool((CommandContext)ctx, (String)"bool");
            MacroRecorder.updateConfig();
            MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a7eRecord on first input: " + recordOnFirstInput)), false);
            return 1;
        })))).then(ClientCommandManager.literal((String)"loop").then(ClientCommandManager.argument((String)"bool", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            boolean value;
            loop = value = BoolArgumentType.getBool((CommandContext)ctx, (String)"bool");
            MacroRecorder.updateConfig();
            MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a7eLoop set to: " + loop)), false);
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"bind").then(ClientCommandManager.literal((String)"macro").then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"filename", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            File[] files = macroDir.listFiles((d, name) -> name.endsWith(".json"));
            if (files != null) {
                for (File f : files) {
                    builder.suggest(f.getName().replaceFirst("\\.json$", ""));
                }
            }
            return builder.buildFuture();
        }).then(ClientCommandManager.literal((String)"record").executes(ctx -> {
            String filename = StringArgumentType.getString((CommandContext)ctx, (String)"filename");
            waitingForMacroBind.put(filename, true);
            MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("Please press the key to bind macro '" + filename + "'.")), false);
            MacroRecorder.updateConfig();
            return 1;
        }))).then(ClientCommandManager.literal((String)"remove").executes(ctx -> {
            String filename = StringArgumentType.getString((CommandContext)ctx, (String)"filename");
            if (macroKeybinds.containsKey(filename)) {
                macroKeybinds.remove(filename);
                MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a7eRemoved macro keybind for: " + filename)), false);
                MacroRecorder.updateConfig();
                return 1;
            }
            MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a7cNo macro keybind found for: " + filename)), false);
            return 0;
        }))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"startRecording").then(ClientCommandManager.literal((String)"record").executes(ctx -> {
            waitingForStartKeybind = true;
            MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"Please press the key you want to bind 'startRecording' to."), false);
            MacroRecorder.updateConfig();
            return 1;
        }))).then(ClientCommandManager.literal((String)"remove").executes(ctx -> {
            startRecordKey = -1;
            MacroRecorder.updateConfig();
            MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cStart Recording keybind removed."), false);
            MacroRecorder.updateConfig();
            return 1;
        })))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"stopRecording").then(ClientCommandManager.literal((String)"record").executes(ctx -> {
            waitingForStopKeybind = true;
            MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"Please press the key you want to bind 'stopRecording' to."), false);
            MacroRecorder.updateConfig();
            return 1;
        }))).then(ClientCommandManager.literal((String)"remove").executes(ctx -> {
            stopRecordKey = -1;
            MacroRecorder.updateConfig();
            MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cStop Recording keybind removed."), false);
            return 1;
        }))))).then(ClientCommandManager.literal((String)"recordSettings").then(ClientCommandManager.argument((String)"setting", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            String[] recordOptions = new String[]{"recordCamera", "recordCrouch", "recordJump", "recordMovement", "recordSprint", "recordPlace", "recordAttack", "recordUse", "recordDrop", "recordSwapHands"};
            String input = builder.getRemaining().toLowerCase();
            for (String option : recordOptions) {
                if (!option.toLowerCase().startsWith(input)) continue;
                builder.suggest(option);
            }
            return builder.buildFuture();
        }).then(ClientCommandManager.argument((String)"bool", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            String setting = StringArgumentType.getString((CommandContext)ctx, (String)"setting");
            boolean value = BoolArgumentType.getBool((CommandContext)ctx, (String)"bool");
            switch (setting) {
                case "recordCamera": {
                    recordCamera = value;
                    break;
                }
                case "recordCrouch": {
                    recordCrouch = value;
                    break;
                }
                case "recordJump": {
                    recordJump = value;
                    break;
                }
                case "recordMovement": {
                    recordMovement = value;
                    break;
                }
                case "recordSprint": {
                    recordSprint = value;
                    break;
                }
                case "recordPlace": {
                    recordPlace = value;
                    break;
                }
                case "recordAttack": {
                    recordAttack = value;
                    break;
                }
                case "recordUse": {
                    recordUse = value;
                    break;
                }
                case "recordDrop": {
                    recordDrop = value;
                    break;
                }
                case "recordSwapHands": {
                    recordSwapHands = value;
                    break;
                }
                default: {
                    MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a7cUnknown record setting: " + setting)), false);
                    return 0;
                }
            }
            MacroRecorder.updateConfig();
            MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a7a" + setting + " set to: " + value)), false);
            return 1;
        }))))).then(ClientCommandManager.literal((String)"playbackSettings").then(ClientCommandManager.argument((String)"setting", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            String[] playbackOptions = new String[]{"playbackCamera", "playbackCrouch", "playbackJump", "playbackMovement", "playbackSprint", "playbackPlace", "playbackAttack", "playbackUse", "playbackDrop", "playbackSwapHands"};
            String input = builder.getRemaining().toLowerCase();
            for (String option : playbackOptions) {
                if (!option.toLowerCase().startsWith(input)) continue;
                builder.suggest(option);
            }
            return builder.buildFuture();
        }).then(ClientCommandManager.argument((String)"bool", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            String setting = StringArgumentType.getString((CommandContext)ctx, (String)"setting");
            boolean value = BoolArgumentType.getBool((CommandContext)ctx, (String)"bool");
            switch (setting) {
                case "playbackCamera": {
                    playbackCamera = value;
                    break;
                }
                case "playbackCrouch": {
                    playbackCrouch = value;
                    break;
                }
                case "playbackJump": {
                    playbackJump = value;
                    break;
                }
                case "playbackMovement": {
                    playbackMovement = value;
                    break;
                }
                case "playbackSprint": {
                    playbackSprint = value;
                    break;
                }
                case "playbackPlace": {
                    playbackPlace = value;
                    break;
                }
                case "playbackAttack": {
                    playbackAttack = value;
                    break;
                }
                case "playbackUse": {
                    playbackUse = value;
                    break;
                }
                case "playbackDrop": {
                    playbackDrop = value;
                    break;
                }
                case "playbackSwapHands": {
                    playbackSwapHands = value;
                    break;
                }
                default: {
                    MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a7cUnknown playback setting: " + setting)), false);
                    return 0;
                }
            }
            MacroRecorder.updateConfig();
            MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a7a" + setting + " set to: " + value)), false);
            return 1;
        }))))).then(ClientCommandManager.literal((String)"help").executes(ctx -> {
            MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a76\u00a7lMacroRecorder Help"), false);
            MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7a/macrorecorder record\u00a77 - Start recording a macro"), false);
            MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7a/macrorecorder test\u00a77 - Plays your last recording without you having to save it first."), false);
            MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7a/macrorecorder stop\u00a77 - Stop recording or playback"), false);
            MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7a/macrorecorder save <name>\u00a77 - Save the current recording to .minecraft/macros"), false);
            MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7a/macrorecorder play <name>\u00a77 - Play a saved macro"), false);
            MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7a/macrorecorder delete <name>\u00a77 - Delete a saved macro"), false);
            MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7a/macrorecorder showRecordingIndicator <true|false>\u00a77 - Toggle recording indicator"), false);
            MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7a/macrorecorder loop <true|false>\u00a77 - If macros should loop after finishing"), false);
            MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7a/macrorecorder bind startRecording record\u00a77 - Bind a key to start recording"), false);
            MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7a/macrorecorder bind startRecording remove\u00a77 - Unbind the startRecording key"), false);
            MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7a/macrorecorder bind stopRecording record\u00a77 - Bind a key to stop recording"), false);
            MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7a/macrorecorder bind stopRecording remove\u00a77 - Unbind the stopRecording key"), false);
            MacroRecorder.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7a/macrorecorder help\u00a77 - Show this help message"), false);
            return 1;
        }))));
    }

    @Environment(value=EnvType.CLIENT)
    static class MacroFrame {
        final float yaw;
        final float pitch;
        final Boolean forward;
        final Boolean left;
        final Boolean back;
        final Boolean right;
        final Boolean jump;
        final Boolean sprint;
        final Boolean sneak;
        final Boolean attack;
        final Boolean use;
        final Boolean dropItem;
        final Boolean swapOffhand;
        final int selectedSlot;
        final int repeats;

        MacroFrame(float yaw, float pitch, Boolean forward, Boolean left, Boolean back, Boolean right, Boolean jump, Boolean sprint, Boolean sneak, Boolean attack, Boolean use, int selectedSlot, Boolean dropItem, Boolean swapOffhand, int repeats) {
            this.yaw = yaw;
            this.pitch = pitch;
            this.forward = forward;
            this.left = left;
            this.back = back;
            this.right = right;
            this.jump = jump;
            this.sprint = sprint;
            this.sneak = sneak;
            this.attack = attack;
            this.use = use;
            this.selectedSlot = selectedSlot;
            this.dropItem = dropItem;
            this.swapOffhand = swapOffhand;
            this.repeats = repeats;
        }

        private boolean isEqualNullableBool(Boolean a, Boolean b) {
            if (a == null || b == null) {
                return true;
            }
            return a.equals(b);
        }

        private boolean isEqualFloat(float a, float b) {
            if (Float.isNaN(a) || Float.isNaN(b)) {
                return true;
            }
            return Float.compare(a, b) == 0;
        }

        boolean equalsWithoutRepeats(MacroFrame other) {
            if (other == null) {
                return false;
            }
            return this.isEqualFloat(this.yaw, other.yaw) && this.isEqualFloat(this.pitch, other.pitch) && this.isEqualNullableBool(this.forward, other.forward) && this.isEqualNullableBool(this.left, other.left) && this.isEqualNullableBool(this.back, other.back) && this.isEqualNullableBool(this.right, other.right) && this.isEqualNullableBool(this.jump, other.jump) && this.isEqualNullableBool(this.sprint, other.sprint) && this.isEqualNullableBool(this.sneak, other.sneak) && this.isEqualNullableBool(this.attack, other.attack) && this.isEqualNullableBool(this.use, other.use) && this.selectedSlot == other.selectedSlot && this.isEqualNullableBool(this.dropItem, other.dropItem) && this.isEqualNullableBool(this.swapOffhand, other.swapOffhand);
        }

        MacroFrame withIncreasedRepeats() {
            return new MacroFrame(this.yaw, this.pitch, this.forward, this.left, this.back, this.right, this.jump, this.sprint, this.sneak, this.attack, this.use, this.selectedSlot, this.dropItem, this.swapOffhand, this.repeats + 1);
        }
    }
}

