/*
 * Decompiled with CFR 0.152.
 */
package me.truedarklord.reduceDrops.listeners;

import java.util.ArrayList;
import java.util.List;
import me.truedarklord.reduceDrops.ReduceDrops;
import me.truedarklord.reduceDrops.Utils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class BlockDropItems
implements Listener {
    private static final ReduceDrops plugin = (ReduceDrops)ReduceDrops.getPlugin(ReduceDrops.class);
    private static List<String> watchlist = plugin.getConfig().getStringList("BlockBreak.Items");
    private static Boolean useWhitelist = plugin.getConfig().getBoolean("BlockBreak.Whitelist", false);

    public BlockDropItems(ReduceDrops plugin) {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockDropItems(BlockDropItemEvent event) {
        Player player = event.getPlayer();
        List items = event.getItems();
        ArrayList<Item> toRemove = new ArrayList<Item>(items.size());
        for (Item item : items) {
            ItemStack itemStack = item.getItemStack();
            if (!this.canGive(itemStack.getType().toString())) continue;
            item.remove();
            toRemove.add(item);
            Utils.giveOrDropItems(player, itemStack);
        }
        toRemove.forEach(items::remove);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        if (!plugin.getConfig().getBoolean("BlockBreak.Handle-XP", true)) {
            return;
        }
        Player player = event.getPlayer();
        Utils.giveXp(player, event.getExpToDrop());
        event.setExpToDrop(0);
    }

    private boolean canGive(String itemType) {
        return useWhitelist == (!watchlist.isEmpty() && watchlist.contains(itemType));
    }

    public static void reload() {
        watchlist = plugin.getConfig().getStringList("BlockBreak.Items");
        useWhitelist = plugin.getConfig().getBoolean("BlockBreak.Whitelist", false);
    }
}

