/*
 * Decompiled with CFR 0.152.
 */
package me.truedarklord.reduceDrops.listeners;

import java.util.ArrayList;
import java.util.List;
import me.truedarklord.reduceDrops.ReduceDrops;
import me.truedarklord.reduceDrops.Utils;
import org.bukkit.Bukkit;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class Kill
implements Listener {
    private static final ReduceDrops plugin = (ReduceDrops)ReduceDrops.getPlugin(ReduceDrops.class);
    private static List<String> watchlist = plugin.getConfig().getStringList("Kill.Items");
    private static Boolean useWhitelist = plugin.getConfig().getBoolean("Kill.Whitelist", false);
    private static List<String> entityBlacklist = plugin.getConfig().getStringList("Kill.Entity-Blacklist");

    public Kill(ReduceDrops plugin) {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onKill(EntityDeathEvent event) {
        LivingEntity killedEntity = event.getEntity();
        Player killer = killedEntity.getKiller();
        if (killer == null) {
            return;
        }
        if (entityBlacklist.contains(killedEntity.getType().toString())) {
            return;
        }
        List items = event.getDrops();
        ArrayList<ItemStack> toRemove = new ArrayList<ItemStack>(items.size());
        for (ItemStack itemStack : items) {
            if (!this.canGive(itemStack.getType().toString())) continue;
            toRemove.add(itemStack);
            Utils.giveOrDropItems(killer, itemStack);
        }
        toRemove.forEach(items::remove);
        if (!plugin.getConfig().getBoolean("Kill.Handle-XP", true)) {
            Utils.giveXp(killer, event.getDroppedExp());
            event.setDroppedExp(0);
        }
    }

    private boolean canGive(String itemType) {
        return useWhitelist == (!watchlist.isEmpty() && watchlist.contains(itemType));
    }

    public static void reload() {
        watchlist = plugin.getConfig().getStringList("Kill.Items");
        useWhitelist = plugin.getConfig().getBoolean("Kill.Whitelist", false);
        entityBlacklist = plugin.getConfig().getStringList("Kill.Entity-Blacklist");
    }
}

