/*
 * Decompiled with CFR 0.152.
 */
package me.truedarklord.reduceDrops.listeners;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.truedarklord.reduceDrops.ReduceDrops;
import me.truedarklord.reduceDrops.Utils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.plugin.Plugin;

public class Shear
implements Listener {
    private final ReduceDrops plugin = (ReduceDrops)ReduceDrops.getPlugin(ReduceDrops.class);
    private final Map<UUID, UUID> shearMap = new HashMap<UUID, UUID>();

    public Shear() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onShear(PlayerShearEntityEvent event) {
        if (!this.plugin.getConfig().getBoolean("Shearing.Enabled", false)) {
            return;
        }
        UUID entityId = event.getEntity().getUniqueId();
        this.shearMap.put(entityId, event.getPlayer().getUniqueId());
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.shearMap.remove(entityId), 1L);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void dropItems(EntityDropItemEvent event) {
        UUID entityId = event.getEntity().getUniqueId();
        if (!this.shearMap.containsKey(entityId)) {
            return;
        }
        Player player = this.plugin.getServer().getPlayer(this.shearMap.get(entityId));
        Utils.giveOrDropItems(player, event.getItemDrop().getItemStack());
        event.getItemDrop().remove();
    }
}

