/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.advancement;

import dev.aaronhowser.mods.geneticsresequenced.attachment.GenesData;
import dev.aaronhowser.mods.geneticsresequenced.datagen.ModAdvancementSubProvider;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J$\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018\u00a8\u0006\u0019"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/advancement/AdvancementTriggers;", "", "<init>", "()V", "completeAdvancement", "", "player", "Lnet/minecraft/server/level/ServerPlayer;", "advancement", "Lnet/minecraft/advancements/AdvancementHolder;", "geneAdvancements", "geneHolder", "Lnet/minecraft/core/Holder;", "Ldev/aaronhowser/mods/geneticsresequenced/gene/Gene;", "wasAdded", "", "getAllScareGenes", "getFlightGeneAdvancement", "slimyDeathAdvancement", "getCringeGeneAdvancement", "getAnyGeneAdvancement", "getMilkedAdvancement", "getAdvancement", "advancementId", "Lnet/minecraft/resources/ResourceLocation;", "geneticsresequenced-1.21.1"})
@SourceDebugExtension(value={"SMAP\nAdvancementTriggers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdvancementTriggers.kt\ndev/aaronhowser/mods/geneticsresequenced/advancement/AdvancementTriggers\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n1761#2,3:84\n*S KotlinDebug\n*F\n+ 1 AdvancementTriggers.kt\ndev/aaronhowser/mods/geneticsresequenced/advancement/AdvancementTriggers\n*L\n49#1:84,3\n*E\n"})
public final class AdvancementTriggers {
    @NotNull
    public static final AdvancementTriggers INSTANCE = new AdvancementTriggers();

    private AdvancementTriggers() {
    }

    private final void completeAdvancement(ServerPlayer player, AdvancementHolder advancement) {
        AdvancementProgress progress = player.getAdvancements().getOrStartProgress(advancement);
        if (progress.isDone()) {
            return;
        }
        for (String criterion : progress.getRemainingCriteria()) {
            player.getAdvancements().award(advancement, criterion);
        }
    }

    public final void geneAdvancements(@NotNull ServerPlayer player, @NotNull Holder<Gene> geneHolder, boolean wasAdded) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter(geneHolder, (String)"geneHolder");
        if (!wasAdded) {
            return;
        }
        this.getAnyGeneAdvancement(player);
        if (Gene.Companion.isGene(geneHolder, ModGenes.CRINGE)) {
            this.getCringeGeneAdvancement(player);
        } else if (Gene.Companion.isGene(geneHolder, ModGenes.FLIGHT)) {
            this.getFlightGeneAdvancement(player);
        } else if (Gene.Companion.isGene(geneHolder, ModGenes.SCARE_SPIDERS)) {
            this.getAllScareGenes(player);
        }
    }

    private final void getAllScareGenes(ServerPlayer player) {
        boolean bl;
        block5: {
            Object[] objectArray = new ResourceKey[]{ModGenes.SCARE_SPIDERS, ModGenes.SCARE_CREEPERS, ModGenes.SCARE_SKELETONS, ModGenes.SCARE_ZOMBIES};
            List scareGeneKeys = CollectionsKt.listOf((Object[])objectArray);
            Iterable $this$any$iv = scareGeneKeys;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ResourceKey it = (ResourceKey)element$iv;
                    boolean bl2 = false;
                    if (!(!GenesData.Companion.hasGene((Entity)player, (ResourceKey<Gene>)it))) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        AdvancementHolder advancementHolder = this.getAdvancement(player, ModAdvancementSubProvider.Companion.getGET_ALL_SCARE_GENES());
        if (advancementHolder == null) {
            return;
        }
        AdvancementHolder advancement = advancementHolder;
        this.completeAdvancement(player, advancement);
    }

    private final void getFlightGeneAdvancement(ServerPlayer player) {
        AdvancementHolder advancementHolder = this.getAdvancement(player, ModAdvancementSubProvider.Companion.getGET_FLIGHT());
        if (advancementHolder == null) {
            return;
        }
        AdvancementHolder advancement = advancementHolder;
        this.completeAdvancement(player, advancement);
    }

    public final void slimyDeathAdvancement(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        AdvancementHolder advancementHolder = this.getAdvancement(player, ModAdvancementSubProvider.Companion.getTRIGGER_SLIMY_DEATH());
        if (advancementHolder == null) {
            return;
        }
        AdvancementHolder advancement = advancementHolder;
        this.completeAdvancement(player, advancement);
    }

    private final void getCringeGeneAdvancement(ServerPlayer player) {
        AdvancementHolder advancementHolder = this.getAdvancement(player, ModAdvancementSubProvider.Companion.getGET_CRINGE());
        if (advancementHolder == null) {
            return;
        }
        AdvancementHolder advancement = advancementHolder;
        this.completeAdvancement(player, advancement);
    }

    private final void getAnyGeneAdvancement(ServerPlayer player) {
        AdvancementHolder advancementHolder = this.getAdvancement(player, ModAdvancementSubProvider.Companion.getGET_GENE());
        if (advancementHolder == null) {
            return;
        }
        AdvancementHolder advancement = advancementHolder;
        this.completeAdvancement(player, advancement);
    }

    public final void getMilkedAdvancement(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        AdvancementHolder advancementHolder = this.getAdvancement(player, ModAdvancementSubProvider.Companion.getGET_MILKED());
        if (advancementHolder == null) {
            return;
        }
        AdvancementHolder advancement = advancementHolder;
        this.completeAdvancement(player, advancement);
    }

    @Nullable
    public final AdvancementHolder getAdvancement(@NotNull ServerPlayer player, @NotNull ResourceLocation advancementId) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)advancementId, (String)"advancementId");
        return player.server.getAdvancements().get(advancementId);
    }
}

