/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.block;

import dev.aaronhowser.mods.geneticsresequenced.config.ServerConfig;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModBlocks;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001c\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00050\u000bH\u0014J8\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0014\u00a8\u0006\u0017"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/block/AntiFieldBlock;", "Lnet/minecraft/world/level/block/Block;", "<init>", "()V", "getStateForPlacement", "Lnet/minecraft/world/level/block/state/BlockState;", "pContext", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "createBlockStateDefinition", "", "pBuilder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "neighborChanged", "pState", "pLevel", "Lnet/minecraft/world/level/Level;", "pPos", "Lnet/minecraft/core/BlockPos;", "pNeighborBlock", "pNeighborPos", "pMovedByPiston", "", "Companion", "geneticsresequenced-1.21.1"})
public final class AntiFieldBlock
extends Block {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final BooleanProperty DISABLED;

    public AntiFieldBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.METAL).strength(0.3f));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DISABLED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext pContext) {
        Intrinsics.checkNotNullParameter((Object)pContext, (String)"pContext");
        return (BlockState)this.defaultBlockState().setValue((Property)DISABLED, (Comparable)Boolean.valueOf(false));
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> pBuilder) {
        Intrinsics.checkNotNullParameter(pBuilder, (String)"pBuilder");
        super.createBlockStateDefinition(pBuilder);
        Property[] propertyArray = new Property[]{DISABLED};
        pBuilder.add(propertyArray);
    }

    protected void neighborChanged(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Block pNeighborBlock, @NotNull BlockPos pNeighborPos, boolean pMovedByPiston) {
        Intrinsics.checkNotNullParameter((Object)pState, (String)"pState");
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pNeighborBlock, (String)"pNeighborBlock");
        Intrinsics.checkNotNullParameter((Object)pNeighborPos, (String)"pNeighborPos");
        boolean isPowered = pLevel.hasNeighborSignal(pPos);
        if (!Intrinsics.areEqual((Object)pState.getValue((Property)DISABLED), (Object)isPowered)) {
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)DISABLED, (Comparable)Boolean.valueOf(isPowered)), 2);
        }
    }

    static {
        BooleanProperty booleanProperty = BlockStateProperties.POWERED;
        Intrinsics.checkNotNullExpressionValue((Object)booleanProperty, (String)"POWERED");
        DISABLED = booleanProperty;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/block/AntiFieldBlock$Companion;", "", "<init>", "()V", "DISABLED", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "getDISABLED", "()Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "getNearestActiveAntifield", "Ljava/util/Optional;", "Lnet/minecraft/core/BlockPos;", "level", "Lnet/minecraft/world/level/Level;", "location", "isNearActiveAntifield", "", "geneticsresequenced-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BooleanProperty getDISABLED() {
            return DISABLED;
        }

        @NotNull
        public final Optional<BlockPos> getNearestActiveAntifield(@NotNull Level level, @NotNull BlockPos location) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Integer radius = (Integer)ServerConfig.Companion.getCONFIG().getAntifieldBlockRadius().get();
            Intrinsics.checkNotNull((Object)radius);
            Optional optional = BlockPos.findClosestMatch((BlockPos)location, (int)radius, (int)radius, arg_0 -> Companion.getNearestActiveAntifield$lambda$0(level, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"findClosestMatch(...)");
            return optional;
        }

        public final boolean isNearActiveAntifield(@NotNull Level level, @NotNull BlockPos location) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            return this.getNearestActiveAntifield(level, location).isPresent();
        }

        private static final boolean getNearestActiveAntifield$lambda$0(Level $level, BlockPos pos) {
            BlockState blockState = $level.getBlockState(pos);
            return Intrinsics.areEqual((Object)blockState.getBlock(), (Object)ModBlocks.INSTANCE.getANTI_FIELD_BLOCK().get()) && (Boolean)blockState.getValue((Property)Companion.getDISABLED()) == false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

