/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.block.base;

import dev.aaronhowser.mods.aaron.AaronExtensions;
import dev.aaronhowser.mods.aaron.ImprovedSimpleContainer;
import dev.aaronhowser.mods.geneticsresequenced.block.base.container_data.EnergyContainerData;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 :2\u00020\u00012\u00020\u0002:\u0001:B#\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\u0017\u001a\u00020\u00122\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0014\u0010%\u001a\u0004\u0018\u00010(2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\b\u0010)\u001a\u00020*H\u0014J\b\u0010+\u001a\u00020*H\u0014J\b\u0010,\u001a\u00020*H\u0016J\u0018\u0010-\u001a\u00020*2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0014J\u0018\u00102\u001a\u00020*2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0014J\u0010\u00103\u001a\u00020/2\u0006\u00104\u001a\u000201H\u0016J\u000e\u00105\u001a\b\u0012\u0004\u0012\u00020706H\u0016J\b\u00108\u001a\u000209H\u0016R\u0012\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u001b\u0010\u0011\u001a\u00020\u00128DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u001a\u001a\u00020\u001b8TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u0016\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001f\u001a\u00020 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001b\u0010#\u001a\u00020$8TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\u0016\u001a\u0004\b%\u0010&\u00a8\u0006;"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/block/base/MachineBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lnet/minecraft/world/MenuProvider;", "blockEntityType", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "pos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "maxEnergy", "", "getMaxEnergy", "()I", "energyTransferRate", "getEnergyTransferRate", "energyStorage", "Lnet/neoforged/neoforge/energy/EnergyStorage;", "getEnergyStorage", "()Lnet/neoforged/neoforge/energy/EnergyStorage;", "energyStorage$delegate", "Lkotlin/Lazy;", "getEnergyCapability", "direction", "Lnet/minecraft/core/Direction;", "containerData", "Lnet/minecraft/world/inventory/ContainerData;", "getContainerData", "()Lnet/minecraft/world/inventory/ContainerData;", "containerData$delegate", "container", "Ldev/aaronhowser/mods/aaron/ImprovedSimpleContainer;", "getContainer", "()Ldev/aaronhowser/mods/aaron/ImprovedSimpleContainer;", "itemHandler", "Lnet/neoforged/neoforge/items/wrapper/InvWrapper;", "getItemHandler", "()Lnet/neoforged/neoforge/items/wrapper/InvWrapper;", "itemHandler$delegate", "Lnet/neoforged/neoforge/items/IItemHandler;", "serverTick", "", "clientTick", "setChanged", "saveAdditional", "tag", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "loadAdditional", "getUpdateTag", "pRegistries", "getUpdatePacket", "Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/protocol/game/ClientGamePacketListener;", "getDisplayName", "Lnet/minecraft/network/chat/Component;", "Companion", "geneticsresequenced-1.21.1"})
public abstract class MachineBlockEntity
extends BlockEntity
implements MenuProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy energyStorage$delegate;
    @NotNull
    private final Lazy containerData$delegate;
    @NotNull
    private final ImprovedSimpleContainer container;
    @NotNull
    private final Lazy itemHandler$delegate;
    @NotNull
    private static final String ENERGY_NBT = "Energy";

    public MachineBlockEntity(@NotNull BlockEntityType<?> blockEntityType, @NotNull BlockPos pos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter(blockEntityType, (String)"blockEntityType");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super(blockEntityType, pos, blockState);
        this.energyStorage$delegate = LazyKt.lazy(() -> MachineBlockEntity.energyStorage_delegate$lambda$0(this));
        this.containerData$delegate = LazyKt.lazy(() -> MachineBlockEntity.containerData_delegate$lambda$1(this));
        this.container = new ImprovedSimpleContainer((BlockEntity)this, 0);
        this.itemHandler$delegate = LazyKt.lazy(() -> MachineBlockEntity.itemHandler_delegate$lambda$2(this));
    }

    public abstract int getMaxEnergy();

    public abstract int getEnergyTransferRate();

    @NotNull
    protected final EnergyStorage getEnergyStorage() {
        Lazy lazy = this.energyStorage$delegate;
        return (EnergyStorage)lazy.getValue();
    }

    @NotNull
    public EnergyStorage getEnergyCapability(@Nullable Direction direction) {
        return this.getEnergyStorage();
    }

    @NotNull
    protected ContainerData getContainerData() {
        Lazy lazy = this.containerData$delegate;
        return (ContainerData)lazy.getValue();
    }

    @NotNull
    public ImprovedSimpleContainer getContainer() {
        return this.container;
    }

    @NotNull
    protected InvWrapper getItemHandler() {
        Lazy lazy = this.itemHandler$delegate;
        return (InvWrapper)lazy.getValue();
    }

    @Nullable
    public IItemHandler getItemHandler(@Nullable Direction direction) {
        return (IItemHandler)this.getItemHandler();
    }

    protected void serverTick() {
    }

    protected void clientTick() {
    }

    public void setChanged() {
        block0: {
            super.setChanged();
            Level level = this.level;
            if (level == null) break block0;
            level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 11);
        }
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, (NonNullList)this.getContainer().getItems(), (HolderLookup.Provider)registries);
        tag.put(ENERGY_NBT, this.getEnergyStorage().serializeNBT(registries));
    }

    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.loadAdditional(tag, registries);
        ContainerHelper.loadAllItems((CompoundTag)tag, (NonNullList)this.getContainer().getItems(), (HolderLookup.Provider)registries);
        Tag energy = tag.get(ENERGY_NBT);
        if (energy instanceof IntTag) {
            this.getEnergyStorage().deserializeNBT(registries, energy);
        }
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider pRegistries) {
        Intrinsics.checkNotNullParameter((Object)pRegistries, (String)"pRegistries");
        CompoundTag compoundTag = this.saveWithoutMetadata(pRegistries);
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"saveWithoutMetadata(...)");
        return compoundTag;
    }

    @NotNull
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        ClientboundBlockEntityDataPacket clientboundBlockEntityDataPacket = ClientboundBlockEntityDataPacket.create((BlockEntity)this);
        Intrinsics.checkNotNullExpressionValue((Object)clientboundBlockEntityDataPacket, (String)"create(...)");
        return (Packet)clientboundBlockEntityDataPacket;
    }

    @NotNull
    public Component getDisplayName() {
        MutableComponent mutableComponent = this.getBlockState().getBlock().getName();
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"getName(...)");
        return (Component)mutableComponent;
    }

    private static final EnergyStorage energyStorage_delegate$lambda$0(MachineBlockEntity this$0) {
        return new EnergyStorage(this$0.getMaxEnergy(), this$0.getEnergyTransferRate());
    }

    private static final EnergyContainerData containerData_delegate$lambda$1(MachineBlockEntity this$0) {
        return new EnergyContainerData(this$0.getEnergyStorage());
    }

    private static final InvWrapper itemHandler_delegate$lambda$2(MachineBlockEntity this$0) {
        return new InvWrapper((Container)this$0.getContainer());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/block/base/MachineBlockEntity$Companion;", "", "<init>", "()V", "ENERGY_NBT", "", "tick", "", "level", "Lnet/minecraft/world/level/Level;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "blockEntity", "Ldev/aaronhowser/mods/geneticsresequenced/block/base/MachineBlockEntity;", "geneticsresequenced-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        public final void tick(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState, @NotNull MachineBlockEntity blockEntity) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
            Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
            Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
            if (AaronExtensions.INSTANCE.isServerSide(level)) {
                blockEntity.serverTick();
            } else {
                blockEntity.clientTick();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

