/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.block.block_entity;

import dev.aaronhowser.mods.aaron.AaronExtensions;
import dev.aaronhowser.mods.aaron.ImprovedSimpleContainer;
import dev.aaronhowser.mods.geneticsresequenced.block.base.CraftingMachineBlockEntity;
import dev.aaronhowser.mods.geneticsresequenced.block.base.container_data.CraftingContainerData;
import dev.aaronhowser.mods.geneticsresequenced.block.block_entity.IncubatorBlockEntity;
import dev.aaronhowser.mods.geneticsresequenced.config.ServerConfig;
import dev.aaronhowser.mods.geneticsresequenced.menu.advanced_incubator.AdvancedIncubatorMenu;
import dev.aaronhowser.mods.geneticsresequenced.recipe.base.AbstractIncubatorRecipe;
import dev.aaronhowser.mods.geneticsresequenced.recipe.base.IncubatorRecipeInput;
import dev.aaronhowser.mods.geneticsresequenced.recipe.incubator.DupeCellRecipe;
import dev.aaronhowser.mods.geneticsresequenced.recipe.incubator.GmoRecipe;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModBlockEntityTypes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.IntSupplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 @2\u00020\u0001:\u0001@B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010$\u001a\u00020\rH\u0016J\b\u0010&\u001a\u00020'H\u0014J\b\u0010(\u001a\u00020\u0013H\u0014J\b\u0010)\u001a\u00020'H\u0014J\u0018\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0002J\u0010\u00100\u001a\u00020+2\u0006\u00101\u001a\u000202H\u0002J \u00103\u001a\u0002042\u0006\u00105\u001a\u00020\r2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0016J\u0018\u0010:\u001a\u00020'2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0014J\u0018\u0010?\u001a\u00020'2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0014R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR$\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001dX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u000e\u0010%\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/block/block_entity/AdvancedIncubatorBlockEntity;", "Ldev/aaronhowser/mods/geneticsresequenced/block/base/CraftingMachineBlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "baseEnergyCostPerTick", "Ljava/util/function/IntSupplier;", "getBaseEnergyCostPerTick", "()Ljava/util/function/IntSupplier;", "maxEnergy", "", "getMaxEnergy", "()I", "energyTransferRate", "getEnergyTransferRate", "value", "", "isHighTemperature", "()Z", "setHighTemperature", "(Z)V", "container", "Ldev/aaronhowser/mods/aaron/ImprovedSimpleContainer;", "getContainer", "()Ldev/aaronhowser/mods/aaron/ImprovedSimpleContainer;", "containerData", "Lnet/minecraft/world/inventory/ContainerData;", "getContainerData", "()Lnet/minecraft/world/inventory/ContainerData;", "itemHandler", "Lnet/neoforged/neoforge/items/wrapper/InvWrapper;", "getItemHandler", "()Lnet/neoforged/neoforge/items/wrapper/InvWrapper;", "getAmountOfOverclocks", "subTicks", "serverTick", "", "hasRecipe", "craftItem", "gmoRecipeOutput", "Lnet/minecraft/world/item/ItemStack;", "gmoRecipe", "Ldev/aaronhowser/mods/geneticsresequenced/recipe/incubator/GmoRecipe;", "input", "Ldev/aaronhowser/mods/geneticsresequenced/recipe/base/IncubatorRecipeInput;", "nonGmoRecipeOutput", "incubatorRecipe", "Ldev/aaronhowser/mods/geneticsresequenced/recipe/base/AbstractIncubatorRecipe;", "createMenu", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "containerId", "playerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "player", "Lnet/minecraft/world/entity/player/Player;", "saveAdditional", "tag", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "loadAdditional", "Companion", "geneticsresequenced-1.21.1"})
@SourceDebugExtension(value={"SMAP\nAdvancedIncubatorBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdvancedIncubatorBlockEntity.kt\ndev/aaronhowser/mods/geneticsresequenced/block/block_entity/AdvancedIncubatorBlockEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,284:1\n1761#2,3:285\n*S KotlinDebug\n*F\n+ 1 AdvancedIncubatorBlockEntity.kt\ndev/aaronhowser/mods/geneticsresequenced/block/block_entity/AdvancedIncubatorBlockEntity\n*L\n146#1:285,3\n*E\n"})
public final class AdvancedIncubatorBlockEntity
extends CraftingMachineBlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IntSupplier baseEnergyCostPerTick;
    private final int maxEnergy;
    private final int energyTransferRate;
    private boolean isHighTemperature;
    @NotNull
    private final ImprovedSimpleContainer container;
    @NotNull
    private final ContainerData containerData;
    @NotNull
    private final InvWrapper itemHandler;
    private int subTicks;
    @NotNull
    public static final String IS_HIGH_TEMPERATURE_TAG = "IsHighTemperature";
    public static final int INVENTORY_SIZE = 6;
    public static final int TOP_SLOT_INDEX = 0;
    public static final int LEFT_BOTTLE_SLOT_INDEX = 1;
    public static final int MIDDLE_BOTTLE_SLOT_INDEX = 2;
    public static final int RIGHT_BOTTLE_SLOT_INDEX = 3;
    public static final int CHORUS_SLOT_INDEX = 4;
    public static final int OVERCLOCKER_SLOT_INDEX = 5;
    public static final int CONTAINER_DATA_SIZE = 5;
    public static final int IS_HIGH_TEMPERATURE_INDEX = 4;

    public AdvancedIncubatorBlockEntity(@NotNull BlockPos pos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Object object = ModBlockEntityTypes.INSTANCE.getADVANCED_INCUBATOR().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        super((BlockEntityType)object, pos, blockState);
        this.baseEnergyCostPerTick = AdvancedIncubatorBlockEntity::baseEnergyCostPerTick$lambda$0;
        this.maxEnergy = 50000;
        this.energyTransferRate = 500;
        this.container = new ImprovedSimpleContainer(this){
            final /* synthetic */ AdvancedIncubatorBlockEntity this$0;
            {
                this.this$0 = $receiver;
                super((BlockEntity)$receiver, 6);
            }

            public void setChanged() {
                super.setChanged();
                AdvancedIncubatorBlockEntity.access$setCurrentProgress(this.this$0, 0);
            }
        };
        EnergyStorage energyStorage = this.getEnergyStorage();
        IntSupplier intSupplier = () -> AdvancedIncubatorBlockEntity.containerData$lambda$1(this);
        IntSupplier intSupplier2 = () -> AdvancedIncubatorBlockEntity.containerData$lambda$2(this);
        this.containerData = new CraftingContainerData(this, energyStorage, intSupplier, intSupplier2){
            final /* synthetic */ AdvancedIncubatorBlockEntity this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }

            public int get(int index) {
                return index == 4 ? (this.this$0.isHighTemperature() ? 1 : 0) : super.get(index);
            }

            public void set(int index, int value) {
                if (index == 4) {
                    AdvancedIncubatorBlockEntity.access$setHighTemperature(this.this$0, value != 0);
                } else {
                    super.set(index, value);
                }
            }

            public int getCount() {
                return 5;
            }
        };
        energyStorage = this.getContainer();
        this.itemHandler = new InvWrapper(this, (ImprovedSimpleContainer)energyStorage){
            final /* synthetic */ AdvancedIncubatorBlockEntity this$0;
            {
                this.this$0 = $receiver;
                super((Container)$super_call_param$1);
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                Level level = AdvancedIncubatorBlockEntity.access$getLevel$p$s-699333455(this.this$0);
                if (level == null) {
                    return false;
                }
                Level level2 = level;
                return switch (slot) {
                    case 0 -> AbstractIncubatorRecipe.Companion.isValidTopIngredient(level2, stack);
                    case 1, 2, 3 -> AbstractIncubatorRecipe.Companion.isValidBottomIngredient(level2, stack);
                    case 5 -> stack.is((Holder)ModItems.INSTANCE.getOVERCLOCKER());
                    case 4 -> stack.is(Items.CHORUS_FRUIT);
                    default -> false;
                };
            }
        };
    }

    @Override
    @NotNull
    public IntSupplier getBaseEnergyCostPerTick() {
        return this.baseEnergyCostPerTick;
    }

    @Override
    public int getMaxEnergy() {
        return this.maxEnergy;
    }

    @Override
    public int getEnergyTransferRate() {
        return this.energyTransferRate;
    }

    public final boolean isHighTemperature() {
        return this.isHighTemperature;
    }

    private final void setHighTemperature(boolean value) {
        if (this.isHighTemperature != value) {
            this.isHighTemperature = value;
            this.setCurrentProgress(0);
            this.setChanged();
        }
    }

    @Override
    @NotNull
    public ImprovedSimpleContainer getContainer() {
        return this.container;
    }

    @Override
    @NotNull
    protected ContainerData getContainerData() {
        return this.containerData;
    }

    @Override
    @NotNull
    protected InvWrapper getItemHandler() {
        return this.itemHandler;
    }

    @Override
    public int getAmountOfOverclocks() {
        return this.getContainer().getItem(5).getCount();
    }

    @Override
    protected void serverTick() {
        if (!this.hasRecipe()) {
            this.subTicks = 0;
            this.setCurrentProgress(0);
            return;
        }
        this.setMaxProgress(IncubatorBlockEntity.Companion.getTicksPerBrew());
        if (this.isHighTemperature) {
            this.getEnergyStorage().extractEnergy(this.getEnergyCostPerTick(), false);
            this.setCurrentProgress(this.getCurrentProgress() + (1 + this.getAmountOfOverclocks()));
        } else {
            this.subTicks += 1 + this.getAmountOfOverclocks();
            int ticksOverMax = this.subTicks - Companion.getIncubatorLowTemperatureTickFactor();
            if (ticksOverMax >= 0) {
                this.subTicks = ticksOverMax;
                this.getEnergyStorage().extractEnergy(this.getEnergyCostPerTick(), false);
                this.setCurrentProgress(this.getCurrentProgress() + 1);
            }
        }
        if (this.getCurrentProgress() >= this.getMaxProgress()) {
            this.craftItem();
        }
    }

    @Override
    protected boolean hasRecipe() {
        boolean bl;
        block7: {
            if (!this.hasEnoughEnergy()) {
                return false;
            }
            ItemStack topStack = this.getItemHandler().getStackInSlot(0);
            if (topStack.isEmpty()) {
                return false;
            }
            Object[] objectArray = new ItemStack[]{this.getItemHandler().getStackInSlot(1), this.getItemHandler().getStackInSlot(2), this.getItemHandler().getStackInSlot(3)};
            List bottomStacks = CollectionsKt.listOf((Object[])objectArray);
            Iterable $this$any$iv = bottomStacks;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    ItemStack bottomStack = (ItemStack)element$iv;
                    boolean bl3 = false;
                    if (bottomStack.isEmpty()) {
                        bl2 = false;
                    } else {
                        Intrinsics.checkNotNull((Object)topStack);
                        Intrinsics.checkNotNull((Object)bottomStack);
                        IncubatorRecipeInput input = new IncubatorRecipeInput(topStack, bottomStack, this.isHighTemperature);
                        Level level = this.level;
                        Intrinsics.checkNotNull((Object)level);
                        bl2 = AbstractIncubatorRecipe.Companion.hasIncubatorRecipe(level, input);
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    protected void craftItem() {
        ItemStack topStack = this.getItemHandler().getStackInSlot(0);
        Object[] objectArray = new Integer[]{1, 2, 3};
        List bottleSlots = CollectionsKt.listOf((Object[])objectArray);
        boolean onlyDupeCellRecipes = true;
        Iterator iterator = bottleSlots.iterator();
        while (iterator.hasNext()) {
            int slotIndex = ((Number)iterator.next()).intValue();
            ItemStack bottomStack = this.getItemHandler().getStackInSlot(slotIndex);
            Intrinsics.checkNotNull((Object)topStack);
            Intrinsics.checkNotNull((Object)bottomStack);
            IncubatorRecipeInput incubatorInput = new IncubatorRecipeInput(topStack, bottomStack, this.isHighTemperature);
            Level level = this.level;
            Intrinsics.checkNotNull((Object)level);
            AbstractIncubatorRecipe incubatorRecipe = AbstractIncubatorRecipe.Companion.getIncubatorRecipe(level, incubatorInput);
            if (incubatorRecipe != null) {
                ItemStack output;
                if (!(incubatorRecipe instanceof DupeCellRecipe)) {
                    onlyDupeCellRecipes = false;
                }
                if (!AaronExtensions.INSTANCE.isNotEmpty(output = incubatorRecipe instanceof GmoRecipe ? this.gmoRecipeOutput((GmoRecipe)incubatorRecipe, incubatorInput) : this.nonGmoRecipeOutput(incubatorRecipe))) continue;
                this.getItemHandler().setStackInSlot(slotIndex, output);
                continue;
            }
            Level level2 = this.level;
            Intrinsics.checkNotNull((Object)level2);
            PotionBrewing potionBrewing = level2.potionBrewing();
            boolean hasMix = potionBrewing.hasMix(bottomStack, topStack);
            if (!hasMix) continue;
            onlyDupeCellRecipes = false;
            ItemStack output = potionBrewing.mix(topStack, bottomStack);
            Intrinsics.checkNotNull((Object)output);
            if (!AaronExtensions.INSTANCE.isNotEmpty(output)) continue;
            this.getItemHandler().setStackInSlot(slotIndex, output);
        }
        if (!onlyDupeCellRecipes) {
            topStack.shrink(1);
        }
    }

    private final ItemStack gmoRecipeOutput(GmoRecipe gmoRecipe, IncubatorRecipeInput input) {
        ItemStack itemStack;
        Level level = this.level;
        if (level == null) {
            ItemStack itemStack2 = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"EMPTY");
            return itemStack2;
        }
        Level level2 = level;
        float chanceDecreasePerOverclocker = (float)((Number)ServerConfig.Companion.getCONFIG().getIncubatorOverclockerChanceDecrease().get()).doubleValue();
        float chanceIncreasePerChorus = (float)((Number)ServerConfig.Companion.getCONFIG().getIncubatorChorusFruitChanceIncrease().get()).doubleValue();
        float geneChance = gmoRecipe.getGeneChance();
        float overclockerChanceFactor = 1.0f - (float)this.getAmountOfOverclocks() * chanceDecreasePerOverclocker;
        float reducedChance = RangesKt.coerceIn((float)(geneChance * overclockerChanceFactor), (float)0.0f, (float)1.0f);
        int chorusRequiredForMaxChance = Mth.ceil((float)((1.0f - reducedChance) / chanceIncreasePerChorus));
        int chorusAvailable = this.getItemHandler().getStackInSlot(4).getCount();
        int chorusUsed = Math.min(chorusRequiredForMaxChance, chorusAvailable);
        this.getItemHandler().getStackInSlot(4).shrink(chorusUsed);
        float chorusBoost = (float)chorusUsed * chanceIncreasePerChorus;
        float finalChance = reducedChance + chorusBoost;
        RandomSource randomSource = level2.random;
        Intrinsics.checkNotNullExpressionValue((Object)randomSource, (String)"random");
        if (AaronExtensions.INSTANCE.chance(randomSource, (Number)Float.valueOf(finalChance))) {
            RegistryAccess registryAccess = level2.registryAccess();
            Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
            itemStack = gmoRecipe.assemble(input, (HolderLookup.Provider)registryAccess);
        } else {
            RegistryAccess registryAccess = level2.registryAccess();
            Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
            itemStack = gmoRecipe.getFailure((HolderLookup.Provider)registryAccess);
        }
        return itemStack;
    }

    private final ItemStack nonGmoRecipeOutput(AbstractIncubatorRecipe incubatorRecipe) {
        Level level = this.level;
        if (level == null) {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        Level level2 = level;
        ItemStack itemStack = this.getItemHandler().getStackInSlot(0);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getStackInSlot(...)");
        ItemStack itemStack2 = this.getItemHandler().getStackInSlot(1);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"getStackInSlot(...)");
        ItemStack output = incubatorRecipe.assemble(new IncubatorRecipeInput(itemStack, itemStack2, this.isHighTemperature), (HolderLookup.Provider)level2.registryAccess());
        Intrinsics.checkNotNull((Object)output);
        return output;
    }

    @NotNull
    public AbstractContainerMenu createMenu(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return (AbstractContainerMenu)new AdvancedIncubatorMenu(containerId, playerInventory, (Container)this.getContainer(), this.getContainerData());
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.saveAdditional(tag, registries);
        tag.putBoolean(IS_HIGH_TEMPERATURE_TAG, this.isHighTemperature);
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.loadAdditional(tag, registries);
        this.setHighTemperature(tag.getBoolean(IS_HIGH_TEMPERATURE_TAG));
    }

    private static final int baseEnergyCostPerTick$lambda$0() {
        return 10;
    }

    private static final int containerData$lambda$1(AdvancedIncubatorBlockEntity this$0) {
        return this$0.getCurrentProgress();
    }

    private static final int containerData$lambda$2(AdvancedIncubatorBlockEntity this$0) {
        return this$0.getMaxProgress();
    }

    public static final /* synthetic */ void access$setCurrentProgress(AdvancedIncubatorBlockEntity $this, int value) {
        $this.setCurrentProgress(value);
    }

    public static final /* synthetic */ void access$setHighTemperature(AdvancedIncubatorBlockEntity $this, boolean value) {
        $this.setHighTemperature(value);
    }

    public static final /* synthetic */ Level access$getLevel$p$s-699333455(AdvancedIncubatorBlockEntity $this) {
        return $this.level;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0010\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/block/block_entity/AdvancedIncubatorBlockEntity$Companion;", "", "<init>", "()V", "IS_HIGH_TEMPERATURE_TAG", "", "INVENTORY_SIZE", "", "TOP_SLOT_INDEX", "LEFT_BOTTLE_SLOT_INDEX", "MIDDLE_BOTTLE_SLOT_INDEX", "RIGHT_BOTTLE_SLOT_INDEX", "CHORUS_SLOT_INDEX", "OVERCLOCKER_SLOT_INDEX", "CONTAINER_DATA_SIZE", "IS_HIGH_TEMPERATURE_INDEX", "getIncubatorLowTemperatureTickFactor", "geneticsresequenced-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        public final int getIncubatorLowTemperatureTickFactor() {
            Object object = ServerConfig.Companion.getCONFIG().getIncubatorLowTempTickFactor().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            return ((Number)object).intValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

