/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.block.block_entity;

import dev.aaronhowser.mods.aaron.ImprovedSimpleContainer;
import dev.aaronhowser.mods.geneticsresequenced.GeneticsResequenced;
import dev.aaronhowser.mods.geneticsresequenced.block.base.CraftingMachineBlockEntity;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.item.DnaHelixItem;
import dev.aaronhowser.mods.geneticsresequenced.item.EntityDnaItem;
import dev.aaronhowser.mods.geneticsresequenced.menu.dna_extractor.DnaExtractorMenu;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModBlockEntityTypes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import java.util.function.IntSupplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0016\u001a\u00020\u0017H\u0014J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0014J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\u0013X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006$"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/block/block_entity/DnaExtractorBlockEntity;", "Ldev/aaronhowser/mods/geneticsresequenced/block/base/CraftingMachineBlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "baseEnergyCostPerTick", "Ljava/util/function/IntSupplier;", "getBaseEnergyCostPerTick", "()Ljava/util/function/IntSupplier;", "maxEnergy", "", "getMaxEnergy", "()I", "energyTransferRate", "getEnergyTransferRate", "itemHandler", "Lnet/neoforged/neoforge/items/wrapper/InvWrapper;", "getItemHandler", "()Lnet/neoforged/neoforge/items/wrapper/InvWrapper;", "hasRecipe", "", "getOutputFromInput", "Lnet/minecraft/world/item/ItemStack;", "input", "craftItem", "", "createMenu", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "containerId", "playerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "player", "Lnet/minecraft/world/entity/player/Player;", "geneticsresequenced-1.21.1"})
public final class DnaExtractorBlockEntity
extends CraftingMachineBlockEntity {
    @NotNull
    private final IntSupplier baseEnergyCostPerTick;
    private final int maxEnergy;
    private final int energyTransferRate;
    @NotNull
    private final InvWrapper itemHandler;

    public DnaExtractorBlockEntity(@NotNull BlockPos pos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Object object = ModBlockEntityTypes.INSTANCE.getDNA_EXTRACTOR().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        super((BlockEntityType)object, pos, blockState);
        this.baseEnergyCostPerTick = DnaExtractorBlockEntity::baseEnergyCostPerTick$lambda$0;
        this.maxEnergy = 60000;
        this.energyTransferRate = 256;
        ImprovedSimpleContainer improvedSimpleContainer = this.getContainer();
        this.itemHandler = new InvWrapper(improvedSimpleContainer){

            public boolean isItemValid(int slot, ItemStack stack) {
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                return switch (slot) {
                    case 0 -> {
                        if (stack.is((Holder)ModItems.INSTANCE.getCELL()) || stack.is((Holder)ModItems.INSTANCE.getGMO_CELL())) {
                            yield true;
                        }
                        yield false;
                    }
                    case 2 -> stack.is((Holder)ModItems.INSTANCE.getOVERCLOCKER());
                    case 1 -> false;
                    default -> false;
                };
            }
        };
    }

    @Override
    @NotNull
    public IntSupplier getBaseEnergyCostPerTick() {
        return this.baseEnergyCostPerTick;
    }

    @Override
    public int getMaxEnergy() {
        return this.maxEnergy;
    }

    @Override
    public int getEnergyTransferRate() {
        return this.energyTransferRate;
    }

    @Override
    @NotNull
    protected InvWrapper getItemHandler() {
        return this.itemHandler;
    }

    @Override
    protected boolean hasRecipe() {
        ItemStack inputStack = this.getItemHandler().getStackInSlot(0);
        if (!inputStack.is((Holder)ModItems.INSTANCE.getCELL()) && !inputStack.is((Holder)ModItems.INSTANCE.getGMO_CELL())) {
            return false;
        }
        Intrinsics.checkNotNull((Object)inputStack);
        ItemStack itemStack = this.getOutputFromInput(inputStack);
        if (itemStack == null) {
            return false;
        }
        ItemStack outputStack = itemStack;
        return this.outputSlotHasRoom(outputStack);
    }

    private final ItemStack getOutputFromInput(ItemStack input) {
        if (input.is((Holder)ModItems.INSTANCE.getGMO_CELL())) {
            Holder<Gene> holder = DnaHelixItem.Companion.getGeneHolder(input);
            if (holder == null) {
                return null;
            }
            Holder<Gene> geneHolder = holder;
            return DnaHelixItem.Companion.getHelixStack(geneHolder);
        }
        if (input.is((Holder)ModItems.INSTANCE.getCELL())) {
            EntityType<?> entityType = EntityDnaItem.Companion.getEntityType(input);
            if (entityType == null) {
                return null;
            }
            EntityType<?> mobType = entityType;
            ItemStack dnaStack = ModItems.INSTANCE.getDNA_HELIX().toStack();
            Intrinsics.checkNotNull((Object)dnaStack);
            boolean setWorked = EntityDnaItem.Companion.setEntityType(dnaStack, mobType);
            if (!setWorked) {
                GeneticsResequenced.Companion.getLOGGER().error("A DNA Extractor tried to set an invalid entity type at " + this.getBlockPos().getX() + ", " + this.getBlockPos().getY() + ", " + this.getBlockPos().getZ() + ": " + mobType.getDescriptionId());
                return null;
            }
            return dnaStack;
        }
        return null;
    }

    @Override
    protected void craftItem() {
        ItemStack inputStack = this.getItemHandler().getStackInSlot(0);
        Intrinsics.checkNotNull((Object)inputStack);
        ItemStack itemStack = this.getOutputFromInput(inputStack);
        if (itemStack == null) {
            return;
        }
        ItemStack outputStack = itemStack;
        this.getItemHandler().extractItem(0, 1, false);
        this.getItemHandler().insertItem(1, outputStack, false);
    }

    @NotNull
    public AbstractContainerMenu createMenu(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return (AbstractContainerMenu)new DnaExtractorMenu(containerId, playerInventory, (Container)this.getContainer(), this.getContainerData());
    }

    private static final int baseEnergyCostPerTick$lambda$0() {
        return 32;
    }
}

