/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.block.block_entity;

import dev.aaronhowser.mods.aaron.AaronExtensions;
import dev.aaronhowser.mods.aaron.ImprovedSimpleContainer;
import dev.aaronhowser.mods.geneticsresequenced.block.base.CraftingMachineBlockEntity;
import dev.aaronhowser.mods.geneticsresequenced.config.ServerConfig;
import dev.aaronhowser.mods.geneticsresequenced.menu.incubator.IncubatorMenu;
import dev.aaronhowser.mods.geneticsresequenced.recipe.base.AbstractIncubatorRecipe;
import dev.aaronhowser.mods.geneticsresequenced.recipe.base.IncubatorRecipeInput;
import dev.aaronhowser.mods.geneticsresequenced.recipe.incubator.DupeCellRecipe;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModBlockEntityTypes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.IntSupplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.items.wrapper.RangedWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 /2\u00020\u0001:\u0001/B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0016J\b\u0010\"\u001a\u00020\rH\u0016J\b\u0010#\u001a\u00020$H\u0014J\b\u0010%\u001a\u00020&H\u0014J\b\u0010'\u001a\u00020$H\u0014J \u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/block/block_entity/IncubatorBlockEntity;", "Ldev/aaronhowser/mods/geneticsresequenced/block/base/CraftingMachineBlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "baseEnergyCostPerTick", "Ljava/util/function/IntSupplier;", "getBaseEnergyCostPerTick", "()Ljava/util/function/IntSupplier;", "maxEnergy", "", "getMaxEnergy", "()I", "energyTransferRate", "getEnergyTransferRate", "container", "Ldev/aaronhowser/mods/aaron/ImprovedSimpleContainer;", "getContainer", "()Ldev/aaronhowser/mods/aaron/ImprovedSimpleContainer;", "itemHandler", "Lnet/neoforged/neoforge/items/wrapper/InvWrapper;", "getItemHandler", "()Lnet/neoforged/neoforge/items/wrapper/InvWrapper;", "inputHandler", "Lnet/neoforged/neoforge/items/wrapper/RangedWrapper;", "getInputHandler", "()Lnet/neoforged/neoforge/items/wrapper/RangedWrapper;", "bottleHandler", "Lnet/neoforged/neoforge/items/IItemHandler;", "direction", "Lnet/minecraft/core/Direction;", "getAmountOfOverclocks", "serverTick", "", "hasRecipe", "", "craftItem", "createMenu", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "containerId", "playerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "player", "Lnet/minecraft/world/entity/player/Player;", "Companion", "geneticsresequenced-1.21.1"})
@SourceDebugExtension(value={"SMAP\nIncubatorBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IncubatorBlockEntity.kt\ndev/aaronhowser/mods/geneticsresequenced/block/block_entity/IncubatorBlockEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,172:1\n1761#2,3:173\n*S KotlinDebug\n*F\n+ 1 IncubatorBlockEntity.kt\ndev/aaronhowser/mods/geneticsresequenced/block/block_entity/IncubatorBlockEntity\n*L\n104#1:173,3\n*E\n"})
public final class IncubatorBlockEntity
extends CraftingMachineBlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IntSupplier baseEnergyCostPerTick;
    private final int maxEnergy;
    private final int energyTransferRate;
    @NotNull
    private final ImprovedSimpleContainer container;
    @NotNull
    private final InvWrapper itemHandler;
    @NotNull
    private final RangedWrapper inputHandler;
    @NotNull
    private final RangedWrapper bottleHandler;
    public static final int INVENTORY_SIZE = 5;
    public static final int TOP_SLOT_INDEX = 0;
    public static final int LEFT_BOTTLE_SLOT_INDEX = 1;
    public static final int MIDDLE_BOTTLE_SLOT_INDEX = 2;
    public static final int RIGHT_BOTTLE_SLOT_INDEX = 3;
    public static final int OVERCLOCKER_SLOT_INDEX = 4;

    public IncubatorBlockEntity(@NotNull BlockPos pos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Object object = ModBlockEntityTypes.INSTANCE.getINCUBATOR().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        super((BlockEntityType)object, pos, blockState);
        this.baseEnergyCostPerTick = IncubatorBlockEntity::baseEnergyCostPerTick$lambda$0;
        this.maxEnergy = 50000;
        this.energyTransferRate = 500;
        this.container = new ImprovedSimpleContainer(this){
            final /* synthetic */ IncubatorBlockEntity this$0;
            {
                this.this$0 = $receiver;
                super((BlockEntity)$receiver, 5);
            }

            public void setChanged() {
                super.setChanged();
                IncubatorBlockEntity.access$setCurrentProgress(this.this$0, 0);
            }
        };
        ImprovedSimpleContainer improvedSimpleContainer = this.getContainer();
        this.itemHandler = new InvWrapper(this, improvedSimpleContainer){
            final /* synthetic */ IncubatorBlockEntity this$0;
            {
                this.this$0 = $receiver;
                super((Container)$super_call_param$1);
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                Level level = IncubatorBlockEntity.access$getLevel$p$s1690168687(this.this$0);
                if (level == null) {
                    return false;
                }
                Level level2 = level;
                return switch (slot) {
                    case 0 -> AbstractIncubatorRecipe.Companion.isValidTopIngredient(level2, stack);
                    case 1, 2, 3 -> AbstractIncubatorRecipe.Companion.isValidBottomIngredient(level2, stack);
                    case 4 -> stack.is((Holder)ModItems.INSTANCE.getOVERCLOCKER());
                    default -> false;
                };
            }
        };
        this.inputHandler = new RangedWrapper((IItemHandlerModifiable)this.getItemHandler(), 0, 1);
        this.bottleHandler = new RangedWrapper((IItemHandlerModifiable)this.getItemHandler(), 1, 4);
    }

    @Override
    @NotNull
    public IntSupplier getBaseEnergyCostPerTick() {
        return this.baseEnergyCostPerTick;
    }

    @Override
    public int getMaxEnergy() {
        return this.maxEnergy;
    }

    @Override
    public int getEnergyTransferRate() {
        return this.energyTransferRate;
    }

    @Override
    @NotNull
    public ImprovedSimpleContainer getContainer() {
        return this.container;
    }

    @Override
    @NotNull
    protected InvWrapper getItemHandler() {
        return this.itemHandler;
    }

    @Override
    @NotNull
    protected RangedWrapper getInputHandler() {
        return this.inputHandler;
    }

    @Override
    @Nullable
    public IItemHandler getItemHandler(@Nullable Direction direction) {
        Direction direction2 = direction;
        return switch (direction2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction2.ordinal()]) {
            case 1 -> (IItemHandler)this.getInputHandler();
            case 2 -> (IItemHandler)this.getOutputHandler();
            default -> (IItemHandler)this.bottleHandler;
        };
    }

    @Override
    public int getAmountOfOverclocks() {
        return this.getContainer().getItem(4).getCount();
    }

    @Override
    protected void serverTick() {
        if (!this.hasEnoughEnergy()) {
            return;
        }
        if (!this.hasRecipe()) {
            this.setCurrentProgress(0);
            return;
        }
        this.setMaxProgress(Companion.getTicksPerBrew());
        this.getEnergyStorage().extractEnergy(this.getEnergyCostPerTick(), false);
        this.setCurrentProgress(this.getCurrentProgress() + (1 + this.getAmountOfOverclocks()));
        while (this.getCurrentProgress() >= this.getMaxProgress()) {
            this.craftItem();
            this.setCurrentProgress(this.getCurrentProgress() - this.getMaxProgress());
        }
    }

    @Override
    protected boolean hasRecipe() {
        boolean bl;
        block7: {
            Level level = this.level;
            if (level == null) {
                return false;
            }
            Level level2 = level;
            ItemStack topStack = this.getItemHandler().getStackInSlot(0);
            if (topStack.isEmpty()) {
                return false;
            }
            Object[] objectArray = new ItemStack[]{this.getItemHandler().getStackInSlot(1), this.getItemHandler().getStackInSlot(2), this.getItemHandler().getStackInSlot(3)};
            List bottomStacks = CollectionsKt.listOf((Object[])objectArray);
            Iterable $this$any$iv = bottomStacks;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    ItemStack bottomStack = (ItemStack)element$iv;
                    boolean bl3 = false;
                    if (bottomStack.isEmpty()) {
                        bl2 = false;
                    } else {
                        Intrinsics.checkNotNull((Object)topStack);
                        Intrinsics.checkNotNull((Object)bottomStack);
                        IncubatorRecipeInput input = new IncubatorRecipeInput(topStack, bottomStack, true);
                        bl2 = AbstractIncubatorRecipe.Companion.hasIncubatorRecipe(level2, input);
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    protected void craftItem() {
        ItemStack topStack = this.getItemHandler().getStackInSlot(0);
        Object[] objectArray = new Integer[]{1, 2, 3};
        List bottleSlots = CollectionsKt.listOf((Object[])objectArray);
        boolean onlyDupeCellRecipes = true;
        Iterator iterator = bottleSlots.iterator();
        while (iterator.hasNext()) {
            int slotIndex = ((Number)iterator.next()).intValue();
            ItemStack bottomStack = this.getItemHandler().getStackInSlot(slotIndex);
            Intrinsics.checkNotNull((Object)topStack);
            Intrinsics.checkNotNull((Object)bottomStack);
            IncubatorRecipeInput recipeInput = new IncubatorRecipeInput(topStack, bottomStack, true);
            Level level = this.level;
            Intrinsics.checkNotNull((Object)level);
            AbstractIncubatorRecipe incubatorRecipe = AbstractIncubatorRecipe.Companion.getIncubatorRecipe(level, recipeInput);
            if (incubatorRecipe != null) {
                if (!(incubatorRecipe instanceof DupeCellRecipe)) {
                    onlyDupeCellRecipes = false;
                }
                RecipeInput recipeInput2 = recipeInput;
                Level level2 = this.level;
                Intrinsics.checkNotNull((Object)level2);
                ItemStack output = incubatorRecipe.assemble(recipeInput2, (HolderLookup.Provider)level2.registryAccess());
                Intrinsics.checkNotNull((Object)output);
                if (!AaronExtensions.INSTANCE.isNotEmpty(output)) continue;
                this.getItemHandler().setStackInSlot(slotIndex, output);
                continue;
            }
            Level level3 = this.level;
            Intrinsics.checkNotNull((Object)level3);
            PotionBrewing potionBrewing = level3.potionBrewing();
            boolean hasMix = potionBrewing.hasMix(bottomStack, topStack);
            if (!hasMix) continue;
            onlyDupeCellRecipes = false;
            ItemStack output = potionBrewing.mix(topStack, bottomStack);
            Intrinsics.checkNotNull((Object)output);
            if (!AaronExtensions.INSTANCE.isNotEmpty(output)) continue;
            this.getItemHandler().setStackInSlot(slotIndex, output);
        }
        if (!onlyDupeCellRecipes) {
            topStack.shrink(1);
        }
    }

    @NotNull
    public AbstractContainerMenu createMenu(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return (AbstractContainerMenu)new IncubatorMenu(containerId, playerInventory, (Container)this.getContainer(), this.getContainerData());
    }

    private static final int baseEnergyCostPerTick$lambda$0() {
        return 10;
    }

    public static final /* synthetic */ void access$setCurrentProgress(IncubatorBlockEntity $this, int value) {
        $this.setCurrentProgress(value);
    }

    public static final /* synthetic */ Level access$getLevel$p$s1690168687(IncubatorBlockEntity $this) {
        return $this.level;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000b\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/block/block_entity/IncubatorBlockEntity$Companion;", "", "<init>", "()V", "INVENTORY_SIZE", "", "TOP_SLOT_INDEX", "LEFT_BOTTLE_SLOT_INDEX", "MIDDLE_BOTTLE_SLOT_INDEX", "RIGHT_BOTTLE_SLOT_INDEX", "OVERCLOCKER_SLOT_INDEX", "getTicksPerBrew", "geneticsresequenced-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        public final int getTicksPerBrew() {
            Object object = ServerConfig.Companion.getCONFIG().getIncubatorTicksPerBrew().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            return ((Number)object).intValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.UP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.DOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

