/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.command.gene;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.aaronhowser.mods.geneticsresequenced.GeneticsResequenced;
import dev.aaronhowser.mods.geneticsresequenced.attachment.GenesData;
import dev.aaronhowser.mods.geneticsresequenced.command.ModCommands;
import dev.aaronhowser.mods.geneticsresequenced.datagen.lang.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\f\u0012\u0004\u0012\u00020\t\u0012\u0002\b\u00030\bJ2\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\b\u0002\u0010\u0010\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0012\u0018\u00010\u0011H\u0002J2\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\u0013\u001a\u00020\u00052\u0012\b\u0002\u0010\u0010\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0012\u0018\u00010\u0011H\u0002J8\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0012\b\u0002\u0010\u0010\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0012\u0018\u00010\u0011H\u0002J,\u0010\u0017\u001a\u00020\u00182\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J2\u0010\u001c\u001a\u00020\u00182\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001e2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u001e\u0010\u001f\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/command/gene/GiveGeneCommand;", "", "<init>", "()V", "GENE_ID_ARGUMENT", "", "TARGET_ARGUMENT", "register", "Lcom/mojang/brigadier/builder/ArgumentBuilder;", "Lnet/minecraft/commands/CommandSourceStack;", "addGene", "", "context", "Lcom/mojang/brigadier/context/CommandContext;", "geneRl", "Lnet/minecraft/resources/ResourceLocation;", "entities", "", "Lnet/minecraft/world/entity/Entity;", "geneString", "geneToAdd", "Lnet/minecraft/core/Holder;", "Ldev/aaronhowser/mods/geneticsresequenced/gene/Gene;", "handleSingleTarget", "", "target", "Lnet/minecraft/world/entity/LivingEntity;", "geneHolder", "handleMultipleTargets", "targets", "", "addGeneToTarget", "", "geneticsresequenced-1.21.1"})
@SourceDebugExtension(value={"SMAP\nGiveGeneCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GiveGeneCommand.kt\ndev/aaronhowser/mods/geneticsresequenced/command/gene/GiveGeneCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,178:1\n1617#2,9:179\n1869#2:188\n1870#2:190\n1626#2:191\n1#3:189\n*S KotlinDebug\n*F\n+ 1 GiveGeneCommand.kt\ndev/aaronhowser/mods/geneticsresequenced/command/gene/GiveGeneCommand\n*L\n88#1:179,9\n88#1:188\n88#1:190\n88#1:191\n88#1:189\n*E\n"})
public final class GiveGeneCommand {
    @NotNull
    public static final GiveGeneCommand INSTANCE = new GiveGeneCommand();
    @NotNull
    private static final String GENE_ID_ARGUMENT = "gene_id";
    @NotNull
    private static final String TARGET_ARGUMENT = "targets";

    private GiveGeneCommand() {
    }

    @NotNull
    public final ArgumentBuilder<CommandSourceStack, ?> register() {
        ArgumentBuilder argumentBuilder = ((LiteralArgumentBuilder)Commands.literal((String)"give").requires(GiveGeneCommand::register$lambda$0)).then(((RequiredArgumentBuilder)Commands.argument((String)GENE_ID_ARGUMENT, (ArgumentType)((ArgumentType)ResourceLocationArgument.id())).suggests(ModCommands.INSTANCE.getSUGGEST_GENE_RLS()).executes(GiveGeneCommand::register$lambda$1)).then(Commands.argument((String)TARGET_ARGUMENT, (ArgumentType)((ArgumentType)EntityArgument.entities())).executes(GiveGeneCommand::register$lambda$2)));
        Intrinsics.checkNotNullExpressionValue((Object)argumentBuilder, (String)"then(...)");
        return argumentBuilder;
    }

    private final int addGene(CommandContext<CommandSourceStack> context, ResourceLocation geneRl, Collection<? extends Entity> entities) {
        RegistryAccess registryAccess = ((CommandSourceStack)context.getSource()).registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        Holder.Reference<Gene> reference = ModGenes.fromResourceLocation((HolderLookup.Provider)registryAccess, geneRl);
        if (reference == null) {
            throw new IllegalArgumentException("Gene with id " + geneRl + " does not exist!");
        }
        Holder.Reference<Gene> gene = reference;
        return this.addGene(context, (Holder<Gene>)((Holder)gene), entities);
    }

    static /* synthetic */ int addGene$default(GiveGeneCommand giveGeneCommand, CommandContext commandContext, ResourceLocation resourceLocation, Collection collection, int n, Object object) {
        if ((n & 4) != 0) {
            collection = null;
        }
        return giveGeneCommand.addGene((CommandContext<CommandSourceStack>)commandContext, resourceLocation, (Collection<? extends Entity>)collection);
    }

    private final int addGene(CommandContext<CommandSourceStack> context, String geneString, Collection<? extends Entity> entities) {
        RegistryAccess registryAccess = ((CommandSourceStack)context.getSource()).registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        Holder.Reference<Gene> reference = ModGenes.fromIdPath((HolderLookup.Provider)registryAccess, geneString);
        if (reference == null) {
            throw new IllegalArgumentException("Gene with id " + geneString + " does not exist!");
        }
        Holder.Reference<Gene> gene = reference;
        return this.addGene(context, (Holder<Gene>)((Holder)gene), entities);
    }

    static /* synthetic */ int addGene$default(GiveGeneCommand giveGeneCommand, CommandContext commandContext, String string, Collection collection, int n, Object object) {
        if ((n & 4) != 0) {
            collection = null;
        }
        return giveGeneCommand.addGene((CommandContext<CommandSourceStack>)commandContext, string, (Collection<? extends Entity>)collection);
    }

    /*
     * WARNING - void declaration
     */
    private final int addGene(CommandContext<CommandSourceStack> context, Holder<Gene> geneToAdd, Collection<? extends Entity> entities) {
        List targets;
        Collection<? extends Entity> collection = entities;
        if (collection != null) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = collection;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                LivingEntity it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Entity it = (Entity)element$iv$iv;
                boolean bl2 = false;
                if ((it instanceof LivingEntity ? (LivingEntity)it : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            v1 = (List)destination$iv$iv;
        } else {
            Entity entity = ((CommandSourceStack)context.getSource()).getEntity();
            v1 = targets = CollectionsKt.listOfNotNull((Object)(entity instanceof LivingEntity ? (LivingEntity)entity : null));
        }
        if (targets.size() == 1) {
            this.handleSingleTarget(context, (LivingEntity)CollectionsKt.first((List)targets), geneToAdd);
        } else {
            this.handleMultipleTargets(context, targets, geneToAdd);
        }
        return 1;
    }

    static /* synthetic */ int addGene$default(GiveGeneCommand giveGeneCommand, CommandContext commandContext, Holder holder, Collection collection, int n, Object object) {
        if ((n & 4) != 0) {
            collection = null;
        }
        return giveGeneCommand.addGene((CommandContext<CommandSourceStack>)commandContext, (Holder<Gene>)holder, (Collection<? extends Entity>)collection);
    }

    private final void handleSingleTarget(CommandContext<CommandSourceStack> context, LivingEntity target, Holder<Gene> geneHolder) {
        boolean geneWasAdded = this.addGeneToTarget(target, geneHolder);
        if (geneWasAdded) {
            Object[] objectArray = new Object[]{Gene.Companion.getName(geneHolder), target.getName()};
            MutableComponent component = ModLanguageProvider.Companion.toComponent("command.geneticsresequenced.add_gene.single_target.success", objectArray);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> GiveGeneCommand.handleSingleTarget$lambda$4(component), false);
        } else {
            Object[] objectArray = new Object[]{Gene.Companion.getName(geneHolder), target.getName()};
            MutableComponent component = ModLanguageProvider.Companion.toComponent("command.geneticsresequenced.add_gene.single_target.fail", objectArray);
            ((CommandSourceStack)context.getSource()).sendFailure((Component)component);
        }
    }

    private final void handleMultipleTargets(CommandContext<CommandSourceStack> context, List<? extends LivingEntity> targets, Holder<Gene> geneHolder) {
        MutableComponent component;
        int amountSuccess = 0;
        int amountFail = 0;
        for (LivingEntity objectArray : targets) {
            boolean geneWasAdded = this.addGeneToTarget(objectArray, geneHolder);
            if (geneWasAdded) {
                ++amountSuccess;
                continue;
            }
            ++amountFail;
        }
        if (amountSuccess != 0) {
            Object[] objectArray = new Object[]{Gene.Companion.getName(geneHolder), amountSuccess};
            component = ModLanguageProvider.Companion.toComponent("command.geneticsresequenced.add_gene.multiple_targets.success", objectArray);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> GiveGeneCommand.handleMultipleTargets$lambda$5(component), false);
        }
        if (amountFail != 0) {
            Object[] objectArray = new Object[]{Gene.Companion.getName(geneHolder), amountFail};
            component = ModLanguageProvider.Companion.toComponent("command.geneticsresequenced.add_gene.multiple_targets.fail", objectArray);
            ((CommandSourceStack)context.getSource()).sendFailure((Component)component);
        }
    }

    private final boolean addGeneToTarget(LivingEntity target, Holder<Gene> geneHolder) {
        boolean alreadyHasGene = GenesData.Companion.hasGene((Entity)target, geneHolder);
        if (alreadyHasGene) {
            Logger logger = GeneticsResequenced.Companion.getLOGGER();
            ResourceKey resourceKey = geneHolder.getKey();
            Intrinsics.checkNotNull((Object)resourceKey);
            logger.info("Tried to add gene " + resourceKey.location() + " to " + target.getName().getString() + ", but they already have it!");
            return false;
        }
        if (!((Gene)geneHolder.value()).canEntityHave((Entity)target)) {
            Logger logger = GeneticsResequenced.Companion.getLOGGER();
            ResourceKey resourceKey = geneHolder.getKey();
            Intrinsics.checkNotNull((Object)resourceKey);
            logger.info("Tried to add gene " + resourceKey.location() + " to " + target.getName().getString() + ", but they can't have it!");
            return false;
        }
        boolean success = GenesData.Companion.addGene(target, geneHolder);
        return success;
    }

    private static final boolean register$lambda$0(CommandSourceStack it) {
        return it.hasPermission(2);
    }

    private static final int register$lambda$1(CommandContext cmd) {
        Intrinsics.checkNotNull((Object)cmd);
        ResourceLocation resourceLocation = ResourceLocationArgument.getId((CommandContext)cmd, (String)GENE_ID_ARGUMENT);
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"getId(...)");
        return INSTANCE.addGene((CommandContext<CommandSourceStack>)cmd, resourceLocation, null);
    }

    private static final int register$lambda$2(CommandContext cmd) {
        Intrinsics.checkNotNull((Object)cmd);
        ResourceLocation resourceLocation = ResourceLocationArgument.getId((CommandContext)cmd, (String)GENE_ID_ARGUMENT);
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"getId(...)");
        return INSTANCE.addGene((CommandContext<CommandSourceStack>)cmd, resourceLocation, (Collection<? extends Entity>)EntityArgument.getEntities((CommandContext)cmd, (String)TARGET_ARGUMENT));
    }

    private static final Component handleSingleTarget$lambda$4(MutableComponent $component) {
        return (Component)$component;
    }

    private static final Component handleMultipleTargets$lambda$5(MutableComponent $component) {
        return (Component)$component;
    }
}

