/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.compatibility.recipe.emi.recipe.machine;

import dev.aaronhowser.mods.geneticsresequenced.compatibility.recipe.emi.ModEmiPlugin;
import dev.aaronhowser.mods.geneticsresequenced.datagen.lang.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.item.DnaHelixItem;
import dev.aaronhowser.mods.geneticsresequenced.item.PlasmidItem;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import dev.aaronhowser.mods.geneticsresequenced.util.ClientUtil;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0016H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/compatibility/recipe/emi/recipe/machine/PlasmidInfuserEmiRecipe;", "Ldev/emi/emi/api/recipe/EmiRecipe;", "geneHolder", "Lnet/minecraft/core/Holder;", "Ldev/aaronhowser/mods/geneticsresequenced/gene/Gene;", "basic", "", "<init>", "(Lnet/minecraft/core/Holder;Z)V", "getGeneHolder", "()Lnet/minecraft/core/Holder;", "getBasic", "()Z", "helix", "Ldev/emi/emi/api/stack/EmiIngredient;", "plasmid", "Ldev/emi/emi/api/stack/EmiStack;", "getCategory", "Ldev/emi/emi/api/recipe/EmiRecipeCategory;", "getId", "Lnet/minecraft/resources/ResourceLocation;", "getInputs", "", "getOutputs", "getDisplayWidth", "", "getDisplayHeight", "tooltips", "Lnet/minecraft/network/chat/Component;", "addWidgets", "", "widgets", "Ldev/emi/emi/api/widget/WidgetHolder;", "Companion", "geneticsresequenced-1.21.1"})
public final class PlasmidInfuserEmiRecipe
implements EmiRecipe {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Holder<Gene> geneHolder;
    private final boolean basic;
    @NotNull
    private final EmiIngredient helix;
    @NotNull
    private final EmiStack plasmid;
    @NotNull
    private final List<Component> tooltips;

    public PlasmidInfuserEmiRecipe(@NotNull Holder<Gene> geneHolder, boolean basic) {
        Holder holder;
        Intrinsics.checkNotNullParameter(geneHolder, (String)"geneHolder");
        this.geneHolder = geneHolder;
        this.basic = basic;
        int stackSize = Math.max(1, this.basic ? ((Gene)this.geneHolder.value()).getDnaPointsRequired() : ((Gene)this.geneHolder.value()).getDnaPointsRequired() / 2);
        if (this.basic) {
            ResourceKey<Gene> resourceKey = ModGenes.INSTANCE.getBASIC();
            RegistryAccess registryAccess = ClientUtil.INSTANCE.getLocalRegistryAccess();
            Intrinsics.checkNotNull((Object)registryAccess);
            holder = (Holder)ModGenes.INSTANCE.getHolderOrThrow(resourceKey, (HolderLookup.Provider)registryAccess);
        } else {
            holder = this.geneHolder;
        }
        ItemStack helixStack = DnaHelixItem.Companion.getHelixStack(holder);
        ItemStack[] itemStackArray = new ItemStack[]{helixStack};
        EmiIngredient emiIngredient = EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])itemStackArray));
        Intrinsics.checkNotNullExpressionValue((Object)emiIngredient, (String)"of(...)");
        this.helix = emiIngredient;
        ItemStack plasmidStack = ModItems.INSTANCE.getPLASMID().toStack();
        Intrinsics.checkNotNull((Object)plasmidStack);
        PlasmidItem.Companion.setGene(plasmidStack, this.geneHolder, ((Gene)this.geneHolder.value()).getDnaPointsRequired());
        EmiStack emiStack = EmiStack.of((ItemStack)plasmidStack);
        Intrinsics.checkNotNullExpressionValue((Object)emiStack, (String)"of(...)");
        this.plasmid = emiStack;
        Object[] objectArray = new MutableComponent[3];
        Object[] objectArray2 = new Object[]{Gene.Companion.getNameComponent(this.geneHolder).withStyle(ChatFormatting.GRAY), ((Gene)this.geneHolder.value()).getDnaPointsRequired()};
        objectArray[0] = ModLanguageProvider.Companion.toComponent("recipe.geneticsresequenced.plasmid_infuser.points_required", objectArray2).withStyle(ChatFormatting.GRAY);
        objectArray[1] = ModLanguageProvider.Companion.toComponent("recipe.geneticsresequenced.plasmid_infuser.basic", new Object[0]).withStyle(ChatFormatting.GRAY);
        objectArray[2] = ModLanguageProvider.Companion.toComponent("recipe.geneticsresequenced.plasmid_infuser.matching", new Object[0]).withStyle(ChatFormatting.GRAY);
        this.tooltips = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final Holder<Gene> getGeneHolder() {
        return this.geneHolder;
    }

    public final boolean getBasic() {
        return this.basic;
    }

    @NotNull
    public EmiRecipeCategory getCategory() {
        return ModEmiPlugin.Companion.getPLASMID_INFUSER_CATEGORY();
    }

    @NotNull
    public ResourceLocation getId() {
        ResourceKey resourceKey = this.geneHolder.getKey();
        Intrinsics.checkNotNull((Object)resourceKey);
        String string = resourceKey.location().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String geneString = StringsKt.replace$default((String)string, (char)':', (char)'/', (boolean)false, (int)4, null);
        String basicString = this.basic ? "/basic" : "";
        return OtherUtil.INSTANCE.modResource("/plasmid_infuser/" + geneString + basicString);
    }

    @NotNull
    public List<EmiIngredient> getInputs() {
        return CollectionsKt.listOf((Object)this.helix);
    }

    @NotNull
    public List<EmiStack> getOutputs() {
        return CollectionsKt.listOf((Object)this.plasmid);
    }

    public int getDisplayWidth() {
        return 76;
    }

    public int getDisplayHeight() {
        return 18;
    }

    public void addWidgets(@NotNull WidgetHolder widgets) {
        Intrinsics.checkNotNullParameter((Object)widgets, (String)"widgets");
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 26, 1);
        widgets.addSlot(this.helix, 0, 0);
        widgets.addSlot((EmiIngredient)this.plasmid, 58, 0).recipeContext((EmiRecipe)this);
        widgets.addTooltipText(this.tooltips, 0, 0, 76, 18);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/compatibility/recipe/emi/recipe/machine/PlasmidInfuserEmiRecipe$Companion;", "", "<init>", "()V", "getAllRecipes", "", "Ldev/aaronhowser/mods/geneticsresequenced/compatibility/recipe/emi/recipe/machine/PlasmidInfuserEmiRecipe;", "geneticsresequenced-1.21.1"})
    @SourceDebugExtension(value={"SMAP\nPlasmidInfuserEmiRecipe.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlasmidInfuserEmiRecipe.kt\ndev/aaronhowser/mods/geneticsresequenced/compatibility/recipe/emi/recipe/machine/PlasmidInfuserEmiRecipe$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n1669#2,8:127\n*S KotlinDebug\n*F\n+ 1 PlasmidInfuserEmiRecipe.kt\ndev/aaronhowser/mods/geneticsresequenced/compatibility/recipe/emi/recipe/machine/PlasmidInfuserEmiRecipe$Companion\n*L\n42#1:127,8\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<PlasmidInfuserEmiRecipe> getAllRecipes() {
            List recipes = new ArrayList();
            RegistryAccess registryAccess = ClientUtil.INSTANCE.getLocalRegistryAccess();
            Intrinsics.checkNotNull((Object)registryAccess);
            for (Holder geneHolder : ModGenes.getRegistrySorted$default(ModGenes.INSTANCE, (HolderLookup.Provider)registryAccess, false, false, 4, null)) {
                recipes.add(new PlasmidInfuserEmiRecipe((Holder<Gene>)geneHolder, true));
                recipes.add(new PlasmidInfuserEmiRecipe((Holder<Gene>)geneHolder, false));
            }
            Iterable $this$distinctBy$iv = recipes;
            boolean $i$f$distinctBy = false;
            HashSet<ResourceLocation> set$iv = new HashSet<ResourceLocation>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                PlasmidInfuserEmiRecipe it = (PlasmidInfuserEmiRecipe)e$iv;
                boolean bl = false;
                ResourceLocation key$iv = it.getId();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            return list$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

