/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.compatibility.recipe.emi.recipe.machine;

import dev.aaronhowser.mods.aaron.client.AaronClientUtil;
import dev.aaronhowser.mods.geneticsresequenced.compatibility.recipe.emi.ModEmiPlugin;
import dev.aaronhowser.mods.geneticsresequenced.datagen.lang.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.item.PlasmidItem;
import dev.aaronhowser.mods.geneticsresequenced.item.SyringeItem;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import dev.aaronhowser.mods.geneticsresequenced.util.ClientUtil;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0017H\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u0017H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/compatibility/recipe/emi/recipe/machine/PlasmidInjectorEmiRecipe;", "Ldev/emi/emi/api/recipe/EmiRecipe;", "geneHolder", "Lnet/minecraft/core/Holder;", "Ldev/aaronhowser/mods/geneticsresequenced/gene/Gene;", "isMetal", "", "isAntiPlasmid", "<init>", "(Lnet/minecraft/core/Holder;ZZ)V", "getGeneHolder", "()Lnet/minecraft/core/Holder;", "()Z", "plasmid", "Ldev/emi/emi/api/stack/EmiIngredient;", "syringeBefore", "syringeAfter", "Ldev/emi/emi/api/stack/EmiStack;", "getCategory", "Ldev/emi/emi/api/recipe/EmiRecipeCategory;", "getId", "Lnet/minecraft/resources/ResourceLocation;", "getInputs", "", "getOutputs", "getDisplayWidth", "", "getDisplayHeight", "addWidgets", "", "widgets", "Ldev/emi/emi/api/widget/WidgetHolder;", "Companion", "geneticsresequenced-1.21.1"})
public final class PlasmidInjectorEmiRecipe
implements EmiRecipe {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Holder<Gene> geneHolder;
    private final boolean isMetal;
    private final boolean isAntiPlasmid;
    @NotNull
    private final EmiIngredient plasmid;
    @NotNull
    private final EmiIngredient syringeBefore;
    @NotNull
    private final EmiStack syringeAfter;

    public PlasmidInjectorEmiRecipe(@NotNull Holder<Gene> geneHolder, boolean isMetal, boolean isAntiPlasmid) {
        Intrinsics.checkNotNullParameter(geneHolder, (String)"geneHolder");
        this.geneHolder = geneHolder;
        this.isMetal = isMetal;
        this.isAntiPlasmid = isAntiPlasmid;
        ItemStack plasmidStack = this.isAntiPlasmid ? ModItems.INSTANCE.getANTI_PLASMID().toStack() : ModItems.INSTANCE.getPLASMID().toStack();
        Intrinsics.checkNotNull((Object)plasmidStack);
        PlasmidItem.Companion.setGene(plasmidStack, this.geneHolder, ((Gene)this.geneHolder.value()).getDnaPointsRequired());
        ItemStack[] itemStackArray = new ItemStack[]{plasmidStack};
        EmiIngredient emiIngredient = EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])itemStackArray));
        Intrinsics.checkNotNullExpressionValue((Object)emiIngredient, (String)"of(...)");
        this.plasmid = emiIngredient;
        ItemStack syringeStack = this.isMetal ? ModItems.INSTANCE.getMETAL_SYRINGE().toStack() : ModItems.INSTANCE.getSYRINGE().toStack();
        Player player = AaronClientUtil.getLocalPlayer();
        if (player == null) {
            throw new IllegalStateException("Local player is null");
        }
        Player localPlayer = player;
        LivingEntity entity = this.isMetal ? (LivingEntity)new Cow(EntityType.COW, localPlayer.level()) : (LivingEntity)localPlayer;
        Intrinsics.checkNotNull((Object)syringeStack);
        SyringeItem.Companion.setEntity(syringeStack, entity, false);
        ItemStack[] itemStackArray2 = new ItemStack[]{syringeStack};
        EmiIngredient emiIngredient2 = EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])itemStackArray2));
        Intrinsics.checkNotNullExpressionValue((Object)emiIngredient2, (String)"of(...)");
        this.syringeBefore = emiIngredient2;
        boolean bl = this.isAntiPlasmid ? SyringeItem.Companion.addAntigene(syringeStack, this.geneHolder) : SyringeItem.Companion.addGene(syringeStack, this.geneHolder);
        EmiStack emiStack = EmiStack.of((ItemStack)syringeStack);
        Intrinsics.checkNotNullExpressionValue((Object)emiStack, (String)"of(...)");
        this.syringeAfter = emiStack;
    }

    @NotNull
    public final Holder<Gene> getGeneHolder() {
        return this.geneHolder;
    }

    public final boolean isMetal() {
        return this.isMetal;
    }

    public final boolean isAntiPlasmid() {
        return this.isAntiPlasmid;
    }

    @NotNull
    public EmiRecipeCategory getCategory() {
        return ModEmiPlugin.Companion.getPLASMID_INJECTOR_CATEGORY();
    }

    @NotNull
    public ResourceLocation getId() {
        ResourceKey resourceKey = this.geneHolder.getKey();
        Intrinsics.checkNotNull((Object)resourceKey);
        String string = resourceKey.location().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String geneString = StringsKt.replace$default((String)string, (char)':', (char)'/', (boolean)false, (int)4, null);
        String syringeString = this.isMetal ? "/metal" : "";
        String plasmidString = this.isAntiPlasmid ? "/anti" : "";
        return OtherUtil.INSTANCE.modResource("/plasmid_injector/" + geneString + syringeString + plasmidString);
    }

    @NotNull
    public List<EmiIngredient> getInputs() {
        Object[] objectArray = new EmiIngredient[]{this.plasmid, this.syringeBefore};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public List<EmiStack> getOutputs() {
        return CollectionsKt.listOf((Object)this.syringeAfter);
    }

    public int getDisplayWidth() {
        return 102;
    }

    public int getDisplayHeight() {
        return 18;
    }

    public void addWidgets(@NotNull WidgetHolder widgets) {
        Intrinsics.checkNotNullParameter((Object)widgets, (String)"widgets");
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 48, 1);
        widgets.addSlot(this.plasmid, 0, 0);
        widgets.addSlot(this.syringeBefore, 24, 0);
        widgets.addSlot((EmiIngredient)this.syringeAfter, 78, 0).recipeContext((EmiRecipe)this);
        MutableComponent tooltipComponent = ModLanguageProvider.Companion.toComponent(this.isAntiPlasmid ? "recipe.geneticsresequenced.plasmid_injector.anti_genes" : "recipe.geneticsresequenced.plasmid_injector.genes", new Object[0]);
        widgets.addTooltipText(CollectionsKt.listOf((Object)tooltipComponent), 0, 0, this.getDisplayWidth(), this.getDisplayHeight());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/compatibility/recipe/emi/recipe/machine/PlasmidInjectorEmiRecipe$Companion;", "", "<init>", "()V", "getAllRecipes", "", "Ldev/aaronhowser/mods/geneticsresequenced/compatibility/recipe/emi/recipe/machine/PlasmidInjectorEmiRecipe;", "geneticsresequenced-1.21.1"})
    @SourceDebugExtension(value={"SMAP\nPlasmidInjectorEmiRecipe.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlasmidInjectorEmiRecipe.kt\ndev/aaronhowser/mods/geneticsresequenced/compatibility/recipe/emi/recipe/machine/PlasmidInjectorEmiRecipe$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n1669#2,8:130\n*S KotlinDebug\n*F\n+ 1 PlasmidInjectorEmiRecipe.kt\ndev/aaronhowser/mods/geneticsresequenced/compatibility/recipe/emi/recipe/machine/PlasmidInjectorEmiRecipe$Companion\n*L\n48#1:130,8\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<PlasmidInjectorEmiRecipe> getAllRecipes() {
            List addingGlass = new ArrayList();
            List addingMetal = new ArrayList();
            List removingGlass = new ArrayList();
            List removingMetal = new ArrayList();
            RegistryAccess registryAccess = ClientUtil.INSTANCE.getLocalRegistryAccess();
            Intrinsics.checkNotNull((Object)registryAccess);
            for (Holder geneHolder : ModGenes.getRegistrySorted$default(ModGenes.INSTANCE, (HolderLookup.Provider)registryAccess, false, false, 4, null)) {
                addingGlass.add(new PlasmidInjectorEmiRecipe((Holder<Gene>)geneHolder, false, false));
                addingMetal.add(new PlasmidInjectorEmiRecipe((Holder<Gene>)geneHolder, false, true));
                removingGlass.add(new PlasmidInjectorEmiRecipe((Holder<Gene>)geneHolder, true, false));
                removingMetal.add(new PlasmidInjectorEmiRecipe((Holder<Gene>)geneHolder, true, true));
            }
            Iterable $this$distinctBy$iv = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)addingGlass, (Iterable)addingMetal), (Iterable)removingGlass), (Iterable)removingMetal);
            boolean $i$f$distinctBy = false;
            HashSet<ResourceLocation> set$iv = new HashSet<ResourceLocation>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                PlasmidInjectorEmiRecipe it = (PlasmidInjectorEmiRecipe)e$iv;
                boolean bl = false;
                ResourceLocation key$iv = it.getId();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            return list$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

