/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.datagen.recipe_builder;

import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.recipe.incubator.GmoRecipe;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B;\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eB=\b\u0016\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u0011\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u0012J\u001c\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00152\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0016J\u0012\u0010\u001a\u001a\u00020\u00012\b\u0010\u001b\u001a\u0004\u0018\u00010\u0015H\u0016J\b\u0010\u001c\u001a\u00020\u0010H\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u0015\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/datagen/recipe_builder/GmoRecipeBuilder;", "Lnet/minecraft/data/recipes/RecipeBuilder;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "ingredient", "Lnet/minecraft/world/item/crafting/Ingredient;", "idealGeneRk", "Lnet/minecraft/resources/ResourceKey;", "Ldev/aaronhowser/mods/geneticsresequenced/gene/Gene;", "geneChance", "", "needsMutationPotion", "", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/item/crafting/Ingredient;Lnet/minecraft/resources/ResourceKey;FZ)V", "ingredientItem", "Lnet/minecraft/world/item/Item;", "isMutation", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/item/Item;Lnet/minecraft/resources/ResourceKey;FZ)V", "criteria", "", "", "Lnet/minecraft/advancements/Criterion;", "unlockedBy", "name", "criterion", "group", "p0", "getResult", "save", "", "output", "Lnet/minecraft/data/recipes/RecipeOutput;", "defaultId", "Lnet/minecraft/resources/ResourceLocation;", "geneticsresequenced-1.21.1"})
@SourceDebugExtension(value={"SMAP\nGmoRecipeBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GmoRecipeBuilder.kt\ndev/aaronhowser/mods/geneticsresequenced/datagen/recipe_builder/GmoRecipeBuilder\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,103:1\n216#2,2:104\n*S KotlinDebug\n*F\n+ 1 GmoRecipeBuilder.kt\ndev/aaronhowser/mods/geneticsresequenced/datagen/recipe_builder/GmoRecipeBuilder\n*L\n91#1:104,2\n*E\n"})
public final class GmoRecipeBuilder
implements RecipeBuilder {
    @NotNull
    private final EntityType<?> entityType;
    @NotNull
    private final Ingredient ingredient;
    @NotNull
    private final ResourceKey<Gene> idealGeneRk;
    private final float geneChance;
    private final boolean needsMutationPotion;
    @NotNull
    private final Map<String, Criterion<?>> criteria;

    public GmoRecipeBuilder(@NotNull EntityType<?> entityType, @NotNull Ingredient ingredient, @NotNull ResourceKey<Gene> idealGeneRk, float geneChance, boolean needsMutationPotion) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)ingredient, (String)"ingredient");
        Intrinsics.checkNotNullParameter(idealGeneRk, (String)"idealGeneRk");
        this.entityType = entityType;
        this.ingredient = ingredient;
        this.idealGeneRk = idealGeneRk;
        this.geneChance = geneChance;
        this.needsMutationPotion = needsMutationPotion;
        this.criteria = new LinkedHashMap();
    }

    public /* synthetic */ GmoRecipeBuilder(EntityType entityType, Ingredient ingredient, ResourceKey resourceKey, float f, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        this(entityType, ingredient, (ResourceKey<Gene>)resourceKey, f, bl);
    }

    public GmoRecipeBuilder(@NotNull EntityType<?> entityType, @NotNull Item ingredientItem, @NotNull ResourceKey<Gene> idealGeneRk, float geneChance, boolean isMutation) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)ingredientItem, (String)"ingredientItem");
        Intrinsics.checkNotNullParameter(idealGeneRk, (String)"idealGeneRk");
        ItemLike[] itemLikeArray = new ItemLike[]{ingredientItem};
        Ingredient ingredient = Ingredient.of((ItemLike[])itemLikeArray);
        Intrinsics.checkNotNullExpressionValue((Object)ingredient, (String)"of(...)");
        this(entityType, ingredient, idealGeneRk, geneChance, isMutation);
    }

    public /* synthetic */ GmoRecipeBuilder(EntityType entityType, Item item, ResourceKey resourceKey, float f, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        this(entityType, item, (ResourceKey<Gene>)resourceKey, f, bl);
    }

    @NotNull
    public RecipeBuilder unlockedBy(@NotNull String name, @NotNull Criterion<?> criterion) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(criterion, (String)"criterion");
        this.criteria.put(name, criterion);
        return this;
    }

    @NotNull
    public RecipeBuilder group(@Nullable String p0) {
        throw new IllegalStateException("Unsupported".toString());
    }

    @NotNull
    public Item getResult() {
        Object object = ModItems.INSTANCE.getGMO_CELL().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Item)object;
    }

    public void save(@NotNull RecipeOutput output, @NotNull ResourceLocation defaultId) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)defaultId, (String)"defaultId");
        String entityString = EntityType.getKey(this.entityType).getPath();
        String geneString = this.idealGeneRk.location().getPath();
        String chanceString = this.geneChance == 1.0f ? "100" : String.valueOf((int)(this.geneChance * (float)100));
        StringBuilder pathBuilder = new StringBuilder().append("incubator/").append("gmo/");
        if (this.needsMutationPotion) {
            pathBuilder.append("mutation/");
        }
        pathBuilder.append(geneString).append("_from_").append(entityString).append("_with_").append(chanceString).append("_chance");
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)defaultId.getNamespace(), (String)pathBuilder.toString());
        Advancement.Builder advancement = output.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
        Map<String, Criterion<?>> $this$forEach$iv = this.criteria;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Criterion<?>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Criterion<?>> element$iv;
            Map.Entry<String, Criterion<?>> entry2 = element$iv = iterator.next();
            boolean bl = false;
            String name = entry2.getKey();
            Criterion<?> criterion = entry2.getValue();
            advancement.addCriterion(name, criterion);
        }
        GmoRecipe recipe = new GmoRecipe(this.entityType, this.ingredient, this.idealGeneRk, this.geneChance, this.needsMutationPotion);
        output.accept(id, (Recipe)recipe, advancement.build(id.withPrefix("recipes/")));
    }
}

