/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.entity.goals;

import dev.aaronhowser.mods.geneticsresequenced.entity.SupportSlime;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u000bH\u0016J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0010H\u0002J\b\u0010\u0015\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/entity/goals/SupportSlimeAttackGoal;", "Lnet/minecraft/world/entity/ai/goal/Goal;", "mob", "Ldev/aaronhowser/mods/geneticsresequenced/entity/SupportSlime;", "<init>", "(Ldev/aaronhowser/mods/geneticsresequenced/entity/SupportSlime;)V", "ticksUntilNextAttack", "", "canUse", "", "start", "", "stop", "tick", "checkAndPerformAttack", "pEnemy", "Lnet/minecraft/world/entity/LivingEntity;", "pDistToEnemySqr", "", "getAttackReachSqr", "pAttackTarget", "resetAttackCooldown", "geneticsresequenced-1.21.1"})
public final class SupportSlimeAttackGoal
extends Goal {
    @NotNull
    private final SupportSlime mob;
    private int ticksUntilNextAttack;

    public SupportSlimeAttackGoal(@NotNull SupportSlime mob) {
        Intrinsics.checkNotNullParameter((Object)((Object)mob), (String)"mob");
        this.mob = mob;
    }

    public boolean canUse() {
        return true;
    }

    public void start() {
        LivingEntity target = this.mob.getTarget();
        if (target == null) {
            this.mob.setAggressive(false);
            return;
        }
        this.mob.setAggressive(true);
        this.mob.getNavigation().moveTo((Entity)target, 1.0);
        this.ticksUntilNextAttack = 0;
    }

    public void stop() {
        this.mob.setAggressive(false);
        this.mob.setTarget(null);
        this.mob.getNavigation().stop();
    }

    public void tick() {
        LivingEntity livingEntity = this.mob.getTarget();
        if (livingEntity == null) {
            return;
        }
        LivingEntity target = livingEntity;
        this.mob.getLookControl().setLookAt((Entity)target);
        double distanceSqr = this.mob.distanceToSqr((Entity)target);
        this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        this.checkAndPerformAttack(target, distanceSqr);
    }

    private final void checkAndPerformAttack(LivingEntity pEnemy, double pDistToEnemySqr) {
        double d0 = this.getAttackReachSqr(pEnemy);
        if (pDistToEnemySqr <= d0 && this.ticksUntilNextAttack <= 0) {
            this.resetAttackCooldown();
            this.mob.doHurtTarget((Entity)pEnemy);
        }
    }

    private final double getAttackReachSqr(LivingEntity pAttackTarget) {
        return this.mob.getBbWidth() * 2.0f * this.mob.getBbWidth() * 2.0f + pAttackTarget.getBbWidth();
    }

    private final void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.adjustedTickDelay(20);
    }
}

