/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.event;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.aaronhowser.mods.geneticsresequenced.control.ModKeyMappings;
import dev.aaronhowser.mods.geneticsresequenced.entity.client.SupportSlimeRenderer;
import dev.aaronhowser.mods.geneticsresequenced.gene.behavior.OtherGenes;
import dev.aaronhowser.mods.geneticsresequenced.gene.behavior.TickGenes;
import dev.aaronhowser.mods.geneticsresequenced.item.SyringeItem;
import dev.aaronhowser.mods.geneticsresequenced.menu.advanced_incubator.AdvancedIncubatorMenu;
import dev.aaronhowser.mods.geneticsresequenced.menu.coal_generator.CoalGeneratorMenu;
import dev.aaronhowser.mods.geneticsresequenced.menu.plasmid_infuser.PlasmidInfuserMenu;
import dev.aaronhowser.mods.geneticsresequenced.menu.plasmid_injector.PlasmidInjectorMenu;
import dev.aaronhowser.mods.geneticsresequenced.packet.client_to_server.FireballPacket;
import dev.aaronhowser.mods.geneticsresequenced.packet.client_to_server.TeleportPlayerPacket;
import dev.aaronhowser.mods.geneticsresequenced.recipe.BrewingRecipes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModEntityTypes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModMenuTypes;
import dev.aaronhowser.mods.geneticsresequenced.util.ClientUtil;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RenderLivingEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(value={Dist.CLIENT}, modid="geneticsresequenced")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0010H\u0007J\b\u0010\u0011\u001a\u00020\u0005H\u0002J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0015H\u0007J\"\u0010\u0016\u001a\u00020\u00052\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00190\u0017H\u0007J\"\u0010\u001a\u001a\u00020\u00052\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00190\u001bH\u0007\u00a8\u0006\u001c"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/event/ClientEvents;", "", "<init>", "()V", "onKeyInputEvent", "", "event", "Lnet/neoforged/neoforge/client/event/InputEvent$Key;", "tooltip", "Lnet/neoforged/neoforge/event/entity/player/ItemTooltipEvent;", "handleScreens", "onLeaveServer", "Lnet/neoforged/neoforge/client/event/ClientPlayerNetworkEvent$LoggingOut;", "onKeyRegister", "Lnet/neoforged/neoforge/client/event/RegisterKeyMappingsEvent;", "onClientSetup", "Lnet/neoforged/fml/event/lifecycle/FMLClientSetupEvent;", "registerEntityRenderers", "onModelRegistry", "Lnet/neoforged/neoforge/client/event/ModelEvent$RegisterAdditional;", "onRegisterMenuScreens", "Lnet/neoforged/neoforge/client/event/RegisterMenuScreensEvent;", "beforeRenderEntity", "Lnet/neoforged/neoforge/client/event/RenderLivingEvent$Pre;", "Lnet/minecraft/world/entity/LivingEntity;", "Lnet/minecraft/client/model/HumanoidModel;", "afterRenderLiving", "Lnet/neoforged/neoforge/client/event/RenderLivingEvent$Post;", "geneticsresequenced-1.21.1"})
public final class ClientEvents {
    @NotNull
    public static final ClientEvents INSTANCE = new ClientEvents();

    private ClientEvents() {
    }

    @SubscribeEvent
    public final void onKeyInputEvent(@NotNull InputEvent.Key event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (ModKeyMappings.INSTANCE.getTELEPORT().consumeClick()) {
            TeleportPlayerPacket.Companion.getINSTANCE().messageServer();
        }
        if (ModKeyMappings.INSTANCE.getDRAGONS_BREATH().consumeClick()) {
            FireballPacket.Companion.getINSTANCE().messageServer();
        }
    }

    @SubscribeEvent
    public final void tooltip(@NotNull ItemTooltipEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        BrewingRecipes.INSTANCE.tooltip(event);
        TickGenes.INSTANCE.itemMagnetBlacklistTooltip(event);
        this.handleScreens(event);
    }

    private final void handleScreens(ItemTooltipEvent event) {
        Player player = event.getEntity();
        if (player == null || (player = player.containerMenu) == null) {
            return;
        }
        Player screen = player;
        Player player2 = screen;
        if (player2 instanceof CoalGeneratorMenu) {
            CoalGeneratorMenu.Companion.showFuelTooltip(event);
        } else if (player2 instanceof PlasmidInfuserMenu) {
            PlasmidInfuserMenu.Companion.showTooltip(event);
        } else if (player2 instanceof PlasmidInjectorMenu) {
            PlasmidInjectorMenu.Companion.showTooltip(event);
        } else if (player2 instanceof AdvancedIncubatorMenu) {
            AdvancedIncubatorMenu.Companion.showChanceTooltip(event);
        }
    }

    @SubscribeEvent
    public final void onLeaveServer(@NotNull ClientPlayerNetworkEvent.LoggingOut event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ClientUtil.INSTANCE.addSkinLayersBack();
        ClientUtil.INSTANCE.handleCringe(false, 0);
    }

    @SubscribeEvent
    public final void onKeyRegister(@NotNull RegisterKeyMappingsEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.register(ModKeyMappings.INSTANCE.getDRAGONS_BREATH());
        event.register(ModKeyMappings.INSTANCE.getTELEPORT());
    }

    @SubscribeEvent
    public final void onClientSetup(@NotNull FMLClientSetupEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.registerEntityRenderers();
    }

    private final void registerEntityRenderers() {
        EntityRenderers.register((EntityType)((EntityType)ModEntityTypes.INSTANCE.getSUPPORT_SLIME().get()), SupportSlimeRenderer::new);
    }

    @SubscribeEvent
    public final void onModelRegistry(@NotNull ModelEvent.RegisterAdditional event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ItemProperties.register((Item)((Item)ModItems.INSTANCE.getSYRINGE().get()), (ResourceLocation)OtherUtil.INSTANCE.modResource("full"), ClientEvents::onModelRegistry$lambda$0);
        ItemProperties.register((Item)((Item)ModItems.INSTANCE.getSYRINGE().get()), (ResourceLocation)OtherUtil.INSTANCE.modResource("injecting"), ClientEvents::onModelRegistry$lambda$1);
        ItemProperties.register((Item)((Item)ModItems.INSTANCE.getMETAL_SYRINGE().get()), (ResourceLocation)OtherUtil.INSTANCE.modResource("full"), ClientEvents::onModelRegistry$lambda$2);
    }

    @SubscribeEvent
    public final void onRegisterMenuScreens(@NotNull RegisterMenuScreensEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ModMenuTypes.INSTANCE.registerScreens(event);
    }

    @SubscribeEvent
    public final void beforeRenderEntity(@NotNull RenderLivingEvent.Pre<LivingEntity, HumanoidModel<LivingEntity>> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        LivingEntity entity = event.getEntity();
        Intrinsics.checkNotNull((Object)entity);
        if (OtherGenes.INSTANCE.shouldClingToCeiling(entity)) {
            PoseStack poseStack = event.getPoseStack();
            poseStack.pushPose();
            poseStack.translate(0.0, (double)entity.getBbHeight(), 0.0);
            poseStack.scale(1.0f, -1.0f, 1.0f);
        }
    }

    @SubscribeEvent
    public final void afterRenderLiving(@NotNull RenderLivingEvent.Post<LivingEntity, HumanoidModel<LivingEntity>> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        LivingEntity livingEntity = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)livingEntity, (String)"getEntity(...)");
        if (OtherGenes.INSTANCE.shouldClingToCeiling(livingEntity)) {
            event.getPoseStack().popPose();
        }
    }

    private static final float onModelRegistry$lambda$0(ItemStack stack, ClientLevel clientLevel, LivingEntity livingEntity, int n) {
        Intrinsics.checkNotNull((Object)stack);
        return SyringeItem.Companion.hasBlood(stack) ? 1.0f : 0.0f;
    }

    private static final float onModelRegistry$lambda$1(ItemStack stack, ClientLevel clientLevel, LivingEntity entity, int n) {
        Intrinsics.checkNotNull((Object)stack);
        return SyringeItem.Companion.isBeingUsed(stack, entity) ? 1.0f : 0.0f;
    }

    private static final float onModelRegistry$lambda$2(ItemStack stack, ClientLevel clientLevel, LivingEntity livingEntity, int n) {
        Intrinsics.checkNotNull((Object)stack);
        return SyringeItem.Companion.hasBlood(stack) ? 1.0f : 0.0f;
    }
}

