/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.event.player;

import dev.aaronhowser.mods.geneticsresequenced.attachment.GenesData;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.gene.behavior.OtherGenes;
import dev.aaronhowser.mods.geneticsresequenced.gene.behavior.TickGenes;
import dev.aaronhowser.mods.geneticsresequenced.item.SyringeItem;
import dev.aaronhowser.mods.geneticsresequenced.packet.server_to_client.SetGenesPacket;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.ServerChatEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="geneticsresequenced")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0013H\u0007\u00a8\u0006\u0014"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/event/player/OtherPlayerEvents;", "", "<init>", "()V", "onPlayerTick", "", "event", "Lnet/neoforged/neoforge/event/tick/PlayerTickEvent$Pre;", "onPickUpItem", "Lnet/neoforged/neoforge/event/entity/player/ItemEntityPickupEvent$Post;", "onLogIn", "Lnet/neoforged/neoforge/event/entity/player/PlayerEvent$PlayerLoggedInEvent;", "onChangeDimension", "Lnet/neoforged/neoforge/event/entity/player/PlayerEvent$PlayerChangedDimensionEvent;", "onPlayerRespawn", "Lnet/neoforged/neoforge/event/entity/player/PlayerEvent$PlayerRespawnEvent;", "onSendChatMessage", "Lnet/neoforged/neoforge/event/ServerChatEvent;", "onStartTracking", "Lnet/neoforged/neoforge/event/entity/player/PlayerEvent$StartTracking;", "geneticsresequenced-1.21.1"})
public final class OtherPlayerEvents {
    @NotNull
    public static final OtherPlayerEvents INSTANCE = new OtherPlayerEvents();

    private OtherPlayerEvents() {
    }

    @SubscribeEvent
    public final void onPlayerTick(@NotNull PlayerTickEvent.Pre event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getEntity(...)");
        TickGenes.INSTANCE.handleNoHunger(player);
        Player player2 = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)player2, (String)"getEntity(...)");
        OtherGenes.INSTANCE.handleWallClimbing(player2);
        Player player3 = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)player3, (String)"getEntity(...)");
        TickGenes.INSTANCE.handleItemMagnet(player3);
        Player player4 = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)player4, (String)"getEntity(...)");
        TickGenes.INSTANCE.handleXpMagnet(player4);
    }

    @SubscribeEvent
    public final void onPickUpItem(@NotNull ItemEntityPickupEvent.Post event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ItemStack originalStack = event.getOriginalStack();
        Player player = event.getPlayer();
        Intrinsics.checkNotNull((Object)originalStack);
        if (SyringeItem.Companion.isSyringe(originalStack)) {
            Entity entity = event.getItemEntity().getOwner();
            LivingEntity thrower = entity instanceof LivingEntity ? (LivingEntity)entity : null;
            Level level = event.getPlayer().level();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
            player.hurt(SyringeItem.Companion.damageSourceStepOnSyringe(level, thrower), 1.0f);
            if (SyringeItem.Companion.isContaminated(originalStack)) {
                player.addEffect(new MobEffectInstance(MobEffects.POISON, 60));
            }
        }
    }

    @SubscribeEvent
    public final void onLogIn(@NotNull PlayerEvent.PlayerLoggedInEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getEntity(...)");
        GenesData.Companion.syncPlayer(player);
    }

    @SubscribeEvent
    public final void onChangeDimension(@NotNull PlayerEvent.PlayerChangedDimensionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getEntity(...)");
        GenesData.Companion.syncPlayer(player);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public final void onPlayerRespawn(@NotNull PlayerEvent.PlayerRespawnEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getEntity(...)");
        GenesData.Companion.syncPlayer(player);
    }

    @SubscribeEvent
    public final void onSendChatMessage(@NotNull ServerChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        OtherGenes.INSTANCE.handleEmeraldHeart(event);
        OtherGenes.INSTANCE.handleCringeChat(event);
        OtherGenes.INSTANCE.handleChatterbox(event);
        OtherGenes.INSTANCE.handleSlimyChat(event);
    }

    @SubscribeEvent
    public final void onStartTracking(@NotNull PlayerEvent.StartTracking event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getEntity();
        ServerPlayer serverPlayer = player instanceof ServerPlayer ? (ServerPlayer)player : null;
        if (serverPlayer == null) {
            return;
        }
        ServerPlayer player2 = serverPlayer;
        Entity entity = event.getTarget();
        LivingEntity livingEntity = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        if (livingEntity == null) {
            return;
        }
        LivingEntity entity2 = livingEntity;
        SetGenesPacket packet = new SetGenesPacket(entity2.getId(), (Collection<? extends Holder<Gene>>)GenesData.Companion.getGeneHolders(entity2));
        packet.messagePlayer(player2);
    }
}

