/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.gene;

import dev.aaronhowser.mods.aaron.scheduler.SchedulerExtensions;
import dev.aaronhowser.mods.geneticsresequenced.GeneticsResequenced;
import dev.aaronhowser.mods.geneticsresequenced.config.ServerConfig;
import dev.aaronhowser.mods.geneticsresequenced.datagen.lang.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableSet;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 +2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001+B'\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0002H\u0016J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0002H\u0016J\b\u0010\u001e\u001a\u00020\u0011H\u0016J\b\u0010\u001f\u001a\u00020\tH\u0016J\u000f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020!H\u0096\u0002J\u0016\u0010\"\u001a\u00020\t2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00020$H\u0016J\u0016\u0010%\u001a\u00020\t2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00020$H\u0016J\u0016\u0010&\u001a\u00020\t2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00020$H\u0016J\u0011\u0010'\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0002H\u0096\u0002J\u0016\u0010(\u001a\u00020\t2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00020$H\u0016J\b\u0010)\u001a\u00020*H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u001b\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006,"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/gene/GeneCooldown;", "", "Ljava/util/UUID;", "gene", "Lnet/minecraft/resources/ResourceKey;", "Ldev/aaronhowser/mods/geneticsresequenced/gene/Gene;", "cooldownTicks", "", "notifyPlayer", "", "<init>", "(Lnet/minecraft/resources/ResourceKey;IZ)V", "uuidsOnCooldown", "actuallyNotify", "addedViaEntity", "cooldownEndedTasks", "Lkotlin/Function0;", "", "getCooldownEndedTasks", "()Ljava/util/Set;", "add", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "onAddSucceed", "onAddFail", "remove", "element", "size", "getSize", "()I", "clear", "isEmpty", "iterator", "", "retainAll", "elements", "", "removeAll", "containsAll", "contains", "addAll", "toString", "", "Companion", "geneticsresequenced-1.21.1"})
public final class GeneCooldown
implements Set<UUID>,
KMutableSet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourceKey<Gene> gene;
    private final int cooldownTicks;
    @NotNull
    private final Set<UUID> uuidsOnCooldown;
    private final boolean actuallyNotify;
    private boolean addedViaEntity;
    @NotNull
    private final Set<Function0<Unit>> cooldownEndedTasks;
    private final int size;

    public GeneCooldown(@NotNull ResourceKey<Gene> gene, int cooldownTicks, boolean notifyPlayer) {
        Intrinsics.checkNotNullParameter(gene, (String)"gene");
        this.gene = gene;
        this.cooldownTicks = cooldownTicks;
        this.uuidsOnCooldown = new LinkedHashSet();
        this.actuallyNotify = notifyPlayer && this.cooldownTicks >= ((Number)ServerConfig.Companion.getCONFIG().getMinimumCooldownForNotification().get()).intValue();
        this.cooldownEndedTasks = new LinkedHashSet();
        this.size = this.uuidsOnCooldown.size();
    }

    public /* synthetic */ GeneCooldown(ResourceKey resourceKey, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            bl = true;
        }
        this((ResourceKey<Gene>)resourceKey, n, bl);
    }

    @NotNull
    public final Set<Function0<Unit>> getCooldownEndedTasks() {
        return this.cooldownEndedTasks;
    }

    @Override
    public final boolean add(@NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.addedViaEntity = true;
        UUID uUID = entity.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        boolean success = this.add(uUID);
        if (success) {
            this.onAddSucceed(entity);
        } else {
            this.onAddFail(entity);
        }
        return success;
    }

    private final void onAddSucceed(LivingEntity entity) {
        if (this.actuallyNotify) {
            Companion.tellCooldownStarted(entity, this.gene, this.cooldownTicks);
        }
        Level level = entity.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        SchedulerExtensions.INSTANCE.scheduleTaskInTicks(level, this.cooldownTicks, () -> GeneCooldown.onAddSucceed$lambda$0(this, entity));
    }

    private final void onAddFail(LivingEntity entity) {
        if (this.actuallyNotify) {
            Companion.tellOnCooldown(entity, this.gene);
        }
    }

    public final boolean remove(@NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (this.contains((Object)entity.getUUID()) && this.actuallyNotify) {
            Companion.tellCooldownEnded(entity, this.gene);
        }
        return this.remove((Object)entity.getUUID());
    }

    @Override
    public boolean add(@NotNull UUID element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!this.addedViaEntity) {
            throw new UnsupportedOperationException("Cannot add UUIDs directly to GeneCooldown");
        }
        if (this.uuidsOnCooldown.contains(element)) {
            return false;
        }
        return this.uuidsOnCooldown.add(element);
    }

    public boolean remove(@NotNull UUID element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!((Collection)this.cooldownEndedTasks).isEmpty()) {
            for (Function0<Unit> task : this.cooldownEndedTasks) {
                task.invoke();
            }
            GeneticsResequenced.Companion.getLOGGER().debug(this + " ran " + this.cooldownEndedTasks.size() + " tasks as it ended");
        }
        this.cooldownEndedTasks.clear();
        return this.uuidsOnCooldown.remove(element);
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public void clear() {
        this.uuidsOnCooldown.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.uuidsOnCooldown.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<UUID> iterator() {
        return this.uuidsOnCooldown.iterator();
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.uuidsOnCooldown.retainAll(CollectionsKt.toSet((Iterable)elements));
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.uuidsOnCooldown.removeAll(CollectionsKt.toSet((Iterable)elements));
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.uuidsOnCooldown.containsAll(elements);
    }

    public boolean contains(@NotNull UUID element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.uuidsOnCooldown.contains(element);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends UUID> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.uuidsOnCooldown.addAll(elements);
    }

    @NotNull
    public String toString() {
        return "GeneCooldown(" + this.gene + ")";
    }

    private static final void onAddSucceed$lambda$0(GeneCooldown this$0, LivingEntity $entity) {
        this$0.remove($entity);
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u001c\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a8\u0006\u000f"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/gene/GeneCooldown$Companion;", "", "<init>", "()V", "tellCooldownStarted", "", "player", "Lnet/minecraft/world/entity/LivingEntity;", "geneRk", "Lnet/minecraft/resources/ResourceKey;", "Ldev/aaronhowser/mods/geneticsresequenced/gene/Gene;", "cooldownTicks", "", "tellCooldownEnded", "tellOnCooldown", "geneticsresequenced-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        public final void tellCooldownStarted(@NotNull LivingEntity player, @NotNull ResourceKey<Gene> geneRk, int cooldownTicks) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter(geneRk, (String)"geneRk");
            int cooldownSeconds = cooldownTicks / 20;
            String cooldownString = null;
            if (cooldownSeconds > 60) {
                int minutes = cooldownSeconds / 60;
                int seconds = cooldownSeconds % 60;
                cooldownString = minutes + " minutes and " + seconds + " seconds";
            } else {
                cooldownString = cooldownSeconds + " seconds";
            }
            RegistryAccess registryAccess = player.registryAccess();
            Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
            HolderLookup.Provider provider = (HolderLookup.Provider)registryAccess;
            ResourceLocation resourceLocation = geneRk.location();
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"location(...)");
            Holder.Reference<Gene> reference = ModGenes.fromResourceLocation(provider, resourceLocation);
            Intrinsics.checkNotNull(reference);
            Holder.Reference<Gene> geneHolder = reference;
            Object[] objectArray = new Object[]{cooldownString};
            MutableComponent message = Component.empty().append((Component)Gene.Companion.getName((Holder<Gene>)((Holder)geneHolder))).append((Component)ModLanguageProvider.Companion.toComponent("cooldown.geneticsresequenced.started", objectArray));
            player.sendSystemMessage((Component)message);
        }

        public final void tellCooldownEnded(@NotNull LivingEntity player, @NotNull ResourceKey<Gene> geneRk) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter(geneRk, (String)"geneRk");
            RegistryAccess registryAccess = player.registryAccess();
            Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
            HolderLookup.Provider provider = (HolderLookup.Provider)registryAccess;
            ResourceLocation resourceLocation = geneRk.location();
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"location(...)");
            Holder.Reference<Gene> reference = ModGenes.fromResourceLocation(provider, resourceLocation);
            Intrinsics.checkNotNull(reference);
            Holder.Reference<Gene> geneHolder = reference;
            Object[] objectArray = new Object[]{Gene.Companion.getName((Holder<Gene>)((Holder)geneHolder))};
            MutableComponent message = ModLanguageProvider.Companion.toComponent("cooldown.geneticsresequenced.ended", objectArray);
            player.sendSystemMessage((Component)message);
        }

        public final void tellOnCooldown(@NotNull LivingEntity player, @NotNull ResourceKey<Gene> geneRk) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter(geneRk, (String)"geneRk");
            RegistryAccess registryAccess = player.registryAccess();
            Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
            HolderLookup.Provider provider = (HolderLookup.Provider)registryAccess;
            ResourceLocation resourceLocation = geneRk.location();
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"location(...)");
            Holder.Reference<Gene> reference = ModGenes.fromResourceLocation(provider, resourceLocation);
            Intrinsics.checkNotNull(reference);
            Holder.Reference<Gene> geneHolder = reference;
            Object[] objectArray = new Object[]{Gene.Companion.getName((Holder<Gene>)((Holder)geneHolder))};
            MutableComponent message = ModLanguageProvider.Companion.toComponent("cooldown.geneticsresequenced.on_cooldown", objectArray);
            player.sendSystemMessage((Component)message);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

