/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.gene.behavior;

import dev.aaronhowser.mods.aaron.AaronExtensions;
import dev.aaronhowser.mods.aaron.client.AaronClientUtil;
import dev.aaronhowser.mods.aaron.scheduler.SchedulerExtensions;
import dev.aaronhowser.mods.geneticsresequenced.attachment.GenesData;
import dev.aaronhowser.mods.geneticsresequenced.config.ServerConfig;
import dev.aaronhowser.mods.geneticsresequenced.datagen.lang.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.entity.SupportSlime;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.packet.server_to_client.NarratorPacket;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.ServerChatEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eJ\u000e\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0019H\u0007J\u0018\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0007R\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/gene/behavior/OtherGenes;", "", "<init>", "()V", "VILLAGER_SOUNDS", "", "Lnet/minecraft/sounds/SoundEvent;", "kotlin.jvm.PlatformType", "handleEmeraldHeart", "", "event", "Lnet/neoforged/neoforge/event/ServerChatEvent;", "handleChatterbox", "RANDOM_CRINGE_PHRASES", "", "uwufyString", "pInput", "handleCringeChat", "handleSlimyChat", "handleWallClimbing", "player", "Lnet/minecraft/world/entity/player/Player;", "shouldClingToCeiling", "", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "shouldMobGlowFromMobSight", "entityToGlow", "shouldNegateSlownessFromBlock", "livingEntity", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "geneticsresequenced-1.21.1"})
@SourceDebugExtension(value={"SMAP\nOtherGenes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OtherGenes.kt\ndev/aaronhowser/mods/geneticsresequenced/gene/behavior/OtherGenes\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,261:1\n774#2:262\n865#2,2:263\n1869#2,2:265\n*S KotlinDebug\n*F\n+ 1 OtherGenes.kt\ndev/aaronhowser/mods/geneticsresequenced/gene/behavior/OtherGenes\n*L\n142#1:262\n142#1:263,2\n160#1:265,2\n*E\n"})
public final class OtherGenes {
    @NotNull
    public static final OtherGenes INSTANCE = new OtherGenes();
    @NotNull
    private static final List<SoundEvent> VILLAGER_SOUNDS;
    @NotNull
    private static final List<String> RANDOM_CRINGE_PHRASES;

    private OtherGenes() {
    }

    public final void handleEmeraldHeart(@NotNull ServerChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        RegistryAccess registryAccess = event.getPlayer().registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        Holder.Reference<Gene> emeraldHeart2 = ModGenes.INSTANCE.getHolderOrThrow(ModGenes.EMERALD_HEART, (HolderLookup.Provider)registryAccess);
        if (Gene.Companion.isDisabled((Holder<Gene>)((Holder)emeraldHeart2))) {
            return;
        }
        if (Random.Default.nextDouble() > ((Number)ServerConfig.Companion.getCONFIG().getEmeraldHeartChatChance().get()).doubleValue()) {
            return;
        }
        ServerPlayer player = event.getPlayer();
        Intrinsics.checkNotNull((Object)player);
        if (GenesData.Companion.hasGene((Entity)player, ModGenes.EMERALD_HEART)) {
            player.level().playSound(null, player.blockPosition(), (SoundEvent)CollectionsKt.random((Collection)VILLAGER_SOUNDS, (Random)((Random)Random.Default)), player.getSoundSource(), 1.0f, 1.0f);
        }
    }

    public final void handleChatterbox(@NotNull ServerChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        RegistryAccess registryAccess = event.getPlayer().registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        Holder.Reference<Gene> chatterBox = ModGenes.INSTANCE.getHolderOrThrow(ModGenes.CHATTERBOX, (HolderLookup.Provider)registryAccess);
        if (Gene.Companion.isDisabled((Holder<Gene>)((Holder)chatterBox))) {
            return;
        }
        ServerPlayer player = event.getPlayer();
        Intrinsics.checkNotNull((Object)player);
        if (!GenesData.Companion.hasGene((Entity)player, ModGenes.CHATTERBOX)) {
            return;
        }
        Component message = event.getMessage();
        String string = message.getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        NarratorPacket packet = new NarratorPacket(string);
        ServerLevel serverLevel = player.serverLevel();
        Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"serverLevel(...)");
        Vec3 vec3 = player.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        packet.messageNearbyPlayers(serverLevel, vec3, 64.0);
    }

    @NotNull
    public final String uwufyString(@NotNull String pInput) {
        String string;
        Intrinsics.checkNotNullParameter((Object)pInput, (String)"pInput");
        String input = pInput;
        int stringLength = input.length();
        CharSequence charSequence = input;
        Regex regex = new Regex("[rl]");
        String string2 = "w";
        charSequence = regex.replace(charSequence, string2);
        regex = new Regex("[RL]");
        string2 = "W";
        input = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)regex.replace(charSequence, string2), (String)"ove", (String)"uv", (boolean)false, (int)4, null), (String)"o", (String)"owo", (boolean)false, (int)4, null), (String)"O", (String)"OwO", (boolean)false, (int)4, null), (String)"!", (String)"!!!", (boolean)false, (int)4, null), (String)"?", (String)"???", (boolean)false, (int)4, null);
        if (stringLength % 3 == 0) {
            String string3 = input.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
            input = string3;
        }
        if (stringLength % 2 == 0) {
            charSequence = input;
            regex = new Regex("([a-zA-Z])(\\b)");
            string2 = "$1$1$1$1$2";
            string = regex.replace(charSequence, string2);
        } else {
            charSequence = input;
            regex = new Regex("\\b([a-zA-Z])([a-zA-Z]*)\\b");
            string2 = "$1-$1$2";
            string = regex.replace(charSequence, string2);
        }
        input = string;
        String tildes = StringsKt.repeat((CharSequence)"~", (int)Random.Default.nextInt(0, 4));
        return input + tildes + " " + CollectionsKt.random((Collection)RANDOM_CRINGE_PHRASES, (Random)((Random)Random.Default));
    }

    public final void handleCringeChat(@NotNull ServerChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        RegistryAccess registryAccess = event.getPlayer().registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        Holder.Reference<Gene> cringe2 = ModGenes.INSTANCE.getHolderOrThrow(ModGenes.CRINGE, (HolderLookup.Provider)registryAccess);
        if (Gene.Companion.isDisabled((Holder<Gene>)((Holder)cringe2))) {
            return;
        }
        ServerPlayer player = event.getPlayer();
        Intrinsics.checkNotNull((Object)player);
        if (!GenesData.Companion.hasGene((Entity)player, ModGenes.CRINGE)) {
            return;
        }
        String input = event.getMessage().getString();
        Intrinsics.checkNotNull((Object)input);
        event.setMessage((Component)Component.literal((String)this.uwufyString(input)));
    }

    /*
     * WARNING - void declaration
     */
    public final void handleSlimyChat(@NotNull ServerChatEvent event) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ServerPlayer player = event.getPlayer();
        RegistryAccess registryAccess = player.registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        Holder.Reference<Gene> slimyDeath2 = ModGenes.INSTANCE.getHolderOrThrow(ModGenes.SLIMY_DEATH, (HolderLookup.Provider)registryAccess);
        if (Gene.Companion.isDisabled((Holder<Gene>)((Holder)slimyDeath2))) {
            return;
        }
        Intrinsics.checkNotNull((Object)player);
        if (!GenesData.Companion.hasGene((Entity)player, ModGenes.SLIMY_DEATH)) {
            return;
        }
        List list = player.level().getEntities((Entity)player, player.getBoundingBox().inflate(64.0));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntities(...)");
        Iterable iterable = list;
        boolean $i$f$filter = false;
        void var7_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Entity it = (Entity)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof SupportSlime && Intrinsics.areEqual((Object)((SupportSlime)it).getOwnerUuid(), (Object)player.getUUID()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List nearbySupportSlimes = (List)destination$iv$iv;
        int amountSlimes = nearbySupportSlimes.size();
        List allPlayers = player.server.getPlayerList().getPlayers();
        for (int i = 0; i < amountSlimes; ++i) {
            Object[] objectArray = new Object[]{player.getDisplayName(), i + 1};
            MutableComponent message = Component.literal((String)"<").append((Component)ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.slimy_spam", objectArray)).append((Component)Component.literal((String)"> ")).append(event.getMessage());
            Level level = player.level();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
            SchedulerExtensions.INSTANCE.scheduleTaskInTicks(level, i + 1, () -> OtherGenes.handleSlimyChat$lambda$2(allPlayers, message));
        }
    }

    public final void handleWallClimbing(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        RegistryAccess registryAccess = player.registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        Holder.Reference<Gene> wallClimbing = ModGenes.INSTANCE.getHolderOrThrow(ModGenes.WALL_CLIMBING, (HolderLookup.Provider)registryAccess);
        if (Gene.Companion.isDisabled((Holder<Gene>)((Holder)wallClimbing)) || !GenesData.Companion.hasGene((Entity)player, ModGenes.WALL_CLIMBING)) {
            return;
        }
        if (player.horizontalCollision || player.minorHorizontalCollision) {
            double d = player.getDeltaMovement().x;
            Double d2 = player.isCrouching() ? Double.valueOf(0.0) : (Double)ServerConfig.Companion.getCONFIG().getWallClimbSpeed().get();
            Intrinsics.checkNotNull((Object)d2);
            player.setDeltaMovement(d, ((Number)d2).doubleValue(), player.getDeltaMovement().z);
            player.fallDistance = 0.0f;
        }
        if (this.shouldClingToCeiling((LivingEntity)player)) {
            int moveTries;
            double d = player.getDeltaMovement().x;
            Object object = ServerConfig.Companion.getCONFIG().getWallClimbSpeed().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            player.setDeltaMovement(d, ((Number)object).doubleValue(), player.getDeltaMovement().z);
            player.setPose(Pose.SWIMMING);
            player.refreshDimensions();
            Vec3 startPos = player.position();
            for (moveTries = 0; !this.shouldClingToCeiling((LivingEntity)player) && moveTries < 100; ++moveTries) {
                player.setPos(player.getX(), player.getY() + 0.01, player.getZ());
            }
            if (moveTries >= 100) {
                player.setPos(startPos.x, startPos.y, startPos.z);
            }
            player.fallDistance = 0.0f;
        }
    }

    public final boolean shouldClingToCeiling(@NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (!entity.isShiftKeyDown()) {
            return false;
        }
        RegistryAccess registryAccess = entity.registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        Holder.Reference<Gene> wallClimbing = ModGenes.INSTANCE.getHolderOrThrow(ModGenes.WALL_CLIMBING, (HolderLookup.Provider)registryAccess);
        if (Gene.Companion.isDisabled((Holder<Gene>)((Holder)wallClimbing)) || !GenesData.Companion.hasGene((Entity)entity, ModGenes.WALL_CLIMBING)) {
            return false;
        }
        AABB entityAabb = entity.getBoundingBox();
        AABB aboveAabb = new AABB(entityAabb.minX, entityAabb.maxY - 0.1, entityAabb.minZ, entityAabb.maxX, entityAabb.maxY + 0.5, entityAabb.maxZ);
        Level level = entity.level();
        Stream positions = BlockPos.betweenClosedStream((AABB)aboveAabb);
        return positions.anyMatch(arg_0 -> OtherGenes.shouldClingToCeiling$lambda$4(arg_0 -> OtherGenes.shouldClingToCeiling$lambda$3(level, arg_0), arg_0));
    }

    @JvmStatic
    public static final boolean shouldMobGlowFromMobSight(@NotNull LivingEntity entityToGlow) {
        Intrinsics.checkNotNullParameter((Object)entityToGlow, (String)"entityToGlow");
        Level level = entityToGlow.level();
        Intrinsics.checkNotNull((Object)level);
        if (AaronExtensions.INSTANCE.isServerSide(level)) {
            return false;
        }
        RegistryAccess registryAccess = entityToGlow.registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        Holder.Reference<Gene> mobSight2 = ModGenes.INSTANCE.getHolderOrThrow(ModGenes.MOB_SIGHT, (HolderLookup.Provider)registryAccess);
        if (Gene.Companion.isDisabled((Holder<Gene>)((Holder)mobSight2))) {
            return false;
        }
        Player player = AaronClientUtil.getLocalPlayer();
        if (player == null) {
            return false;
        }
        Player localPlayer = player;
        if (!GenesData.Companion.hasGene((Entity)localPlayer, ModGenes.MOB_SIGHT)) {
            return false;
        }
        Vec3 vec3 = entityToGlow.position();
        Position position = (Position)localPlayer.position();
        Object object = ServerConfig.Companion.getCONFIG().getMobSightRadius().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return vec3.closerThan(position, ((Number)object).doubleValue());
    }

    @JvmStatic
    public static final boolean shouldNegateSlownessFromBlock(@NotNull LivingEntity livingEntity, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (state.is(Blocks.COBWEB)) {
            RegistryAccess registryAccess = livingEntity.registryAccess();
            Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
            Holder.Reference<Gene> webWalker = ModGenes.INSTANCE.getHolderOrThrow(ModGenes.WEB_WALKER, (HolderLookup.Provider)registryAccess);
            if (Gene.Companion.isDisabled((Holder<Gene>)((Holder)webWalker))) {
                return false;
            }
            if (GenesData.Companion.hasGene((Entity)livingEntity, ModGenes.WEB_WALKER)) {
                return true;
            }
        }
        return false;
    }

    private static final void handleSlimyChat$lambda$2(List $allPlayers, MutableComponent $message) {
        Intrinsics.checkNotNull((Object)$allPlayers);
        Iterable $this$forEach$iv = $allPlayers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerPlayer it = (ServerPlayer)element$iv;
            boolean bl = false;
            it.sendSystemMessage((Component)$message);
        }
    }

    private static final boolean shouldClingToCeiling$lambda$3(Level $level, BlockPos it) {
        return !$level.getBlockState(it).getCollisionShape((BlockGetter)$level, it).isEmpty();
    }

    private static final boolean shouldClingToCeiling$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Object[] objectArray = new SoundEvent[]{SoundEvents.VILLAGER_TRADE, SoundEvents.VILLAGER_AMBIENT, SoundEvents.VILLAGER_CELEBRATE};
        VILLAGER_SOUNDS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"UwU", "owo", "OwO", "uwu", ">w<", "^w^", ":3", "^-^", "^_^", "^w^", ":3"};
        RANDOM_CRINGE_PHRASES = CollectionsKt.listOf((Object[])objectArray);
    }
}

