/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.gene.behavior;

import dev.aaronhowser.mods.aaron.AaronExtensions;
import dev.aaronhowser.mods.geneticsresequenced.attachment.GenesData;
import dev.aaronhowser.mods.geneticsresequenced.config.ServerConfig;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.gene.GeneCooldown;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.DragonFireball;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/gene/behavior/PacketGenes;", "", "<init>", "()V", "RECENT_TELEPORTS", "Ldev/aaronhowser/mods/geneticsresequenced/gene/GeneCooldown;", "teleport", "", "player", "Lnet/minecraft/server/level/ServerPlayer;", "RECENT_DRAGONS_BREATHS", "dragonBreath", "geneticsresequenced-1.21.1"})
public final class PacketGenes {
    @NotNull
    public static final PacketGenes INSTANCE = new PacketGenes();
    @NotNull
    private static final GeneCooldown RECENT_TELEPORTS;
    @NotNull
    private static final GeneCooldown RECENT_DRAGONS_BREATHS;

    private PacketGenes() {
    }

    public final void teleport(@NotNull ServerPlayer player) {
        Vec3 vec3;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        RegistryAccess registryAccess = player.registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        Holder.Reference<Gene> teleport2 = ModGenes.INSTANCE.getHolderOrThrow(ModGenes.TELEPORT, (HolderLookup.Provider)registryAccess);
        if (Gene.Companion.isDisabled((Holder<Gene>)((Holder)teleport2))) {
            return;
        }
        if (!GenesData.Companion.hasGene((Entity)player, ModGenes.TELEPORT)) {
            return;
        }
        boolean wasNotOnCooldown = RECENT_TELEPORTS.add((LivingEntity)player);
        if (!wasNotOnCooldown) {
            return;
        }
        Vec3 vec32 = player.getLookAngle().normalize();
        Object object = ServerConfig.Companion.getCONFIG().getTeleportDistance().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Vec3 teleportDestination = vec32.scale(((Number)object).doubleValue());
        BlockHitResult blockHitResult = player.level().clip(new ClipContext(player.getEyePosition(), player.getEyePosition().add(teleportDestination), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        Intrinsics.checkNotNullExpressionValue((Object)blockHitResult, (String)"clip(...)");
        BlockHitResult lookingAtBlock = blockHitResult;
        if (lookingAtBlock.getType() == HitResult.Type.MISS) {
            vec3 = player.getEyePosition().add(teleportDestination);
        } else {
            Direction sideHit;
            Vec3 blockLocation = lookingAtBlock.getLocation();
            Direction direction = sideHit = lookingAtBlock.getDirection();
            Vec3 offset = switch (direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
                case 1 -> new Vec3(0.0, -2.0, 0.0);
                case 2 -> new Vec3(0.0, 0.5, 0.0);
                default -> {
                    Vec3i v7 = sideHit.getNormal();
                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"getNormal(...)");
                    yield AaronExtensions.INSTANCE.toVec3(v7);
                }
            };
            vec3 = blockLocation.add(offset);
        }
        Vec3 destination = vec3;
        BlockState blockAtNewFootLocation = player.level().getBlockState(BlockPos.containing((Position)((Position)destination)).below());
        boolean footBlockIsSolid = blockAtNewFootLocation.entityCanStandOn((BlockGetter)player.level(), BlockPos.containing((Position)((Position)destination)), (Entity)player);
        if (footBlockIsSolid) {
            destination = destination.add(0.0, 1.0, 0.0);
        }
        player.teleportTo(destination.x, destination.y, destination.z);
    }

    public final void dragonBreath(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        RegistryAccess registryAccess = player.registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        Holder.Reference<Gene> dragonBreath = ModGenes.INSTANCE.getHolderOrThrow(ModGenes.DRAGON_BREATH, (HolderLookup.Provider)registryAccess);
        if (Gene.Companion.isDisabled((Holder<Gene>)((Holder)dragonBreath))) {
            return;
        }
        if (!GenesData.Companion.hasGene((Entity)player, ModGenes.DRAGON_BREATH)) {
            return;
        }
        boolean wasNotOnCooldown = RECENT_DRAGONS_BREATHS.add((LivingEntity)player);
        if (!wasNotOnCooldown) {
            return;
        }
        DragonFireball entityDragonFireball = new DragonFireball(player.level(), (LivingEntity)player, player.getLookAngle());
        entityDragonFireball.setPos(player.getEyePosition());
        player.level().addFreshEntity((Entity)entityDragonFireball);
    }

    static {
        Object object = ServerConfig.Companion.getCONFIG().getTeleportCooldown().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        RECENT_TELEPORTS = new GeneCooldown(ModGenes.TELEPORT, ((Number)object).intValue(), false, 4, null);
        Object object2 = ServerConfig.Companion.getCONFIG().getDragonsBreathCooldown().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        RECENT_DRAGONS_BREATHS = new GeneCooldown(ModGenes.DRAGON_BREATH, ((Number)object2).intValue(), false, 4, null);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.DOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.UP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

