/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.item;

import dev.aaronhowser.mods.aaron.AaronExtensions;
import dev.aaronhowser.mods.geneticsresequenced.attachment.GenesData;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModDataComponents;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000bH\u0016\u00a8\u0006\u0014"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/item/DragonHealthCrystal;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "getBreakingSound", "Lnet/minecraft/sounds/SoundEvent;", "isDamageable", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "isBarVisible", "getMaxDamage", "", "getDamage", "isValidRepairItem", "pStack", "pRepairCandidate", "Companion", "geneticsresequenced-1.21.1"})
public final class DragonHealthCrystal
extends Item {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Function0<Item.Properties> DEFAULT_PROPERTIES = DragonHealthCrystal::DEFAULT_PROPERTIES$lambda$0;
    public static final float MAX_DAMAGE = 1000.0f;

    public DragonHealthCrystal(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @NotNull
    public SoundEvent getBreakingSound() {
        SoundEvent soundEvent = SoundEvents.ENDER_DRAGON_HURT;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"ENDER_DRAGON_HURT");
        return soundEvent;
    }

    public boolean isDamageable(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return true;
    }

    public boolean isBarVisible(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return this.getDamage(stack) < this.getMaxDamage(stack);
    }

    public int getMaxDamage(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return Mth.ceil((float)1000.0f);
    }

    public int getDamage(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Float damageRemaining = (Float)stack.getOrDefault((Supplier)ModDataComponents.INSTANCE.getDRAGON_HEALTH_CRYSTAL_DAMAGE(), (Object)Float.valueOf(0.0f));
        Intrinsics.checkNotNull((Object)damageRemaining);
        return Mth.ceil((float)(1000.0f - damageRemaining.floatValue()));
    }

    public boolean isValidRepairItem(@NotNull ItemStack pStack, @NotNull ItemStack pRepairCandidate) {
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        Intrinsics.checkNotNullParameter((Object)pRepairCandidate, (String)"pRepairCandidate");
        return pRepairCandidate.getItem() == Items.END_CRYSTAL;
    }

    private static final Item.Properties DEFAULT_PROPERTIES$lambda$0() {
        return new Item.Properties().component((Supplier)ModDataComponents.INSTANCE.getDRAGON_HEALTH_CRYSTAL_DAMAGE(), (Object)Float.valueOf(1000.0f));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/item/DragonHealthCrystal$Companion;", "", "<init>", "()V", "DEFAULT_PROPERTIES", "Lkotlin/Function0;", "Lnet/minecraft/world/item/Item$Properties;", "getDEFAULT_PROPERTIES", "()Lkotlin/jvm/functions/Function0;", "MAX_DAMAGE", "", "handleIncomingDamage", "", "event", "Lnet/neoforged/neoforge/event/entity/living/LivingDamageEvent$Pre;", "geneticsresequenced-1.21.1"})
    @SourceDebugExtension(value={"SMAP\nDragonHealthCrystal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DragonHealthCrystal.kt\ndev/aaronhowser/mods/geneticsresequenced/item/DragonHealthCrystal$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n774#2:78\n865#2,2:79\n*S KotlinDebug\n*F\n+ 1 DragonHealthCrystal.kt\ndev/aaronhowser/mods/geneticsresequenced/item/DragonHealthCrystal$Companion\n*L\n56#1:78\n56#1:79,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Function0<Item.Properties> getDEFAULT_PROPERTIES() {
            return DEFAULT_PROPERTIES;
        }

        /*
         * WARNING - void declaration
         */
        public final void handleIncomingDamage(@NotNull LivingDamageEvent.Pre event) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            RegistryAccess registryAccess = event.getEntity().registryAccess();
            Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
            Holder.Reference<Gene> enderDragonHealth2 = ModGenes.INSTANCE.getHolderOrThrow(ModGenes.ENDER_DRAGON_HEALTH, (HolderLookup.Provider)registryAccess);
            if (Gene.Companion.isDisabled((Holder<Gene>)((Holder)enderDragonHealth2))) {
                return;
            }
            if (event.getContainer().getNewDamage() == 0.0f) {
                return;
            }
            LivingEntity entity = event.getEntity();
            Intrinsics.checkNotNull((Object)entity);
            if (AaronExtensions.INSTANCE.isClientSide((Entity)entity)) {
                return;
            }
            if (!GenesData.Companion.hasGene((Entity)entity, ModGenes.ENDER_DRAGON_HEALTH)) {
                return;
            }
            Iterable iterable = entity.getHandSlots();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getHandSlots(...)");
            Set heldStacks = CollectionsKt.toMutableSet((Iterable)iterable);
            if (entity instanceof Player) {
                Collection collection = heldStacks;
                NonNullList nonNullList = ((Player)entity).getInventory().items;
                Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"items");
                CollectionsKt.addAll((Collection)collection, (Iterable)((Iterable)nonNullList));
            }
            Iterable $this$filter$iv = heldStacks;
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ItemStack it = (ItemStack)element$iv$iv;
                boolean bl = false;
                if (!it.is((Holder)ModItems.INSTANCE.getDRAGON_HEALTH_CRYSTAL())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List healthCrystals = (List)destination$iv$iv;
            if (healthCrystals.isEmpty()) {
                return;
            }
            for (ItemStack crystal : healthCrystals) {
                Float f = (Float)crystal.get((Supplier)ModDataComponents.INSTANCE.getDRAGON_HEALTH_CRYSTAL_DAMAGE());
                if (f == null) {
                    continue;
                }
                float damageLeft = f.floatValue();
                float amountToRemove = Math.min(event.getContainer().getNewDamage(), damageLeft);
                DamageContainer $i$f$filterTo2 = event.getContainer();
                $i$f$filterTo2.setNewDamage($i$f$filterTo2.getNewDamage() - amountToRemove);
                float newDamage = damageLeft - amountToRemove;
                crystal.set((Supplier)ModDataComponents.INSTANCE.getDRAGON_HEALTH_CRYSTAL_DAMAGE(), (Object)Float.valueOf(newDamage));
                if (!(newDamage <= 0.0f)) continue;
                crystal.shrink(1);
                entity.onEquippedItemBroken(crystal.getItem(), entity.getEquipmentSlotForItem(crystal));
            }
            if (event.getContainer().getNewDamage() < 0.0f) {
                event.getContainer().setNewDamage(0.0f);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

