/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.item;

import dev.aaronhowser.mods.geneticsresequenced.attachment.GenesData;
import dev.aaronhowser.mods.geneticsresequenced.data.EntityGenes;
import dev.aaronhowser.mods.geneticsresequenced.datagen.lang.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/item/GeneCheckerItem;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "use", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/ItemStack;", "level", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "usedHand", "Lnet/minecraft/world/InteractionHand;", "Companion", "geneticsresequenced-1.21.1"})
public final class GeneCheckerItem
extends Item {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Item.Properties DEFAULT_PROPERTIES;

    public GeneCheckerItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)usedHand, (String)"usedHand");
        ItemStack usedStack = player.getItemInHand(usedHand);
        if (!level.isClientSide) {
            Entity entity = OtherUtil.INSTANCE.getLookedAtEntity((LivingEntity)player);
            LivingEntity livingEntity = entity instanceof LivingEntity ? (LivingEntity)entity : null;
            if (livingEntity == null) {
                livingEntity = (LivingEntity)player;
            }
            LivingEntity targetEntity = livingEntity;
            GeneCheckerItem.Companion.tellHeldGenes(player, targetEntity);
            GeneCheckerItem.Companion.tellPossibleGenes(player, targetEntity);
        }
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.success((Object)usedStack);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"success(...)");
        return interactionResultHolder;
    }

    static {
        Item.Properties properties = new Item.Properties().stacksTo(1);
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"stacksTo(...)");
        DEFAULT_PROPERTIES = properties;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\rH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/item/GeneCheckerItem$Companion;", "", "<init>", "()V", "DEFAULT_PROPERTIES", "Lnet/minecraft/world/item/Item$Properties;", "getDEFAULT_PROPERTIES", "()Lnet/minecraft/world/item/Item$Properties;", "tellHeldGenes", "", "player", "Lnet/minecraft/world/entity/player/Player;", "targetEntity", "Lnet/minecraft/world/entity/LivingEntity;", "tellPossibleGenes", "targetEntityGenes", "geneticsresequenced-1.21.1"})
    @SourceDebugExtension(value={"SMAP\nGeneCheckerItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeneCheckerItem.kt\ndev/aaronhowser/mods/geneticsresequenced/item/GeneCheckerItem$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n1563#2:92\n1634#2,3:93\n*S KotlinDebug\n*F\n+ 1 GeneCheckerItem.kt\ndev/aaronhowser/mods/geneticsresequenced/item/GeneCheckerItem$Companion\n*L\n47#1:92\n47#1:93,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Item.Properties getDEFAULT_PROPERTIES() {
            return DEFAULT_PROPERTIES;
        }

        /*
         * WARNING - void declaration
         */
        private final void tellHeldGenes(Player player, LivingEntity targetEntity) {
            MutableComponent mutableComponent;
            Set<Holder<Gene>> targetGeneHolders = GenesData.Companion.getGeneHolders(targetEntity);
            if (targetGeneHolders.isEmpty()) {
                if (Intrinsics.areEqual((Object)targetEntity, (Object)player)) {
                    mutableComponent = ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.gene_checker.no_genes", new Object[0]);
                } else {
                    Object[] objectArray = new Object[]{targetEntity.getName()};
                    mutableComponent = ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.gene_checker.target.no_genes", objectArray);
                }
            } else {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Object[] objectArray = (Object[])targetGeneHolders;
                OtherUtil otherUtil = OtherUtil.INSTANCE;
                boolean $i$f$map = false;
                void var8_8 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Holder holder = (Holder)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(Gene.Companion.getNameComponent((Holder<Gene>)it));
                }
                MutableComponent genesComponent = otherUtil.componentList((List)destination$iv$iv);
                if (Intrinsics.areEqual((Object)targetEntity, (Object)player)) {
                    objectArray = new Object[]{genesComponent};
                    mutableComponent = ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.gene_checker.list", objectArray);
                } else {
                    objectArray = new Object[]{targetEntity.getName(), genesComponent};
                    mutableComponent = ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.gene_checker.target.list", objectArray);
                }
            }
            MutableComponent component = mutableComponent;
            player.sendSystemMessage((Component)component);
        }

        private final void tellPossibleGenes(Player player, LivingEntity targetEntityGenes) {
            EntityType entityType = targetEntityGenes.getType();
            Intrinsics.checkNotNullExpressionValue((Object)entityType, (String)"getType(...)");
            RegistryAccess registryAccess = player.registryAccess();
            Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
            Map<Holder<Gene>, Integer> possibleGenes = EntityGenes.Companion.getGeneHolderWeights(entityType, (HolderLookup.Provider)registryAccess);
            if (possibleGenes.isEmpty()) {
                Object[] objectArray = new Object[]{targetEntityGenes.getName()};
                player.sendSystemMessage((Component)ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.gene_checker.target.no_possible_genes", objectArray));
                return;
            }
            MutableComponent genesComponent = Component.empty();
            List entries = MapsKt.toList(possibleGenes);
            Object[] objectArray = ((Iterable)entries).iterator();
            int n = 0;
            while (objectArray.hasNext()) {
                int i = n++;
                Pair entry2 = (Pair)objectArray.next();
                Holder geneHolder = (Holder)entry2.component1();
                int weight = ((Number)entry2.component2()).intValue();
                Object[] objectArray2 = new Object[]{Gene.Companion.getName((Holder<Gene>)geneHolder), weight};
                genesComponent.append("\u2022  ").append((Component)ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.gene_weight", objectArray2));
                if (i == CollectionsKt.getLastIndex((List)entries)) continue;
                genesComponent.append("\n");
            }
            objectArray = new Object[]{targetEntityGenes.getName(), genesComponent};
            player.sendSystemMessage((Component)ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.gene_checker.target.possible_genes", objectArray));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

