/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.item;

import dev.aaronhowser.mods.geneticsresequenced.datagen.lang.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.item.SyringeItem;
import dev.aaronhowser.mods.geneticsresequenced.item.components.SpecificEntityItemComponent;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 $2\u00020\u0001:\u0001$B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J0\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\tH\u0016J&\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\u00182\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J(\u0010\u001d\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u000fH\u0016J(\u0010 \u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u000fH\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006%"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/item/MetalSyringeItem;", "Ldev/aaronhowser/mods/geneticsresequenced/item/SyringeItem;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "inventoryTick", "", "pStack", "Lnet/minecraft/world/item/ItemStack;", "pLevel", "Lnet/minecraft/world/level/Level;", "pEntity", "Lnet/minecraft/world/entity/Entity;", "pSlotId", "", "pIsSelected", "", "getUseDuration", "pHolder", "Lnet/minecraft/world/entity/LivingEntity;", "getUseAnimation", "Lnet/minecraft/world/item/UseAnim;", "use", "Lnet/minecraft/world/InteractionResultHolder;", "pPlayer", "Lnet/minecraft/world/entity/player/Player;", "pUsedHand", "Lnet/minecraft/world/InteractionHand;", "onUseTick", "pLivingEntity", "pRemainingUseDuration", "releaseUsing", "pTimeCharged", "getName", "Lnet/minecraft/network/chat/Component;", "Companion", "geneticsresequenced-1.21.1"})
public final class MetalSyringeItem
extends SyringeItem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ResourceLocation SYRINGE_REACH_MODIFIER_RL = OtherUtil.INSTANCE.modResource("syringe_reach_modifier");
    @NotNull
    private static final Item.Properties DEFAULT_PROPERTIES;

    public MetalSyringeItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    public void inventoryTick(@NotNull ItemStack pStack, @NotNull Level pLevel, @NotNull Entity pEntity, int pSlotId, boolean pIsSelected) {
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pEntity, (String)"pEntity");
        if (!pIsSelected) {
            return;
        }
        if (!(pEntity instanceof Player)) {
            return;
        }
        if (pEntity.tickCount % 40 != 0) {
            return;
        }
        if (!SyringeItem.Companion.hasBlood(pStack)) {
            return;
        }
        UUID uUID = SpecificEntityItemComponent.Companion.getEntityUuid(pStack);
        if (uUID == null) {
            return;
        }
        UUID entityUuid = uUID;
        LivingEntity livingEntity = OtherUtil.INSTANCE.getNearbyEntityFromUuid(entityUuid, (LivingEntity)pEntity);
        if (livingEntity == null) {
            return;
        }
        LivingEntity target = livingEntity;
        target.addEffect(new MobEffectInstance(MobEffects.GLOWING, 120, 0, false, false, false));
    }

    @Override
    public int getUseDuration(@NotNull ItemStack pStack, @NotNull LivingEntity pHolder) {
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        Intrinsics.checkNotNullParameter((Object)pHolder, (String)"pHolder");
        return 40;
    }

    @Override
    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack pStack) {
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        return UseAnim.BOW;
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level pLevel, @NotNull Player pPlayer, @NotNull InteractionHand pUsedHand) {
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        Intrinsics.checkNotNullParameter((Object)pUsedHand, (String)"pUsedHand");
        ItemStack itemStack = pPlayer.getItemInHand(pUsedHand);
        pPlayer.startUsingItem(pUsedHand);
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.consume((Object)itemStack);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"consume(...)");
        return interactionResultHolder;
    }

    @Override
    public void onUseTick(@NotNull Level pLevel, @NotNull LivingEntity pLivingEntity, @NotNull ItemStack pStack, int pRemainingUseDuration) {
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pLivingEntity, (String)"pLivingEntity");
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        if (pRemainingUseDuration <= 1) {
            pLivingEntity.stopUsingItem();
            this.releaseUsing(pStack, pLevel, pLivingEntity, pRemainingUseDuration);
        }
    }

    @Override
    public void releaseUsing(@NotNull ItemStack pStack, @NotNull Level pLevel, @NotNull LivingEntity pLivingEntity, int pTimeCharged) {
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pLivingEntity, (String)"pLivingEntity");
        if (!(pLivingEntity instanceof Player)) {
            return;
        }
        if (pTimeCharged > 1) {
            return;
        }
        if (pLivingEntity instanceof FakePlayer) {
            return;
        }
        Entity entity = OtherUtil.INSTANCE.getLookedAtEntity(pLivingEntity);
        LivingEntity livingEntity = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        if (livingEntity == null) {
            return;
        }
        LivingEntity targetEntity = livingEntity;
        if (SyringeItem.Companion.hasBlood(pStack)) {
            MetalSyringeItem.Companion.useFullSyringe(pStack, (Player)pLivingEntity, targetEntity);
        } else {
            MetalSyringeItem.Companion.extractBlood(pStack, targetEntity);
            SyringeItem.Companion.setContaminated(pStack, true);
            targetEntity.hurt(SyringeItem.Companion.damageSourceUseSyringe(pLevel, pLivingEntity), 1.0f);
            targetEntity.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 60));
        }
    }

    @Override
    @NotNull
    public Component getName(@NotNull ItemStack pStack) {
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        return SyringeItem.Companion.hasBlood(pStack) ? (Component)ModLanguageProvider.Companion.toComponent("item.geneticsresequenced.metal_syringe.full", new Object[0]) : (Component)ModLanguageProvider.Companion.toComponent("item.geneticsresequenced.metal_syringe.empty", new Object[0]);
    }

    static {
        Item.Properties properties = new Item.Properties().stacksTo(1).attributes(ItemAttributeModifiers.builder().add(Attributes.ENTITY_INTERACTION_RANGE, new AttributeModifier(SYRINGE_REACH_MODIFIER_RL, 3.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.HAND).build());
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"attributes(...)");
        DEFAULT_PROPERTIES = properties;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0013H\u0002J\u0018\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0013H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/item/MetalSyringeItem$Companion;", "", "<init>", "()V", "SYRINGE_REACH_MODIFIER_RL", "Lnet/minecraft/resources/ResourceLocation;", "getSYRINGE_REACH_MODIFIER_RL", "()Lnet/minecraft/resources/ResourceLocation;", "DEFAULT_PROPERTIES", "Lnet/minecraft/world/item/Item$Properties;", "getDEFAULT_PROPERTIES", "()Lnet/minecraft/world/item/Item$Properties;", "useFullSyringe", "", "syringeStack", "Lnet/minecraft/world/item/ItemStack;", "pPlayer", "Lnet/minecraft/world/entity/player/Player;", "pTarget", "Lnet/minecraft/world/entity/LivingEntity;", "tryInjectBlood", "player", "pInteractionTarget", "extractBlood", "geneticsresequenced-1.21.1"})
    @SourceDebugExtension(value={"SMAP\nMetalSyringeItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetalSyringeItem.kt\ndev/aaronhowser/mods/geneticsresequenced/item/MetalSyringeItem$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,175:1\n827#2:176\n855#2,2:177\n*S KotlinDebug\n*F\n+ 1 MetalSyringeItem.kt\ndev/aaronhowser/mods/geneticsresequenced/item/MetalSyringeItem$Companion\n*L\n151#1:176\n151#1:177,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getSYRINGE_REACH_MODIFIER_RL() {
            return SYRINGE_REACH_MODIFIER_RL;
        }

        @NotNull
        public final Item.Properties getDEFAULT_PROPERTIES() {
            return DEFAULT_PROPERTIES;
        }

        private final void useFullSyringe(ItemStack syringeStack, Player pPlayer, LivingEntity pTarget) {
            UUID uuid = SpecificEntityItemComponent.Companion.getEntityUuid(syringeStack);
            if (!Intrinsics.areEqual((Object)pTarget.getUUID(), (Object)uuid)) {
                return;
            }
            if (SyringeItem.Companion.isContaminated(syringeStack)) {
                if (!pPlayer.level().isClientSide) {
                    pPlayer.sendSystemMessage((Component)ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.metal_syringe.contaminated", new Object[0]));
                }
                return;
            }
            this.tryInjectBlood(syringeStack, pPlayer, pTarget);
        }

        /*
         * WARNING - void declaration
         */
        private final void tryInjectBlood(ItemStack syringeStack, Player player, LivingEntity pInteractionTarget) {
            if (player.level().isClientSide) {
                return;
            }
            UUID uUID = SpecificEntityItemComponent.Companion.getEntityUuid(syringeStack);
            if (uUID == null) {
                return;
            }
            UUID entityUuid = uUID;
            if (!Intrinsics.areEqual((Object)entityUuid, (Object)pInteractionTarget.getUUID())) {
                player.sendSystemMessage((Component)ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.metal_syringe.mismatch", new Object[0]));
                return;
            }
            if (!(pInteractionTarget instanceof Player)) {
                void $this$filterNotTo$iv$iv;
                Set<Holder<Gene>> syringeGenes = SyringeItem.Companion.getGenes(syringeStack);
                Object[] $this$filterNot$iv = (Object[])syringeGenes;
                boolean $i$f$filterNot = false;
                Object[] objectArray = $this$filterNot$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    Holder it = (Holder)element$iv$iv;
                    boolean bl = false;
                    if (((Gene)it.value()).canEntityHave((Entity)pInteractionTarget)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List genesCantAdd = (List)destination$iv$iv;
                for (Holder geneHolder : genesCantAdd) {
                    objectArray = new Object[]{Gene.Companion.getName((Holder<Gene>)geneHolder)};
                    player.sendSystemMessage((Component)ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.metal_syringe.no_mobs", objectArray));
                }
            }
            SyringeItem.Companion.injectEntity(syringeStack, pInteractionTarget);
        }

        private final void extractBlood(ItemStack syringeStack, LivingEntity pInteractionTarget) {
            SpecificEntityItemComponent.Companion.setEntity(syringeStack, pInteractionTarget);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

