/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.item;

import dev.aaronhowser.mods.geneticsresequenced.datagen.lang.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.item.components.PlasmidProgressItemComponent;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModDataComponents;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J.\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/item/PlasmidItem;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "appendHoverText", "", "pStack", "Lnet/minecraft/world/item/ItemStack;", "pContext", "Lnet/minecraft/world/item/Item$TooltipContext;", "pTooltipComponents", "", "Lnet/minecraft/network/chat/Component;", "pTooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "Companion", "geneticsresequenced-1.21.1"})
public final class PlasmidItem
extends Item {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Item.Properties DEFAULT_PROPERTIES;

    public PlasmidItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    public void appendHoverText(@NotNull ItemStack pStack, @NotNull Item.TooltipContext pContext, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pTooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        Intrinsics.checkNotNullParameter((Object)pContext, (String)"pContext");
        Intrinsics.checkNotNullParameter(pTooltipComponents, (String)"pTooltipComponents");
        Intrinsics.checkNotNullParameter((Object)pTooltipFlag, (String)"pTooltipFlag");
        Holder<Gene> geneHolder = Companion.getGene(pStack);
        if (geneHolder == null) {
            MutableComponent mutableComponent = ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.plasmid.empty", new Object[0]).withStyle(ChatFormatting.GRAY);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
            pTooltipComponents.add((Component)mutableComponent);
            return;
        }
        Object[] objectArray = new Object[]{Gene.Companion.getName(geneHolder)};
        MutableComponent mutableComponent = ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.plasmid.gene", objectArray).withStyle(ChatFormatting.GRAY);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
        pTooltipComponents.add((Component)mutableComponent);
        if (Companion.isComplete(pStack)) {
            MutableComponent mutableComponent2 = ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.plasmid.complete", new Object[0]).withStyle(ChatFormatting.GRAY);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"withStyle(...)");
            v3 = pTooltipComponents.add((Component)mutableComponent2);
        } else {
            int amountNeeded = ((Gene)geneHolder.value()).getDnaPointsRequired();
            int amount = Companion.getDnaPoints(pStack);
            Object[] objectArray2 = new Object[]{amount, amountNeeded};
            MutableComponent mutableComponent3 = ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.plasmid.amount", objectArray2).withStyle(ChatFormatting.GRAY);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent3, (String)"withStyle(...)");
            v3 = pTooltipComponents.add((Component)mutableComponent3);
        }
    }

    static {
        Item.Properties properties = new Item.Properties().stacksTo(1);
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"stacksTo(...)");
        DEFAULT_PROPERTIES = properties;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bJ&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0002\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\u0015\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\u0018\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001a2\u0006\u0010\u001b\u001a\u00020\u001cR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001d"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/item/PlasmidItem$Companion;", "", "<init>", "()V", "DEFAULT_PROPERTIES", "Lnet/minecraft/world/item/Item$Properties;", "getDEFAULT_PROPERTIES", "()Lnet/minecraft/world/item/Item$Properties;", "hasGene", "", "itemStack", "Lnet/minecraft/world/item/ItemStack;", "getGene", "Lnet/minecraft/core/Holder;", "Ldev/aaronhowser/mods/geneticsresequenced/gene/Gene;", "setGene", "", "geneHolder", "amount", "", "getDnaPoints", "setDnaPoints", "increaseDnaPoints", "isComplete", "getCompletedPlasmid", "getAllPlasmids", "", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "geneticsresequenced-1.21.1"})
    @SourceDebugExtension(value={"SMAP\nPlasmidItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlasmidItem.kt\ndev/aaronhowser/mods/geneticsresequenced/item/PlasmidItem$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1563#2:114\n1634#2,3:115\n*S KotlinDebug\n*F\n+ 1 PlasmidItem.kt\ndev/aaronhowser/mods/geneticsresequenced/item/PlasmidItem$Companion\n*L\n108#1:114\n108#1:115,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Item.Properties getDEFAULT_PROPERTIES() {
            return DEFAULT_PROPERTIES;
        }

        public final boolean hasGene(@NotNull ItemStack itemStack) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            return itemStack.has((Supplier)ModDataComponents.INSTANCE.getPLASMID_PROGRESS());
        }

        @Nullable
        public final Holder<Gene> getGene(@NotNull ItemStack itemStack) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            PlasmidProgressItemComponent plasmidProgressItemComponent = (PlasmidProgressItemComponent)itemStack.get((Supplier)ModDataComponents.INSTANCE.getPLASMID_PROGRESS());
            return plasmidProgressItemComponent != null ? plasmidProgressItemComponent.getGeneHolder() : null;
        }

        public final void setGene(@NotNull ItemStack itemStack, @NotNull Holder<Gene> geneHolder, int amount) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            Intrinsics.checkNotNullParameter(geneHolder, (String)"geneHolder");
            PlasmidProgressItemComponent component = new PlasmidProgressItemComponent(geneHolder, amount);
            itemStack.set((Supplier)ModDataComponents.INSTANCE.getPLASMID_PROGRESS(), (Object)component);
        }

        public static /* synthetic */ void setGene$default(Companion companion, ItemStack itemStack, Holder holder, int n, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = 0;
            }
            companion.setGene(itemStack, (Holder<Gene>)holder, n);
        }

        public final int getDnaPoints(@NotNull ItemStack itemStack) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            PlasmidProgressItemComponent plasmidProgressItemComponent = (PlasmidProgressItemComponent)itemStack.get((Supplier)ModDataComponents.INSTANCE.getPLASMID_PROGRESS());
            return plasmidProgressItemComponent != null ? plasmidProgressItemComponent.getDnaPoints() : 0;
        }

        public final void setDnaPoints(@NotNull ItemStack itemStack, int amount) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            Holder<Gene> holder = this.getGene(itemStack);
            if (holder == null) {
                return;
            }
            PlasmidProgressItemComponent component = new PlasmidProgressItemComponent(holder, amount);
            itemStack.set((Supplier)ModDataComponents.INSTANCE.getPLASMID_PROGRESS(), (Object)component);
        }

        public final void increaseDnaPoints(@NotNull ItemStack itemStack, int amount) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            this.setDnaPoints(itemStack, this.getDnaPoints(itemStack) + amount);
        }

        public static /* synthetic */ void increaseDnaPoints$default(Companion companion, ItemStack itemStack, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 1;
            }
            companion.increaseDnaPoints(itemStack, n);
        }

        public final boolean isComplete(@NotNull ItemStack itemStack) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            Holder<Gene> holder = this.getGene(itemStack);
            if (holder == null) {
                return false;
            }
            Holder<Gene> geneHolder = holder;
            return this.getDnaPoints(itemStack) >= ((Gene)geneHolder.value()).getDnaPointsRequired();
        }

        @NotNull
        public final ItemStack getCompletedPlasmid(@NotNull Holder<Gene> geneHolder) {
            ItemStack itemStack;
            Intrinsics.checkNotNullParameter(geneHolder, (String)"geneHolder");
            ItemStack $this$getCompletedPlasmid_u24lambda_u240 = itemStack = ModItems.INSTANCE.getPLASMID().toStack();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)$this$getCompletedPlasmid_u24lambda_u240);
            Companion.setGene($this$getCompletedPlasmid_u24lambda_u240, geneHolder, ((Gene)geneHolder.value()).getDnaPointsRequired());
            ItemStack itemStack2 = itemStack;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"apply(...)");
            return itemStack2;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<ItemStack> getAllPlasmids(@NotNull HolderLookup.Provider registries) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
            Iterable $this$map$iv = ModGenes.getRegistrySorted$default(ModGenes.INSTANCE, registries, false, false, 4, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Holder holder = (Holder)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Companion.getCompletedPlasmid((Holder<Gene>)it));
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

