/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.item;

import dev.aaronhowser.mods.geneticsresequenced.datagen.lang.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.datagen.tag.ModDamageTypeTagsProvider;
import dev.aaronhowser.mods.geneticsresequenced.datagen.tag.ModEntityTypeTagsProvider;
import dev.aaronhowser.mods.geneticsresequenced.enchantment.ModEnchantments;
import dev.aaronhowser.mods.geneticsresequenced.item.EntityDnaItem;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000eH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\bH\u0016\u00a8\u0006\u0019"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/item/ScraperItem;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "use", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/ItemStack;", "pLevel", "Lnet/minecraft/world/level/Level;", "pPlayer", "Lnet/minecraft/world/entity/player/Player;", "pInteractionHand", "Lnet/minecraft/world/InteractionHand;", "interactLivingEntity", "Lnet/minecraft/world/InteractionResult;", "pStack", "pInteractionTarget", "Lnet/minecraft/world/entity/LivingEntity;", "pUsedHand", "getEnchantmentValue", "", "stack", "Companion", "geneticsresequenced-1.21.1"})
public final class ScraperItem
extends Item {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Item.Properties DEFAULT_PROPERTIES;

    public ScraperItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level pLevel, @NotNull Player pPlayer, @NotNull InteractionHand pInteractionHand) {
        InteractionResultHolder interactionResultHolder;
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        Intrinsics.checkNotNullParameter((Object)pInteractionHand, (String)"pInteractionHand");
        ItemStack realStack = pPlayer.getItemInHand(pInteractionHand);
        if (pLevel.isClientSide) {
            InteractionResultHolder interactionResultHolder2 = InteractionResultHolder.pass((Object)realStack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder2, (String)"pass(...)");
            return interactionResultHolder2;
        }
        if (pPlayer.isCrouching()) {
            Intrinsics.checkNotNull((Object)realStack);
            return ScraperItem.Companion.tryScrapeSelf(pPlayer, realStack);
        }
        Entity entity = OtherUtil.INSTANCE.getLookedAtEntity((LivingEntity)pPlayer);
        if (entity == null) {
            InteractionResultHolder interactionResultHolder3 = InteractionResultHolder.pass((Object)realStack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder3, (String)"pass(...)");
            return interactionResultHolder3;
        }
        Entity lookedAtEntity = entity;
        ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
        Intrinsics.checkNotNull((Object)realStack);
        boolean scrapeWorked = ScraperItem.Companion.scrapeEntity(serverPlayer, realStack, lookedAtEntity);
        if (scrapeWorked) {
            InteractionResultHolder interactionResultHolder4 = InteractionResultHolder.success((Object)realStack);
            Intrinsics.checkNotNull((Object)interactionResultHolder4);
            interactionResultHolder = interactionResultHolder4;
        } else {
            InteractionResultHolder interactionResultHolder5 = InteractionResultHolder.pass((Object)realStack);
            Intrinsics.checkNotNull((Object)interactionResultHolder5);
            interactionResultHolder = interactionResultHolder5;
        }
        return interactionResultHolder;
    }

    @NotNull
    public InteractionResult interactLivingEntity(@NotNull ItemStack pStack, @NotNull Player pPlayer, @NotNull LivingEntity pInteractionTarget, @NotNull InteractionHand pUsedHand) {
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        Intrinsics.checkNotNullParameter((Object)pInteractionTarget, (String)"pInteractionTarget");
        Intrinsics.checkNotNullParameter((Object)pUsedHand, (String)"pUsedHand");
        if (!(pPlayer instanceof ServerPlayer)) {
            return InteractionResult.PASS;
        }
        if (pInteractionTarget.getType().is(ModEntityTypeTagsProvider.Companion.getSCRAPER_ENTITY_BLACKLIST())) {
            ((ServerPlayer)pPlayer).sendSystemMessage((Component)ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.scraper.cant_scrape", new Object[0]));
            return InteractionResult.CONSUME;
        }
        return ScraperItem.Companion.scrapeEntity((ServerPlayer)pPlayer, pStack, (Entity)pInteractionTarget) ? InteractionResult.SUCCESS : InteractionResult.CONSUME;
    }

    public int getEnchantmentValue(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return 5;
    }

    static {
        Item.Properties properties = new Item.Properties().durability(200);
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"durability(...)");
        DEFAULT_PROPERTIES = properties;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0002J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001c\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/item/ScraperItem$Companion;", "", "<init>", "()V", "DEFAULT_PROPERTIES", "Lnet/minecraft/world/item/Item$Properties;", "getDEFAULT_PROPERTIES", "()Lnet/minecraft/world/item/Item$Properties;", "tryScrapeSelf", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/ItemStack;", "pPlayer", "Lnet/minecraft/world/entity/player/Player;", "realStack", "scrapeEntity", "", "player", "Lnet/minecraft/server/level/ServerPlayer;", "stack", "target", "Lnet/minecraft/world/entity/Entity;", "getDamageSource", "Lnet/minecraft/world/damagesource/DamageSource;", "level", "Lnet/minecraft/world/level/Level;", "source", "Lnet/minecraft/world/entity/LivingEntity;", "geneticsresequenced-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Item.Properties getDEFAULT_PROPERTIES() {
            return DEFAULT_PROPERTIES;
        }

        private final InteractionResultHolder<ItemStack> tryScrapeSelf(Player pPlayer, ItemStack realStack) {
            InteractionResultHolder interactionResultHolder;
            if (pPlayer instanceof FakePlayer) {
                InteractionResultHolder interactionResultHolder2 = InteractionResultHolder.pass((Object)realStack);
                Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder2, (String)"pass(...)");
                return interactionResultHolder2;
            }
            if (!(pPlayer instanceof ServerPlayer)) {
                InteractionResultHolder interactionResultHolder3 = InteractionResultHolder.pass((Object)realStack);
                Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder3, (String)"pass(...)");
                return interactionResultHolder3;
            }
            boolean scrapeWorked = this.scrapeEntity((ServerPlayer)pPlayer, realStack, (Entity)pPlayer);
            if (scrapeWorked) {
                InteractionResultHolder interactionResultHolder4 = InteractionResultHolder.success((Object)realStack);
                Intrinsics.checkNotNull((Object)interactionResultHolder4);
                interactionResultHolder = interactionResultHolder4;
            } else {
                InteractionResultHolder interactionResultHolder5 = InteractionResultHolder.pass((Object)realStack);
                Intrinsics.checkNotNull((Object)interactionResultHolder5);
                interactionResultHolder = interactionResultHolder5;
            }
            return interactionResultHolder;
        }

        private final boolean scrapeEntity(ServerPlayer player, ItemStack stack, Entity target) {
            boolean hasDelicateTouch;
            if (player.getCooldowns().isOnCooldown((Item)ModItems.INSTANCE.getSCRAPER().get())) {
                return false;
            }
            if (target instanceof LivingEntity && ((LivingEntity)target).hurtTime > 0) {
                return false;
            }
            ItemStack organicStack = ModItems.INSTANCE.getORGANIC_MATTER().toStack();
            Intrinsics.checkNotNull((Object)organicStack);
            EntityType entityType = target.getType();
            Intrinsics.checkNotNullExpressionValue((Object)entityType, (String)"getType(...)");
            boolean successfullySetEntity = EntityDnaItem.Companion.setEntityType(organicStack, entityType);
            if (!successfullySetEntity) {
                Object[] objectArray = new Object[]{target.getType().getDescription()};
                player.displayClientMessage((Component)ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.scraper.cant_scrape", objectArray), true);
                return false;
            }
            if (!player.getInventory().add(organicStack)) {
                player.drop(organicStack, false);
            }
            boolean bl = hasDelicateTouch = stack.getEnchantmentLevel(ModEnchantments.INSTANCE.getDelicateTouchHolder((Entity)player)) != 0;
            if (hasDelicateTouch) {
                player.getCooldowns().addCooldown((Item)ModItems.INSTANCE.getSCRAPER().get(), 10);
            } else {
                Level level = player.level();
                Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
                target.hurt(this.getDamageSource(level, (LivingEntity)player), 1.0f);
            }
            EquipmentSlot equipmentSlot = player.getEquipmentSlotForItem(stack);
            stack.hurtAndBreak(1, (LivingEntity)player, equipmentSlot);
            return true;
        }

        private final DamageSource getDamageSource(Level level, LivingEntity source) {
            DamageSource damageSource = level.damageSources().source(ModDamageTypeTagsProvider.Companion.getUSE_SCRAPER(), (Entity)source);
            Intrinsics.checkNotNullExpressionValue((Object)damageSource, (String)"source(...)");
            return damageSource;
        }

        static /* synthetic */ DamageSource getDamageSource$default(Companion companion, Level level, LivingEntity livingEntity, int n, Object object) {
            if ((n & 2) != 0) {
                livingEntity = null;
            }
            return companion.getDamageSource(level, livingEntity);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

