/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.item;

import dev.aaronhowser.mods.aaron.AaronExtensions;
import dev.aaronhowser.mods.geneticsresequenced.attachment.GenesData;
import dev.aaronhowser.mods.geneticsresequenced.datagen.lang.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.datagen.tag.ModDamageTypeTagsProvider;
import dev.aaronhowser.mods.geneticsresequenced.datagen.tag.ModItemTagsProvider;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.item.components.SpecificEntityItemComponent;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModDataComponents;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 %2\u00020\u0001:\u0001%B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0016J&\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u0007H\u0016J(\u0010\u001a\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0007H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\b\u001a\u00020\tH\u0016J.\u0010\u001e\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001d0\"2\u0006\u0010#\u001a\u00020$H\u0016\u00a8\u0006&"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/item/SyringeItem;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "getUseDuration", "", "pStack", "Lnet/minecraft/world/item/ItemStack;", "pHolder", "Lnet/minecraft/world/entity/LivingEntity;", "getUseAnimation", "Lnet/minecraft/world/item/UseAnim;", "use", "Lnet/minecraft/world/InteractionResultHolder;", "pLevel", "Lnet/minecraft/world/level/Level;", "pPlayer", "Lnet/minecraft/world/entity/player/Player;", "pUsedHand", "Lnet/minecraft/world/InteractionHand;", "onUseTick", "", "pLivingEntity", "pRemainingUseDuration", "releaseUsing", "pTimeCharged", "getName", "Lnet/minecraft/network/chat/Component;", "appendHoverText", "pContext", "Lnet/minecraft/world/item/Item$TooltipContext;", "pTooltipComponents", "", "pTooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "Companion", "geneticsresequenced-1.21.1"})
public class SyringeItem
extends Item {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Item.Properties DEFAULT_PROPERTIES;

    public SyringeItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    public int getUseDuration(@NotNull ItemStack pStack, @NotNull LivingEntity pHolder) {
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        Intrinsics.checkNotNullParameter((Object)pHolder, (String)"pHolder");
        return 40;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack pStack) {
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        return UseAnim.BOW;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level pLevel, @NotNull Player pPlayer, @NotNull InteractionHand pUsedHand) {
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        Intrinsics.checkNotNullParameter((Object)pUsedHand, (String)"pUsedHand");
        ItemStack realStack = pPlayer.getItemInHand(pUsedHand);
        pPlayer.startUsingItem(pUsedHand);
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.consume((Object)realStack);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"consume(...)");
        return interactionResultHolder;
    }

    public void onUseTick(@NotNull Level pLevel, @NotNull LivingEntity pLivingEntity, @NotNull ItemStack pStack, int pRemainingUseDuration) {
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pLivingEntity, (String)"pLivingEntity");
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        if (pRemainingUseDuration <= 1) {
            pLivingEntity.stopUsingItem();
            this.releaseUsing(pStack, pLevel, pLivingEntity, pRemainingUseDuration);
        }
    }

    public void releaseUsing(@NotNull ItemStack pStack, @NotNull Level pLevel, @NotNull LivingEntity pLivingEntity, int pTimeCharged) {
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pLivingEntity, (String)"pLivingEntity");
        if (!(pLivingEntity instanceof Player) || pTimeCharged > 1) {
            return;
        }
        if (pLivingEntity instanceof FakePlayer) {
            return;
        }
        if (Companion.isContaminated(pStack)) {
            if (!pLevel.isClientSide) {
                pLivingEntity.sendSystemMessage((Component)ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.syringe.contaminated", new Object[0]));
            }
            return;
        }
        if (Companion.hasBlood(pStack)) {
            Companion.injectEntity(pStack, pLivingEntity);
        } else {
            dev.aaronhowser.mods.geneticsresequenced.item.SyringeItem$Companion.setEntity$default(Companion, pStack, pLivingEntity, false, 4, null);
        }
        LivingEntity livingEntity = pLivingEntity;
        Player $this$releaseUsing_u24lambda_u240 = (Player)livingEntity;
        boolean bl = false;
        $this$releaseUsing_u24lambda_u240.hurt(Companion.damageSourceUseSyringe(pLevel, pLivingEntity), 1.0f);
        $this$releaseUsing_u24lambda_u240.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 60));
        $this$releaseUsing_u24lambda_u240.getCooldowns().addCooldown((Item)ModItems.INSTANCE.getSYRINGE().get(), 10);
    }

    @NotNull
    public Component getName(@NotNull ItemStack pStack) {
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        return Companion.hasBlood(pStack) ? (Component)ModLanguageProvider.Companion.toComponent("item.geneticsresequenced.syringe.full", new Object[0]) : (Component)ModLanguageProvider.Companion.toComponent("item.geneticsresequenced.syringe.empty", new Object[0]);
    }

    public void appendHoverText(@NotNull ItemStack pStack, @NotNull Item.TooltipContext pContext, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pTooltipFlag) {
        Set<Holder<Gene>> removingGenes;
        Set<Holder<Gene>> addingGenes;
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        Intrinsics.checkNotNullParameter((Object)pContext, (String)"pContext");
        Intrinsics.checkNotNullParameter(pTooltipComponents, (String)"pTooltipComponents");
        Intrinsics.checkNotNullParameter((Object)pTooltipFlag, (String)"pTooltipFlag");
        Component bloodOwner = Companion.getEntityName(pStack);
        if (Companion.hasBlood(pStack) && bloodOwner != null) {
            Object[] objectArray = new Object[]{bloodOwner};
            MutableComponent mutableComponent = ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.syringe.blood_owner", objectArray).withStyle(ChatFormatting.GRAY);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
            pTooltipComponents.add((Component)mutableComponent);
        }
        if (Companion.isContaminated(pStack)) {
            MutableComponent mutableComponent = ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.syringe.contaminated", new Object[0]).withStyle(ChatFormatting.DARK_GREEN);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
            pTooltipComponents.add((Component)mutableComponent);
        }
        if (!((Collection)(addingGenes = Companion.getGenes(pStack))).isEmpty()) {
            MutableComponent mutableComponent = ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.syringe.adding", new Object[0]).withStyle(ChatFormatting.GRAY);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
            pTooltipComponents.add((Component)mutableComponent);
            for (Holder holder : addingGenes) {
                MutableComponent nameComponent = Gene.Companion.getName((Holder<Gene>)holder);
                MutableComponent component = Component.literal((String)"\u2022 ").withStyle(arg_0 -> SyringeItem.appendHoverText$lambda$1(nameComponent, arg_0)).append((Component)nameComponent);
                Intrinsics.checkNotNull((Object)component);
                pTooltipComponents.add((Component)component);
            }
        }
        if (!((Collection)(removingGenes = Companion.getAntigenes(pStack))).isEmpty()) {
            MutableComponent mutableComponent = ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.syringe.removing", new Object[0]).withStyle(ChatFormatting.GRAY);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
            pTooltipComponents.add((Component)mutableComponent);
            for (Holder<Gene> geneHolder : removingGenes) {
                MutableComponent nameComponent = Gene.Companion.getName(geneHolder);
                MutableComponent component = Component.literal((String)"\u2022 ").withStyle(arg_0 -> SyringeItem.appendHoverText$lambda$2(nameComponent, arg_0)).append((Component)nameComponent);
                Intrinsics.checkNotNull((Object)component);
                pTooltipComponents.add((Component)component);
            }
        }
    }

    private static final Style appendHoverText$lambda$1(MutableComponent $nameComponent, Style it) {
        return it.withColor($nameComponent.getStyle().getColor());
    }

    private static final Style appendHoverText$lambda$2(MutableComponent $nameComponent, Style it) {
        return it.withColor($nameComponent.getStyle().getColor());
    }

    static {
        Item.Properties properties = new Item.Properties().stacksTo(1);
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"stacksTo(...)");
        DEFAULT_PROPERTIES = properties;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\b\u001a\u00020\t*\u00020\nJ\u0018\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u0012\u001a\u00020\tJ\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\f\u001a\u00020\nH\u0002J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\f\u001a\u00020\nJ\u0016\u0010\u0017\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ$\u0010\u0018\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b0\u001aH\u0002J$\u0010\u001d\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b0\u001aH\u0002J\u000e\u0010\u001f\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\nJ\u001a\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b0\u001a2\u0006\u0010\f\u001a\u00020\nJ\u001a\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\"0\u001a2\u0006\u0010\f\u001a\u00020\nJ\u001c\u0010#\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\n2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bJ\u001c\u0010%\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\n2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bJ\u0010\u0010&\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\nH\u0002J\u0010\u0010'\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\nH\u0002J\u000e\u0010(\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\nJ\u0016\u0010\u0012\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\n2\u0006\u0010)\u001a\u00020\tJ\u001a\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b0\u001a2\u0006\u0010\f\u001a\u00020\nJ\u001c\u0010+\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\n2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bJ\u001c\u0010,\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\n2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bJ\u0018\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u00010\u000eJ\u0018\u00102\u001a\u00020.2\u0006\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u00010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u00063"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/item/SyringeItem$Companion;", "", "<init>", "()V", "DEFAULT_PROPERTIES", "Lnet/minecraft/world/item/Item$Properties;", "getDEFAULT_PROPERTIES", "()Lnet/minecraft/world/item/Item$Properties;", "isSyringe", "", "Lnet/minecraft/world/item/ItemStack;", "isBeingUsed", "syringeStack", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "setEntity", "", "stack", "setContaminated", "getEntityUuid", "Ljava/util/UUID;", "getEntityName", "Lnet/minecraft/network/chat/Component;", "injectEntity", "removeGenes", "syringeAntigenes", "", "Lnet/minecraft/core/Holder;", "Ldev/aaronhowser/mods/geneticsresequenced/gene/Gene;", "addGenes", "syringeGenes", "hasBlood", "getGenes", "getGeneRks", "Lnet/minecraft/resources/ResourceKey;", "canAddGene", "gene", "addGene", "clearGenes", "clearAntigenes", "isContaminated", "value", "getAntigenes", "canAddAntigene", "addAntigene", "damageSourceStepOnSyringe", "Lnet/minecraft/world/damagesource/DamageSource;", "level", "Lnet/minecraft/world/level/Level;", "thrower", "damageSourceUseSyringe", "geneticsresequenced-1.21.1"})
    @SourceDebugExtension(value={"SMAP\nSyringeItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyringeItem.kt\ndev/aaronhowser/mods/geneticsresequenced/item/SyringeItem$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,341:1\n774#2:342\n865#2,2:343\n1617#2,9:345\n1869#2:354\n1870#2:356\n1626#2:357\n1#3:355\n*S KotlinDebug\n*F\n+ 1 SyringeItem.kt\ndev/aaronhowser/mods/geneticsresequenced/item/SyringeItem$Companion\n*L\n193#1:342\n193#1:343,2\n275#1:345,9\n275#1:354\n275#1:356\n275#1:357\n275#1:355\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Item.Properties getDEFAULT_PROPERTIES() {
            return DEFAULT_PROPERTIES;
        }

        public final boolean isSyringe(@NotNull ItemStack $this$isSyringe) {
            Intrinsics.checkNotNullParameter((Object)$this$isSyringe, (String)"<this>");
            return $this$isSyringe.is(ModItemTagsProvider.Companion.getSYRINGES());
        }

        public final boolean isBeingUsed(@NotNull ItemStack syringeStack, @Nullable LivingEntity entity) {
            Intrinsics.checkNotNullParameter((Object)syringeStack, (String)"syringeStack");
            LivingEntity livingEntity = entity;
            return Intrinsics.areEqual((Object)(livingEntity != null ? livingEntity.getUseItem() : null), (Object)syringeStack);
        }

        public final void setEntity(@NotNull ItemStack stack, @Nullable LivingEntity entity, boolean setContaminated) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            if (entity == null) {
                stack.remove((Supplier)ModDataComponents.INSTANCE.getSPECIFIC_ENTITY());
                return;
            }
            SpecificEntityItemComponent.Companion.setEntity(stack, entity);
            if (setContaminated) {
                this.setContaminated(stack, true);
            }
        }

        public static /* synthetic */ void setEntity$default(Companion companion, ItemStack itemStack, LivingEntity livingEntity, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = true;
            }
            companion.setEntity(itemStack, livingEntity, bl);
        }

        private final UUID getEntityUuid(ItemStack syringeStack) {
            return SpecificEntityItemComponent.Companion.getEntityUuid(syringeStack);
        }

        @Nullable
        public final Component getEntityName(@NotNull ItemStack syringeStack) {
            Intrinsics.checkNotNullParameter((Object)syringeStack, (String)"syringeStack");
            return SpecificEntityItemComponent.Companion.getEntityName(syringeStack);
        }

        /*
         * WARNING - void declaration
         */
        public final void injectEntity(@NotNull ItemStack syringeStack, @NotNull LivingEntity entity) {
            Set set;
            Intrinsics.checkNotNullParameter((Object)syringeStack, (String)"syringeStack");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            UUID uUID = this.getEntityUuid(syringeStack);
            if (uUID == null) {
                return;
            }
            UUID syringeEntityUuid = uUID;
            if (!Intrinsics.areEqual((Object)entity.getUUID(), (Object)syringeEntityUuid)) {
                return;
            }
            if (entity instanceof Player) {
                set = this.getGenes(syringeStack);
            } else {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = this.getGenes(syringeStack);
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Holder it = (Holder)element$iv$iv;
                    boolean bl = false;
                    if (!((Gene)it.value()).getAllowsMobs()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            }
            Set genesToAdd = set;
            Set<Holder<Gene>> genesToRemove = this.getAntigenes(syringeStack);
            this.addGenes(entity, genesToAdd);
            this.removeGenes(entity, genesToRemove);
            this.clearGenes(syringeStack);
            this.clearAntigenes(syringeStack);
            dev.aaronhowser.mods.geneticsresequenced.item.SyringeItem$Companion.setEntity$default(this, syringeStack, null, false, 4, null);
        }

        private final void removeGenes(LivingEntity entity, Set<? extends Holder<Gene>> syringeAntigenes) {
            Set<Holder<Gene>> entityGenesBefore = GenesData.Companion.getGeneHolders(entity);
            for (Holder<Gene> holder : syringeAntigenes) {
                GenesData.Companion.removeGene(entity, holder);
            }
            Set<Holder<Gene>> entityGenesAfter = GenesData.Companion.getGeneHolders(entity);
            Set set = SetsKt.minus(entityGenesBefore, (Iterable)entityGenesAfter);
            Set genesNotRemoved = SetsKt.minus(syringeAntigenes, (Iterable)set);
            if (!entity.level().isClientSide) {
                Object[] objectArray;
                for (Holder removedGeneHolder : set) {
                    objectArray = new Object[]{Gene.Companion.getName((Holder<Gene>)removedGeneHolder)};
                    entity.sendSystemMessage((Component)ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.syringe.anti_gene.success", objectArray));
                }
                for (Holder notRemovedGeneHolder : genesNotRemoved) {
                    objectArray = new Object[]{Gene.Companion.getNameComponent((Holder<Gene>)notRemovedGeneHolder)};
                    entity.sendSystemMessage((Component)ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.syringe.anti_gene.fail", objectArray));
                }
            }
        }

        private final void addGenes(LivingEntity entity, Set<? extends Holder<Gene>> syringeGenes) {
            Set<Holder<Gene>> entityGenesBefore = GenesData.Companion.getGeneHolders(entity);
            for (Holder<Gene> holder : syringeGenes) {
                GenesData.Companion.addGene(entity, holder);
            }
            Set<Holder<Gene>> entityGenesAfter = GenesData.Companion.getGeneHolders(entity);
            Set set = SetsKt.minus(entityGenesAfter, (Iterable)entityGenesBefore);
            Set genesNotAdded = SetsKt.minus(syringeGenes, (Iterable)set);
            if (!AaronExtensions.INSTANCE.isClientSide((Entity)entity)) {
                Object[] objectArray;
                for (Holder addedGeneHolder : set) {
                    objectArray = new Object[]{Gene.Companion.getNameComponent((Holder<Gene>)addedGeneHolder)};
                    entity.sendSystemMessage((Component)ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.syringe.injected", objectArray));
                }
                for (Holder notAddedGeneHolder : genesNotAdded) {
                    objectArray = new Object[]{Gene.Companion.getNameComponent((Holder<Gene>)notAddedGeneHolder)};
                    entity.sendSystemMessage((Component)ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.syringe.failed", objectArray));
                }
            }
        }

        public final boolean hasBlood(@NotNull ItemStack syringeStack) {
            Intrinsics.checkNotNullParameter((Object)syringeStack, (String)"syringeStack");
            return SpecificEntityItemComponent.Companion.hasEntity(syringeStack);
        }

        @NotNull
        public final Set<Holder<Gene>> getGenes(@NotNull ItemStack syringeStack) {
            Intrinsics.checkNotNullParameter((Object)syringeStack, (String)"syringeStack");
            Object object = (HolderSet)syringeStack.get((Supplier)ModDataComponents.INSTANCE.getGENE_SET());
            if (object == null || (object = CollectionsKt.toSet((Iterable)((Iterable)object))) == null) {
                object = SetsKt.emptySet();
            }
            return object;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Set<ResourceKey<Gene>> getGeneRks(@NotNull ItemStack syringeStack) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)syringeStack, (String)"syringeStack");
            Iterable $this$mapNotNull$iv = this.getGenes(syringeStack);
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                ResourceKey it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Holder it = (Holder)element$iv$iv;
                boolean bl2 = false;
                if (it.getKey() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }

        public final boolean canAddGene(@NotNull ItemStack syringeStack, @NotNull Holder<Gene> gene) {
            Intrinsics.checkNotNullParameter((Object)syringeStack, (String)"syringeStack");
            Intrinsics.checkNotNullParameter(gene, (String)"gene");
            return this.hasBlood(syringeStack) && !this.getGenes(syringeStack).contains(gene);
        }

        public final boolean addGene(@NotNull ItemStack syringeStack, @NotNull Holder<Gene> gene) {
            Intrinsics.checkNotNullParameter((Object)syringeStack, (String)"syringeStack");
            Intrinsics.checkNotNullParameter(gene, (String)"gene");
            if (!this.canAddGene(syringeStack, gene)) {
                return false;
            }
            Set<Holder<Gene>> currentGenes = this.getGenes(syringeStack);
            Set newGenes = SetsKt.plus(currentGenes, gene);
            HolderSet.Direct newHolderSet = HolderSet.direct((List)CollectionsKt.toList((Iterable)newGenes));
            syringeStack.set((Supplier)ModDataComponents.INSTANCE.getGENE_SET(), (Object)newHolderSet);
            return true;
        }

        private final void clearGenes(ItemStack syringeStack) {
            syringeStack.remove((Supplier)ModDataComponents.INSTANCE.getGENE_SET());
        }

        private final void clearAntigenes(ItemStack syringeStack) {
            syringeStack.remove((Supplier)ModDataComponents.INSTANCE.getANTIGENE_SET());
        }

        public final boolean isContaminated(@NotNull ItemStack syringeStack) {
            Intrinsics.checkNotNullParameter((Object)syringeStack, (String)"syringeStack");
            Boolean bl = (Boolean)syringeStack.get((Supplier)ModDataComponents.INSTANCE.getIS_CONTAMINATED());
            return bl != null ? bl : false;
        }

        public final void setContaminated(@NotNull ItemStack syringeStack, boolean value) {
            Intrinsics.checkNotNullParameter((Object)syringeStack, (String)"syringeStack");
            syringeStack.set((Supplier)ModDataComponents.INSTANCE.getIS_CONTAMINATED(), (Object)value);
        }

        @NotNull
        public final Set<Holder<Gene>> getAntigenes(@NotNull ItemStack syringeStack) {
            Intrinsics.checkNotNullParameter((Object)syringeStack, (String)"syringeStack");
            Object object = (HolderSet)syringeStack.get((Supplier)ModDataComponents.INSTANCE.getANTIGENE_SET());
            if (object == null || (object = CollectionsKt.toSet((Iterable)((Iterable)object))) == null) {
                object = SetsKt.emptySet();
            }
            return object;
        }

        public final boolean canAddAntigene(@NotNull ItemStack syringeStack, @NotNull Holder<Gene> gene) {
            Intrinsics.checkNotNullParameter((Object)syringeStack, (String)"syringeStack");
            Intrinsics.checkNotNullParameter(gene, (String)"gene");
            return this.hasBlood(syringeStack) && !this.getAntigenes(syringeStack).contains(gene) && !this.getGenes(syringeStack).contains(gene);
        }

        public final boolean addAntigene(@NotNull ItemStack syringeStack, @NotNull Holder<Gene> gene) {
            Intrinsics.checkNotNullParameter((Object)syringeStack, (String)"syringeStack");
            Intrinsics.checkNotNullParameter(gene, (String)"gene");
            if (!this.canAddAntigene(syringeStack, gene)) {
                return false;
            }
            Set<Holder<Gene>> currentAntigenes = this.getAntigenes(syringeStack);
            Set newGenes = SetsKt.plus(currentAntigenes, gene);
            HolderSet.Direct holderSet = HolderSet.direct((List)CollectionsKt.toList((Iterable)newGenes));
            syringeStack.set((Supplier)ModDataComponents.INSTANCE.getANTIGENE_SET(), (Object)holderSet);
            return true;
        }

        @NotNull
        public final DamageSource damageSourceStepOnSyringe(@NotNull Level level, @Nullable LivingEntity thrower) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            DamageSource damageSource = level.damageSources().source(ModDamageTypeTagsProvider.Companion.getSTEP_ON_SYRINGE(), (Entity)thrower);
            Intrinsics.checkNotNullExpressionValue((Object)damageSource, (String)"source(...)");
            return damageSource;
        }

        @NotNull
        public final DamageSource damageSourceUseSyringe(@NotNull Level level, @Nullable LivingEntity thrower) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            DamageSource damageSource = level.damageSources().source(ModDamageTypeTagsProvider.Companion.getUSE_SYRINGE(), (Entity)thrower);
            Intrinsics.checkNotNullExpressionValue((Object)damageSource, (String)"source(...)");
            return damageSource;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

