/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.menu;

import dev.aaronhowser.mods.aaron.menu.components.FilteredSlot;
import dev.aaronhowser.mods.aaron.menu.components.OutputSlot;
import dev.aaronhowser.mods.geneticsresequenced.menu.MachineMenu;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Holder;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B3\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u0005J\u0006\u0010\u001a\u001a\u00020\u0005J\u0006\u0010\u001b\u001a\u00020\u0014J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0005X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006!"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/menu/CraftingMachineMenu;", "Ldev/aaronhowser/mods/geneticsresequenced/menu/MachineMenu;", "menuType", "Lnet/minecraft/world/inventory/MenuType;", "id", "", "playerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "machineContainer", "Lnet/minecraft/world/Container;", "craftingContainerData", "Lnet/minecraft/world/inventory/ContainerData;", "<init>", "(Lnet/minecraft/world/inventory/MenuType;ILnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/world/Container;Lnet/minecraft/world/inventory/ContainerData;)V", "getMachineContainer", "()Lnet/minecraft/world/Container;", "amountSlots", "getAmountSlots", "()I", "inputFilter", "", "inputStack", "Lnet/minecraft/world/item/ItemStack;", "addSlots", "", "getCurrentProgress", "getMaxProgress", "isCrafting", "getPercentDone", "", "stillValid", "player", "Lnet/minecraft/world/entity/player/Player;", "geneticsresequenced-1.21.1"})
public abstract class CraftingMachineMenu
extends MachineMenu {
    @NotNull
    private final Container machineContainer;
    private final int amountSlots;

    public CraftingMachineMenu(@NotNull MenuType<?> menuType, int id, @NotNull Inventory playerInventory, @NotNull Container machineContainer, @NotNull ContainerData craftingContainerData) {
        Intrinsics.checkNotNullParameter(menuType, (String)"menuType");
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        Intrinsics.checkNotNullParameter((Object)machineContainer, (String)"machineContainer");
        Intrinsics.checkNotNullParameter((Object)craftingContainerData, (String)"craftingContainerData");
        super(menuType, id, playerInventory, craftingContainerData);
        this.machineContainer = machineContainer;
        this.amountSlots = 3;
        AbstractContainerMenu.checkContainerSize((Container)this.machineContainer, (int)this.getAmountSlots());
    }

    @NotNull
    protected final Container getMachineContainer() {
        return this.machineContainer;
    }

    @Override
    protected int getAmountSlots() {
        return this.amountSlots;
    }

    protected boolean inputFilter(@NotNull ItemStack inputStack) {
        Intrinsics.checkNotNullParameter((Object)inputStack, (String)"inputStack");
        return true;
    }

    public void addSlots() {
        FilteredSlot inputSlot2 = new FilteredSlot(this.machineContainer, 0, 63, 42, (Function1)new Function1<ItemStack, Boolean>((Object)this){

            public final Boolean invoke(ItemStack p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((CraftingMachineMenu)((Object)this.receiver)).inputFilter(p0);
            }
        });
        OutputSlot outputSlot = new OutputSlot(this.machineContainer, 1, 110, 42);
        FilteredSlot overclockSlot = new FilteredSlot(this.machineContainer, 2, 26, 54, CraftingMachineMenu::addSlots$lambda$0);
        this.addSlot((Slot)inputSlot2);
        this.addSlot((Slot)outputSlot);
        this.addSlot((Slot)overclockSlot);
    }

    public final int getCurrentProgress() {
        return this.getMachineContainerData().get(2);
    }

    public final int getMaxProgress() {
        return this.getMachineContainerData().get(3);
    }

    public final boolean isCrafting() {
        return this.getCurrentProgress() > 0;
    }

    @Override
    public float getPercentDone() {
        int max = this.getMaxProgress();
        if (max <= 0) {
            return 0.0f;
        }
        return (float)this.getCurrentProgress() / (float)max;
    }

    public boolean stillValid(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this.machineContainer.stillValid(player);
    }

    private static final boolean addSlots$lambda$0(ItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.is((Holder)ModItems.INSTANCE.getOVERCLOCKER());
    }
}

